/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler.rest;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.androidannotations.annotations.rest.Rest;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.RestHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;

public class RestHandler
extends BaseAnnotationHandler<RestHolder>
implements GeneratingAnnotationHandler<RestHolder> {
    private final AnnotationHelper annotationHelper;

    public RestHandler(ProcessingEnvironment processingEnvironment) {
        super(Rest.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public RestHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        return new RestHolder(processHolder, annotatedElement);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.notAlreadyValidated(element, validatedElements, valid);
        this.validatorHelper.hasSpringAndroidJars(element, valid);
        this.validatorHelper.isInterface(typeElement, valid);
        this.validatorHelper.isTopLevel(typeElement, valid);
        this.validatorHelper.doesNotExtendInvalidInterfaces(typeElement, valid);
        this.validatorHelper.unannotatedMethodReturnsRestTemplate(typeElement, valid);
        this.validatorHelper.validateConverters(element, valid);
        this.validatorHelper.validateInterceptors(element, valid);
        this.validatorHelper.hasInternetPermission(typeElement, this.androidManifest, valid);
    }

    @Override
    public void process(Element element, RestHolder holder) {
        this.setRootUrl(element, holder);
        this.setConverters(element, holder);
        this.setInterceptors(element, holder);
    }

    private void setRootUrl(Element element, RestHolder holder) {
        TypeElement typeElement = (TypeElement)element;
        String rootUrl = typeElement.getAnnotation(Rest.class).rootUrl();
        holder.getInit().body().assign(holder.getRootUrlField(), JExpr.lit(rootUrl));
    }

    private void setConverters(Element element, RestHolder holder) {
        List<DeclaredType> converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.getTarget(), "converters");
        JFieldVar restTemplateField = holder.getRestTemplateField();
        JBlock init = holder.getInit().body();
        for (DeclaredType converterType : converters) {
            JClass converterClass = this.refClass(converterType.toString());
            init.add(JExpr.invoke((JExpression)restTemplateField, "getMessageConverters").invoke("add").arg(JExpr._new(converterClass)));
        }
    }

    private void setInterceptors(Element element, RestHolder holder) {
        List<DeclaredType> interceptors = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.getTarget(), "interceptors");
        if (interceptors != null) {
            JClass listClass = this.refClass(CanonicalNameConstants.ARRAYLIST);
            JClass clientInterceptorClass = this.refClass("org.springframework.http.client.ClientHttpRequestInterceptor");
            listClass = listClass.narrow(clientInterceptorClass);
            JFieldVar restTemplateField = holder.getRestTemplateField();
            JBlock init = holder.getInit().body();
            init.add(JExpr.invoke((JExpression)restTemplateField, "setInterceptors").arg(JExpr._new(listClass)));
            for (DeclaredType interceptorType : interceptors) {
                JClass interceptorClass = this.refClass(interceptorType.toString());
                init.add(JExpr.invoke((JExpression)restTemplateField, "getInterceptors").invoke("add").arg(JExpr._new(interceptorClass)));
            }
        }
    }
}

