/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IntentBuilder;
import org.androidannotations.holder.HasIntentBuilder;

public class ActivityIntentBuilder
extends IntentBuilder {
    public ActivityIntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        super(holder, androidManifest);
    }

    @Override
    public void build() throws JClassAlreadyExistsException {
        super.build();
        this.createStart();
        this.createStartForResult();
    }

    private void createStart() {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.codeModel().VOID, "start");
        method.body().invoke((JExpression)this.contextField, "startActivity").arg(this.holder.getIntentField());
    }

    private void createStartForResult() {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.codeModel().VOID, "startForResult");
        JVar requestCode = method.param(this.holder.codeModel().INT, "requestCode");
        JBlock body = method.body();
        JClass activityClass = this.holder.classes().ACTIVITY;
        JConditional condition = null;
        if (this.fragmentSupportField != null) {
            condition = body._if(this.fragmentSupportField.ne(JExpr._null()));
            condition._then().invoke((JExpression)this.fragmentSupportField, "startActivityForResult").arg(this.holder.getIntentField()).arg(requestCode);
        }
        if (this.fragmentField != null) {
            condition = condition == null ? body._if(this.fragmentField.ne(JExpr._null())) : condition._elseif(this.fragmentField.ne(JExpr._null()));
            condition._then().invoke((JExpression)this.fragmentField, "startActivityForResult").arg(this.holder.getIntentField()).arg(requestCode);
        }
        condition = condition == null ? body._if(this.contextField._instanceof(activityClass)) : condition._elseif(this.contextField._instanceof(activityClass));
        condition._then().invoke((JExpression)JExpr.cast(activityClass, this.contextField), "startActivityForResult").arg(this.holder.getIntentField()).arg(requestCode);
        condition._else().invoke((JExpression)this.contextField, "startActivity").arg(this.holder.getIntentField());
    }
}

