/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.annotations.EIntentService;
import org.androidannotations.annotations.ServiceAction;
import org.androidannotations.annotations.Trace;
import org.androidannotations.annotations.ViewById;
import org.androidannotations.annotations.rest.Delete;
import org.androidannotations.annotations.rest.Get;
import org.androidannotations.annotations.rest.Head;
import org.androidannotations.annotations.rest.Options;
import org.androidannotations.annotations.rest.Post;
import org.androidannotations.annotations.rest.Put;
import org.androidannotations.annotations.rest.Rest;
import org.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import org.androidannotations.annotations.sharedpreferences.DefaultFloat;
import org.androidannotations.annotations.sharedpreferences.DefaultInt;
import org.androidannotations.annotations.sharedpreferences.DefaultLong;
import org.androidannotations.annotations.sharedpreferences.DefaultString;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.api.rest.RestClientErrorHandling;
import org.androidannotations.api.rest.RestClientHeaders;
import org.androidannotations.api.rest.RestClientRootUrl;
import org.androidannotations.api.rest.RestClientSupport;
import org.androidannotations.api.sharedpreferences.SharedPreferencesHelper;
import org.androidannotations.helper.ActionBarSherlockHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ValidatorHelper {
    private static final List<String> VALID_REST_INTERFACES = Arrays.asList(RestClientHeaders.class.getName(), RestClientErrorHandling.class.getName(), RestClientRootUrl.class.getName(), RestClientSupport.class.getName());
    private static final List<String> ANDROID_FRAGMENT_QUALIFIED_NAMES = Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment");
    private static final String METHOD_NAME_SET_ROOT_URL = "setRootUrl";
    private static final String METHOD_NAME_SET_AUTHENTICATION = "setAuthentication";
    private static final String METHOD_NAME_GET_COOKIE = "getCookie";
    private static final String METHOD_NAME_GET_HEADER = "getHeader";
    private static final String METHOD_NAME_GET_ROOT_URL = "getRootUrl";
    private static final List<String> VALID_PREF_RETURN_TYPES = Arrays.asList("int", "boolean", "float", "long", CanonicalNameConstants.STRING);
    private static final List<String> INVALID_PREF_METHOD_NAMES = Arrays.asList("edit", "getSharedPreferences", "clear", "getEditor", "apply");
    private static final Collection<Integer> VALID_LOG_LEVELS = Arrays.asList(2, 3, 4, 5, 6);
    protected final TargetAnnotationHelper annotationHelper;
    public final ValidatorParameterHelper param;
    private final ActionBarSherlockHelper thirdPartyLibHelper;
    private static final List<Class<? extends Annotation>> REST_ANNOTATION_CLASSES = Arrays.asList(Get.class, Head.class, Options.class, Post.class, Put.class, Delete.class);

    public ValidatorHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
        this.param = new ValidatorParameterHelper(this.annotationHelper);
        this.thirdPartyLibHelper = new ActionBarSherlockHelper(this.annotationHelper);
    }

    public void isNotFinal(Element element, IsValid valid) {
        if (this.annotationHelper.isFinal(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a final element");
        }
    }

    public void isNotSynchronized(Element element, IsValid valid) {
        if (this.annotationHelper.isSynchronized(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a synchronized element. If you think you shall need to use the synchronized keyword for a specific use case, please post on the mailing list.");
        }
    }

    public void isInterface(TypeElement element, IsValid valid) {
        if (!this.annotationHelper.isInterface(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on an interface");
        }
    }

    public void isTopLevel(TypeElement element, IsValid valid) {
        if (!this.annotationHelper.isTopLevel(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a top level type");
        }
    }

    public void doesNotExtendInvalidInterfaces(TypeElement element, IsValid valid) {
        if (element.getInterfaces().size() > 0) {
            boolean isValid = true;
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (VALID_REST_INTERFACES.contains(((Object)typeMirror).toString())) continue;
                isValid = false;
                break;
            }
            if (!isValid) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s interfaces can only extend the following interfaces: " + VALID_REST_INTERFACES);
            }
        }
    }

    public void doesNotReturnPrimitive(ExecutableElement element, IsValid valid) {
        if (element.getReturnType().getKind().isPrimitive()) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot return primitive");
        }
    }

    public void isNotPrivate(Element element, IsValid valid) {
        if (this.annotationHelper.isPrivate(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a private element");
        }
    }

    public void isPublic(Element element, IsValid valid) {
        if (!this.annotationHelper.isPublic(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a non public element");
        }
    }

    public void enclosingElementHasEBeanAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EBean.class, valid);
    }

    public void enclosingElementHasEActivity(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EActivity.class, valid);
    }

    public void enclosingElementHasEActivityOrEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, validAnnotations, valid);
    }

    public void enclosingElementHasEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EFragment.class, valid);
    }

    public void enclosingElementHasEIntentService(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EIntentService.class, valid);
    }

    public void hasEActivity(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.hasClassAnnotation(element, element, validatedElements, EActivity.class, valid);
    }

    public void hasEActivityOrEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.hasOneOfClassAnnotations(element, element, validatedElements, validAnnotations, valid);
    }

    public void enclosingElementHasEnhancedViewSupportAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, ModelConstants.VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS, valid);
    }

    public void enclosingElementHasEnhancedComponentAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, ModelConstants.VALID_ENHANCED_COMPONENT_ANNOTATIONS, valid);
    }

    private void hasClassAnnotation(Element reportElement, Element element, AnnotationElements validatedElements, Class<? extends Annotation> validAnnotation, IsValid valid) {
        ArrayList<Class<? extends Annotation>> validAnnotations = new ArrayList<Class<? extends Annotation>>();
        validAnnotations.add(validAnnotation);
        this.hasOneOfClassAnnotations(reportElement, element, validatedElements, validAnnotations, valid);
    }

    private void hasOneOfClassAnnotations(Element reportElement, Element element, AnnotationElements validatedElements, List<Class<? extends Annotation>> validAnnotations, IsValid valid) {
        boolean foundAnnotation = false;
        for (Class<? extends Annotation> validAnnotation : validAnnotations) {
            if (element.getAnnotation(validAnnotation) == null) continue;
            Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(validAnnotation.getName());
            if (!layoutAnnotatedElements.contains(element)) {
                valid.invalidate();
            }
            foundAnnotation = true;
            break;
        }
        if (!foundAnnotation) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(reportElement, "%s can only be used in a class annotated with " + this.getFormattedValidEnhancedBeanAnnotationTypes(validAnnotations) + ".");
        }
    }

    private String getFormattedValidEnhancedBeanAnnotationTypes(List<Class<? extends Annotation>> annotations) {
        StringBuilder sb = new StringBuilder();
        if (!annotations.isEmpty()) {
            sb.append(TargetAnnotationHelper.annotationName(annotations.get(0)));
            for (int i = 1; i < annotations.size(); ++i) {
                sb.append(", ");
                sb.append(TargetAnnotationHelper.annotationName(annotations.get(i)));
            }
        }
        return sb.toString();
    }

    public void hasViewByIdAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used with annotation";
        this.elementHasAnnotation(ViewById.class, element, validatedElements, valid, error);
    }

    public void enclosingElementHasRestAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used in an interface annotated with";
        this.enclosingElementHasAnnotation(Rest.class, element, validatedElements, valid, error);
    }

    public void enclosingElementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements, IsValid valid, String error) {
        Element enclosingElement = element.getEnclosingElement();
        this.elementHasAnnotation(annotation, enclosingElement, validatedElements, valid, error);
    }

    public void elementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements, IsValid valid, String error) {
        Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(annotation.getName());
        if (!layoutAnnotatedElements.contains(element)) {
            valid.invalidate();
            if (element.getAnnotation(annotation) == null) {
                this.annotationHelper.printAnnotationError(element, "%s " + error + " " + TargetAnnotationHelper.annotationName(annotation));
            }
        }
    }

    public boolean elementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements) {
        Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(annotation.getName());
        return layoutAnnotatedElements.contains(element);
    }

    public void throwsOnlyRestClientException(ExecutableElement element, IsValid valid) {
        List<? extends TypeMirror> thrownTypes = element.getThrownTypes();
        if (!(thrownTypes.size() <= 0 || thrownTypes.size() <= 1 && ((Object)thrownTypes.get(0)).toString().equals("org.springframework.web.client.RestClientException"))) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only declare throwing a RestClientException");
        }
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, Element element, IsValid valid) {
        TypeMirror elementType = element.asType();
        this.typeHasAnnotation(annotation, elementType, element, valid);
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, TypeMirror elementType, Element reportingElement, IsValid valid) {
        Element typeElement = this.annotationHelper.getTypeUtils().asElement(elementType);
        if (!this.elementHasAnnotationSafe(annotation, typeElement)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(reportingElement, "%s can only be used on an element annotated with " + TargetAnnotationHelper.annotationName(annotation));
        }
    }

    public void typeOrTargetValueHasAnnotation(Class<? extends Annotation> annotation, Element element, IsValid valid) {
        DeclaredType targetAnnotationClassValue = this.annotationHelper.extractAnnotationClassParameter(element);
        if (targetAnnotationClassValue != null) {
            this.typeHasAnnotation(annotation, targetAnnotationClassValue, element, valid);
            if (!this.annotationHelper.getTypeUtils().isAssignable(targetAnnotationClassValue, element.asType())) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The value of %s must be assignable into the annotated field");
            }
        } else {
            this.typeHasAnnotation(annotation, element, valid);
        }
    }

    private boolean elementHasAnnotationSafe(Class<? extends Annotation> annotation, Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    public void hasHttpHeadersReturnType(ExecutableElement element, IsValid valid) {
        String returnType = ((Object)element.getReturnType()).toString();
        if (!returnType.equals("org.springframework.http.HttpHeaders")) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a HttpHeaders, not " + returnType);
        }
    }

    public void hasSetOfHttpMethodReturnType(ExecutableElement element, IsValid valid) {
        TypeMirror returnType = element.getReturnType();
        String returnTypeString = ((Object)returnType).toString();
        if (!returnTypeString.equals("java.util.Set<org.springframework.http.HttpMethod>")) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a Set of HttpMethod, not " + returnTypeString);
        } else {
            DeclaredType declaredType = (DeclaredType)returnType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a parameterized Set (with HttpMethod)");
            } else {
                TypeMirror typeArgument = typeArguments.get(0);
                if (!((Object)typeArgument).toString().equals("org.springframework.http.HttpMethod")) {
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a parameterized Set of HttpMethod, not " + ((Object)typeArgument).toString());
                }
            }
        }
    }

    public void doesntThrowException(Element element, IsValid valid) {
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getThrownTypes().size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods should not declare throwing any exception");
        }
    }

    public void returnTypeIsVoidOrBoolean(ExecutableElement executableElement, IsValid valid) {
        TypeMirror returnType = executableElement.getReturnType();
        TypeKind returnKind = returnType.getKind();
        if (returnKind != TypeKind.BOOLEAN && returnKind != TypeKind.VOID && !((Object)returnType).toString().equals(CanonicalNameConstants.BOOLEAN)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with a boolean or a void return type");
        }
    }

    public void returnTypeIsVoid(ExecutableElement executableElement, IsValid valid) {
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with a void return type");
        }
    }

    public void returnTypeIsNotVoid(ExecutableElement executableElement, IsValid valid) {
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() == TypeKind.VOID) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with a return type non void");
        }
    }

    public void extendsActivity(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Activity", valid);
    }

    public void extendsFragment(Element element, IsValid valid) {
        this.extendsOneOfTypes(element, ANDROID_FRAGMENT_QUALIFIED_NAMES, valid);
    }

    public void extendsService(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Service", valid);
    }

    public void extendsIntentService(Element element, IsValid valid) {
        this.extendsType(element, "android.app.IntentService", valid);
    }

    public void extendsReceiver(Element element, IsValid valid) {
        this.extendsType(element, "android.content.BroadcastReceiver", valid);
    }

    public void extendsProvider(Element element, IsValid valid) {
        this.extendsType(element, "android.content.ContentProvider", valid);
    }

    public void extendsView(Element element, IsValid valid) {
        this.extendsType(element, "android.view.View", valid);
    }

    public void extendsTextView(Element element, IsValid valid) {
        this.extendsType(element, "android.widget.TextView", valid);
    }

    public void extendsViewGroup(Element element, IsValid valid) {
        this.extendsType(element, "android.view.ViewGroup", valid);
    }

    public void extendsApplication(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Application", valid);
    }

    public void extendsContext(Element element, IsValid valid) {
        this.extendsType(element, "android.content.Context", valid);
    }

    public void extendsMenuItem(Element element, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        String enclosingQualifiedName = ((Object)enclosingElement.asType()).toString();
        TypeElement enclosingTypeElement = this.annotationHelper.typeElementFromQualifiedName(enclosingQualifiedName);
        if (enclosingTypeElement != null) {
            if (this.thirdPartyLibHelper.usesActionBarSherlock(enclosingTypeElement)) {
                this.extendsType(element, "com.actionbarsherlock.view.MenuItem", valid);
            } else {
                this.extendsType(element, "android.view.MenuItem", valid);
            }
        }
    }

    public void extendsOrmLiteDaoWithValidModelParameter(Element element, IsValid valid) {
        TypeMirror elementType = element.asType();
        TypeMirror modelTypeMirror = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "model");
        TypeElement daoTypeElement = this.annotationHelper.typeElementFromQualifiedName("com.j256.ormlite.dao.Dao");
        TypeElement runtimeExceptionDaoTypeElement = this.annotationHelper.typeElementFromQualifiedName("com.j256.ormlite.dao.RuntimeExceptionDao");
        if (daoTypeElement != null) {
            WildcardType wildcardType = this.annotationHelper.getTypeUtils().getWildcardType(null, null);
            DeclaredType daoParameterizedType = this.annotationHelper.getTypeUtils().getDeclaredType(daoTypeElement, modelTypeMirror, wildcardType);
            DeclaredType runtimeExceptionDaoParameterizedType = this.annotationHelper.getTypeUtils().getDeclaredType(runtimeExceptionDaoTypeElement, modelTypeMirror, wildcardType);
            if (!this.annotationHelper.isSubtype(elementType, daoParameterizedType) && !this.annotationHelper.isSubtype(elementType, runtimeExceptionDaoParameterizedType)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends " + daoParameterizedType.toString() + " or " + runtimeExceptionDaoParameterizedType.toString());
            }
        }
    }

    public void hasASqlLiteOpenHelperParameterizedType(Element element, IsValid valid) {
        TypeMirror openHelperType;
        TypeMirror helperType = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "helper");
        if (!this.annotationHelper.isSubtype(helperType, openHelperType = this.annotationHelper.typeElementFromQualifiedName("android.database.sqlite.SQLiteOpenHelper").asType())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s helper() parameter must extend android.database.sqlite.SQLiteOpenHelper");
        }
    }

    public void applicationRegistered(Element element, AndroidManifest manifest, IsValid valid) {
        if (manifest.isLibraryProject()) {
            return;
        }
        String applicationClassName = manifest.getApplicationClassName();
        if (applicationClassName != null) {
            TypeElement typeElement = (TypeElement)element;
            String componentQualifiedName = typeElement.getQualifiedName().toString();
            String generatedComponentQualifiedName = componentQualifiedName + "_";
            if (!applicationClassName.equals(generatedComponentQualifiedName)) {
                if (applicationClassName.equals(componentQualifiedName)) {
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "The AndroidManifest.xml file contains the original component, and not the AndroidAnnotations generated component. Please register " + generatedComponentQualifiedName + " instead of " + componentQualifiedName);
                } else {
                    this.annotationHelper.printAnnotationWarning(element, "The component " + generatedComponentQualifiedName + " is not registered in the AndroidManifest.xml file.");
                }
            }
        } else {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "No application class registered in the AndroidManifest.xml");
        }
    }

    public void isSharedPreference(Element element, AnnotationElements validatedElements, IsValid valid) {
        TypeMirror type = element.asType();
        if (type instanceof ErrorType || type.getKind() == TypeKind.ERROR) {
            String elementTypeName = ((Object)type).toString();
            boolean sharedPrefValidatedInRound = false;
            if (elementTypeName.endsWith("_")) {
                String prefTypeName = elementTypeName.substring(0, elementTypeName.length() - "_".length());
                Set<? extends Element> sharedPrefElements = validatedElements.getRootAnnotatedElements(SharedPref.class.getName());
                for (Element element2 : sharedPrefElements) {
                    TypeElement sharedPrefTypeElement = (TypeElement)element2;
                    String sharedPrefQualifiedName = sharedPrefTypeElement.getQualifiedName().toString();
                    if (!sharedPrefQualifiedName.endsWith(prefTypeName)) continue;
                    sharedPrefValidatedInRound = true;
                    break;
                }
            }
            if (!sharedPrefValidatedInRound) {
                valid.invalidate();
            }
        } else {
            this.extendsType(element, SharedPreferencesHelper.class.getName(), valid);
        }
    }

    public void extendsOneOfTypes(Element element, List<String> typeQualifiedNames, IsValid valid) {
        TypeMirror elementType = element.asType();
        for (String typeQualifiedName : typeQualifiedNames) {
            TypeMirror expectedType;
            TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
            if (typeElement == null || !this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) continue;
            return;
        }
        valid.invalidate();
        this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends one of the following classes: " + typeQualifiedNames);
    }

    public void extendsType(Element element, String typeQualifiedName, IsValid valid) {
        TypeMirror expectedType;
        TypeMirror elementType = element.asType();
        TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
        if (typeElement != null && !this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends " + typeQualifiedName);
        }
    }

    public void allowedType(Element element, IsValid valid, TypeMirror fieldTypeMirror, List<String> allowedTypes) {
        String qualifiedName = ((Object)fieldTypeMirror).toString();
        if (!allowedTypes.contains(qualifiedName)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a field which is a " + allowedTypes.toString() + ", not " + qualifiedName);
        }
    }

    public void hasRoboGuiceJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("roboguice.inject.InjectorProvider") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the RoboGuice framework in the classpath, the following class is missing: roboguice.inject.InjectorProvider");
        }
        if (elementUtils.getTypeElement("roboguice.application.RoboApplication") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the RoboApplication class in the classpath, are you using RoboGuice 1.1.1 ?");
        }
        try {
            if (elementUtils.getTypeElement("com.google.inject.Injector") == null) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "Could not find the Guice framework in the classpath, the following class is missing: com.google.inject.Injector");
            }
        }
        catch (RuntimeException e) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the Guice framework in the classpath, the following class is missing: com.google.inject.Injector");
        }
    }

    public void hasSpringAndroidJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("org.springframework.web.client.RestTemplate") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the SpringAndroid framework in the classpath, the following class is missing: org.springframework.web.client.RestTemplate");
        }
    }

    public void hasOrmLiteJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("com.j256.ormlite.dao.Dao") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the OrmLite framework in the classpath, the following class is missing: com.j256.ormlite.dao.Dao");
        }
    }

    public void androidService(AndroidSystemServices androidSystemServices, Element element, IsValid valid) {
        TypeMirror serviceType = element.asType();
        if (!androidSystemServices.contains(serviceType)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Unknown service type: " + ((Object)serviceType).toString());
        }
    }

    public void isDeclaredType(Element element, IsValid valid) {
        if (!(element.asType() instanceof DeclaredType)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a field which is a declared type");
        }
    }

    public void isPrefMethod(Element element, IsValid valid) {
        if (!element.getKind().equals((Object)ElementKind.METHOD)) {
            this.annotationHelper.printError(element, "Only methods are allowed in an " + this.annotationHelper.annotationName() + " annotated interface");
        } else {
            ExecutableElement executableElement = (ExecutableElement)element;
            String methodName = executableElement.getSimpleName().toString();
            if (executableElement.getParameters().size() > 0) {
                this.annotationHelper.printError(element, "Method " + methodName + " should have no parameters in an " + this.annotationHelper.annotationName() + " annotated interface");
            } else {
                String returnType = ((Object)executableElement.getReturnType()).toString();
                if (!VALID_PREF_RETURN_TYPES.contains(returnType)) {
                    this.annotationHelper.printError(element, "Method " + methodName + " should only return preference simple types in an " + this.annotationHelper.annotationName() + " annotated interface");
                } else if (INVALID_PREF_METHOD_NAMES.contains(methodName)) {
                    this.annotationHelper.printError(element, "The method name " + methodName + " is forbidden in an " + this.annotationHelper.annotationName() + " annotated interface");
                } else {
                    return;
                }
            }
        }
        valid.invalidate();
    }

    public void hasCorrectDefaultAnnotation(ExecutableElement method, IsValid valid) {
        this.checkDefaultAnnotation(method, DefaultBoolean.class, "boolean", new TypeKindAnnotationCondition(TypeKind.BOOLEAN), valid);
        this.checkDefaultAnnotation(method, DefaultFloat.class, "float", new TypeKindAnnotationCondition(TypeKind.FLOAT), valid);
        this.checkDefaultAnnotation(method, DefaultInt.class, "int", new TypeKindAnnotationCondition(TypeKind.INT), valid);
        this.checkDefaultAnnotation(method, DefaultLong.class, "long", new TypeKindAnnotationCondition(TypeKind.LONG), valid);
        this.checkDefaultAnnotation(method, DefaultString.class, "String", new DefaultAnnotationCondition(){

            @Override
            public boolean correctReturnType(TypeMirror returnType) {
                return ((Object)returnType).toString().equals(CanonicalNameConstants.STRING);
            }
        }, valid);
    }

    private <T extends Annotation> void checkDefaultAnnotation(ExecutableElement method, Class<T> annotationClass, String expectedReturnType, DefaultAnnotationCondition condition, IsValid valid) {
        T defaultAnnotation = method.getAnnotation(annotationClass);
        if (defaultAnnotation != null && !condition.correctReturnType(method.getReturnType())) {
            this.annotationHelper.printAnnotationError(method, annotationClass.getName(), TargetAnnotationHelper.annotationName(annotationClass) + " can only be used on a method that returns a " + expectedReturnType);
            valid.invalidate();
        }
    }

    public void unannotatedMethodReturnsRestTemplate(TypeElement typeElement, IsValid valid) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        boolean foundGetRestTemplateMethod = false;
        boolean foundSetRestTemplateMethod = false;
        boolean foundSetAuthenticationMethod = false;
        boolean foundSetRootUrlMethod = false;
        boolean foundGetCookieMethod = false;
        boolean foundGetHeaderMethod = false;
        boolean foundGetRootUrlMethod = false;
        for (Element element : enclosedElements) {
            VariableElement firstParameter;
            List<? extends VariableElement> parameters;
            if (element.getKind() != ElementKind.METHOD) {
                valid.invalidate();
                this.annotationHelper.printError(element, "Only methods are allowed in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            boolean hasRestAnnotation = false;
            for (Class<? extends Annotation> annotationClass : REST_ANNOTATION_CLASSES) {
                if (element.getAnnotation(annotationClass) == null) continue;
                hasRestAnnotation = true;
                break;
            }
            if (hasRestAnnotation) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeMirror returnType = executableElement.getReturnType();
            String simpleName = executableElement.getSimpleName().toString();
            if (((Object)returnType).toString().equals("org.springframework.web.client.RestTemplate")) {
                if (executableElement.getParameters().size() > 0) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method returning a RestTemplate should not declare any parameter in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                if (foundGetRestTemplateMethod) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "Only one method should declare returning a RestTemplate in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                foundGetRestTemplateMethod = true;
                continue;
            }
            if (simpleName.equals(METHOD_NAME_GET_ROOT_URL)) {
                if (!((Object)returnType).toString().equals(CanonicalNameConstants.STRING)) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method getRootUrl must return String on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                }
                if (executableElement.getParameters().size() != 0) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method getRootUrl cannot have parameters on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                }
                if (!foundGetRootUrlMethod) {
                    foundGetRootUrlMethod = true;
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printError(element, "The can be only one getRootUrl method on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            if (returnType.getKind() == TypeKind.VOID) {
                parameters = executableElement.getParameters();
                if (parameters.size() == 1) {
                    firstParameter = parameters.get(0);
                    if (((Object)firstParameter.asType()).toString().equals("org.springframework.web.client.RestTemplate")) {
                        if (!foundSetRestTemplateMethod) {
                            foundSetRestTemplateMethod = true;
                            continue;
                        }
                        valid.invalidate();
                        this.annotationHelper.printError(element, "You can only have oneRestTemplate setter method on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_ROOT_URL) && !foundSetRootUrlMethod) {
                        foundSetRootUrlMethod = true;
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_AUTHENTICATION) && !foundSetAuthenticationMethod) {
                        foundSetAuthenticationMethod = true;
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                if (parameters.size() == 2) {
                    firstParameter = parameters.get(0);
                    VariableElement secondParameter = parameters.get(1);
                    if (((Object)firstParameter.asType()).toString().equals(CanonicalNameConstants.STRING) && ((Object)secondParameter.asType()).toString().equals(CanonicalNameConstants.STRING)) continue;
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method to set headers, cookies, or HTTP Basic Auth should have only String parameters on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            if (((Object)returnType).toString().equals(CanonicalNameConstants.STRING)) {
                parameters = executableElement.getParameters();
                if (parameters.size() == 1) {
                    firstParameter = parameters.get(0);
                    if (((Object)firstParameter.asType()).toString().equals(CanonicalNameConstants.STRING)) {
                        if (executableElement.getSimpleName().toString().equals(METHOD_NAME_GET_COOKIE) && !foundGetCookieMethod) {
                            foundGetCookieMethod = true;
                            continue;
                        }
                        if (executableElement.getSimpleName().toString().equals(METHOD_NAME_GET_HEADER) && !foundGetHeaderMethod) {
                            foundGetHeaderMethod = true;
                            continue;
                        }
                        valid.invalidate();
                        this.annotationHelper.printError(element, "Only one getCookie(String) and one getHeader(String) method are allowed on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printError(element, "Only getCookie(String) and getHeader(String) can return a String on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printError(element, "The only methods that can return a String on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface are getCookie(String) and getHeader(String)");
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printError(element, "All methods should be annotated in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface, except the ones that returns or set a RestTemplate");
        }
    }

    public void notAlreadyValidated(Element element, AnnotationElements validatedElements, IsValid valid) {
        if (validatedElements.getAllElements().contains(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated element cannot be used with the other annotations used on this element.");
        }
    }

    public void hasEmptyOrContextConstructor(Element element, IsValid valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (constructors.size() == 1) {
            ExecutableElement constructor = constructors.get(0);
            if (!this.annotationHelper.isPrivate(constructor)) {
                VariableElement parameter;
                if (constructor.getParameters().size() > 1) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    valid.invalidate();
                } else if (constructor.getParameters().size() == 1 && !((Object)(parameter = constructor.getParameters().get(0)).asType()).toString().equals("android.content.Context")) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    valid.invalidate();
                }
            } else {
                this.annotationHelper.printAnnotationError(element, "%s annotated element should not have a private constructor");
                valid.invalidate();
            }
        } else {
            this.annotationHelper.printAnnotationError(element, "%s annotated element should have only one constructor");
            valid.invalidate();
        }
    }

    public void hasEmptyConstructor(Element element, IsValid valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (constructors.size() == 1) {
            ExecutableElement constructor = constructors.get(0);
            if (!this.annotationHelper.isPrivate(constructor)) {
                if (constructor.getParameters().size() != 0) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have an empty constructor");
                    valid.invalidate();
                }
            } else {
                this.annotationHelper.printAnnotationError(element, "%s annotated element should not have a private constructor");
                valid.invalidate();
            }
        } else {
            this.annotationHelper.printAnnotationError(element, "%s annotated element should have only one constructor");
            valid.invalidate();
        }
    }

    public void hasValidLogLevel(Element element, IsValid isValid) {
        Trace annotation = element.getAnnotation(Trace.class);
        Integer level = annotation.level();
        if (!VALID_LOG_LEVELS.contains(level)) {
            this.annotationHelper.printError(element, "Unrecognized log level.");
            isValid.invalidate();
        }
    }

    public void canBeSavedAsInstanceState(Element element, IsValid isValid) {
        String typeString = ((Object)element.asType()).toString();
        if (!this.isKnowInstanceStateType(typeString)) {
            if (element.asType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)element.asType();
                typeString = declaredType.asElement().toString();
            } else if (element.asType() instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)element.asType();
                TypeMirror componentType = arrayType.getComponentType();
                if (componentType instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)componentType;
                    typeString = declaredType.asElement().toString();
                } else {
                    typeString = ((Object)componentType).toString();
                }
            } else {
                typeString = ((Object)element.asType()).toString();
            }
            TypeElement elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
            if (elementType == null && (elementType = this.getArrayEnclosingType(typeString)) == null) {
                this.annotationHelper.printAnnotationError(element, "Unrecognized type. Please let your attribute be primitive or implement Serializable or Parcelable");
                isValid.invalidate();
            }
            if (elementType != null) {
                TypeElement parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable");
                TypeElement serializableType = this.annotationHelper.typeElementFromQualifiedName("java.io.Serializable");
                if (!this.annotationHelper.isSubtype(elementType, parcelableType) && !this.annotationHelper.isSubtype(elementType, serializableType)) {
                    this.annotationHelper.printAnnotationError(element, "Unrecognized type. Please let your attribute be primitive or implement Serializable or Parcelable");
                    isValid.invalidate();
                }
            }
        }
    }

    private TypeElement getArrayEnclosingType(String typeString) {
        typeString = typeString.replace("[]", "");
        return this.annotationHelper.typeElementFromQualifiedName(typeString);
    }

    private boolean isKnowInstanceStateType(String type) {
        return BundleHelper.methodSuffixNameByTypeName.containsKey(type);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, IsValid valid) {
        this.componentRegistered(element, androidManifest, true, valid);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, boolean printWarning, IsValid valid) {
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (androidManifest.isLibraryProject()) {
            return;
        }
        String componentQualifiedName = typeElement.getQualifiedName().toString();
        String generatedComponentQualifiedName = componentQualifiedName + "_";
        List<String> componentQualifiedNames = androidManifest.getComponentQualifiedNames();
        if (!componentQualifiedNames.contains(generatedComponentQualifiedName)) {
            String simpleName = typeElement.getSimpleName().toString();
            String generatedSimpleName = simpleName + "_";
            if (componentQualifiedNames.contains(componentQualifiedName)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The AndroidManifest.xml file contains the original component, and not the AndroidAnnotations generated component. Please register " + generatedSimpleName + " instead of " + simpleName);
            } else if (printWarning) {
                this.annotationHelper.printAnnotationWarning(element, "The component " + generatedSimpleName + " is not registered in the AndroidManifest.xml file.");
            }
        }
    }

    public void validateConverters(Element element, IsValid valid) {
        TypeMirror httpMessageConverterType = this.annotationHelper.typeElementFromQualifiedName("org.springframework.http.converter.HttpMessageConverter").asType();
        TypeMirror httpMessageConverterTypeErased = this.annotationHelper.getTypeUtils().erasure(httpMessageConverterType);
        List<DeclaredType> converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.annotationHelper.getTarget(), "converters");
        if (converters == null) {
            valid.invalidate();
            return;
        }
        for (DeclaredType converterType : converters) {
            TypeMirror erasedConverterType = this.annotationHelper.getTypeUtils().erasure(converterType);
            if (this.annotationHelper.isSubtype(erasedConverterType, httpMessageConverterTypeErased)) {
                Element converterElement = converterType.asElement();
                if (converterElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(converterElement)) {
                        List<ExecutableElement> constructors = ElementFilter.constructorsIn(converterElement.getEnclosedElements());
                        for (ExecutableElement constructor : constructors) {
                            if (!this.annotationHelper.isPublic(constructor) || !constructor.getParameters().isEmpty()) continue;
                            return;
                        }
                        valid.invalidate();
                        this.annotationHelper.printAnnotationError(element, "The converter class must have a public no argument constructor");
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "The converter class must not be abstract");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The converter class must be a class");
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "The converter class must be a subtype of org.springframework.http.converter.HttpMessageConverter");
        }
    }

    public void isDebuggable(Element element, AndroidManifest androidManifest, IsValid valid) {
        if (!androidManifest.isDebuggable()) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "The application must be in debuggable mode. Please set android:debuggable to true in your AndroidManifest.xml file.");
        }
    }

    public void hasInternetPermission(Element element, AndroidManifest androidManifest, IsValid valid) {
        if (androidManifest.isLibraryProject()) {
            return;
        }
        String internetPermissionQualifiedName = "android.permission.INTERNET";
        List<String> permissionQualifiedNames = androidManifest.getPermissionQualifiedNames();
        if (!permissionQualifiedNames.contains(internetPermissionQualifiedName)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Your application must require the INTERNET permission.");
        }
    }

    public void validateInterceptors(Element element, IsValid valid) {
        TypeMirror clientHttpRequestInterceptorType = this.annotationHelper.typeElementFromQualifiedName("org.springframework.http.client.ClientHttpRequestInterceptor").asType();
        TypeMirror clientHttpRequestInterceptorTypeErased = this.annotationHelper.getTypeUtils().erasure(clientHttpRequestInterceptorType);
        List<DeclaredType> interceptors = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.annotationHelper.getTarget(), "interceptors");
        if (interceptors == null) {
            return;
        }
        for (DeclaredType interceptorType : interceptors) {
            TypeMirror erasedInterceptorType = this.annotationHelper.getTypeUtils().erasure(interceptorType);
            if (this.annotationHelper.isSubtype(erasedInterceptorType, clientHttpRequestInterceptorTypeErased)) {
                Element interceptorElement = interceptorType.asElement();
                if (interceptorElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(interceptorElement)) {
                        List<ExecutableElement> constructors = ElementFilter.constructorsIn(interceptorElement.getEnclosedElements());
                        for (ExecutableElement constructor : constructors) {
                            if (!this.annotationHelper.isPublic(constructor) || !constructor.getParameters().isEmpty()) continue;
                            return;
                        }
                        valid.invalidate();
                        this.annotationHelper.printAnnotationError(element, "The interceptor class must have a public no argument constructor");
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "The interceptor class must not be abstract");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The interceptor class must be a class");
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "The interceptor class must be a subtype of org.springframework.http.client.ClientHttpRequestInterceptor");
        }
    }

    public void hasBeforeTextChangedMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean charSequenceParameterFound = false;
        boolean textViewParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals(CanonicalNameConstants.CHAR_SEQUENCE)) {
                if (charSequenceParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type java.lang.CharSequence");
                    valid.invalidate();
                }
                charSequenceParameterFound = true;
                continue;
            }
            if (parameterType.equals("android.widget.TextView")) {
                if (textViewParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.widget.TextView");
                    valid.invalidate();
                }
                textViewParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType)) {
                String parameterName = variableElement.toString();
                if ("start".equals(parameterName) || "count".equals(parameterName) || "after".equals(parameterName)) continue;
                this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter name. You can only have start, before, or count parameter name. Try to pick a parameter from android.text.TextWatcher.beforeTextChanged() method.");
                valid.invalidate();
                continue;
            }
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter (" + variableElement.toString() + "). %s can only have a android.widget.TextView parameter and/or parameters from android.text.TextWatcher.beforeTextChanged() method.");
            valid.invalidate();
        }
    }

    public void hasTextChangedMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean charSequenceParameterFound = false;
        boolean textViewParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals(CanonicalNameConstants.CHAR_SEQUENCE)) {
                if (charSequenceParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type java.lang.CharSequence");
                    valid.invalidate();
                }
                charSequenceParameterFound = true;
                continue;
            }
            if (parameterType.equals("android.widget.TextView")) {
                if (textViewParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.widget.TextView");
                    valid.invalidate();
                }
                textViewParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType)) {
                String parameterName = variableElement.toString();
                if ("start".equals(parameterName) || "before".equals(parameterName) || "count".equals(parameterName)) continue;
                this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter name. You can only have start, before, or count parameter name. Try to pick a prameter from the android.text.TextWatcher.onTextChanged() method.");
                valid.invalidate();
                continue;
            }
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter (" + variableElement.toString() + "). %s can only have a android.widget.TextView parameter and/or parameters from android.text.TextWatcher.onTextChanged() method.");
            valid.invalidate();
        }
    }

    public void hasAfterTextChangedMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean editableParameterFound = false;
        boolean textViewParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals("android.text.Editable")) {
                if (editableParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.text.Editable");
                    valid.invalidate();
                }
                editableParameterFound = true;
                continue;
            }
            if (parameterType.equals("android.widget.TextView")) {
                if (textViewParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.widget.TextView");
                    valid.invalidate();
                }
                textViewParameterFound = true;
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter type. %s can only have a android.widget.TextView parameter and/or an android.text.Editable parameter. See android.text.TextWatcher.afterTextChanged() for more informations.");
        }
    }

    public void hasSeekBarProgressChangeMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean seekBarParameterFound = false;
        boolean fromUserParameterFound = false;
        boolean progressParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals("android.widget.SeekBar")) {
                if (seekBarParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can declare only one parameter of type android.widget.SeekBar");
                    valid.invalidate();
                }
                seekBarParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType)) {
                if (progressParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "You can have only one parameter of type " + CanonicalNameConstants.INTEGER);
                    valid.invalidate();
                }
                progressParameterFound = true;
                continue;
            }
            if (variableElement.asType().getKind() == TypeKind.BOOLEAN || CanonicalNameConstants.BOOLEAN.equals(parameterType)) {
                if (fromUserParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "You can have only one parameter of type " + CanonicalNameConstants.BOOLEAN);
                    valid.invalidate();
                }
                fromUserParameterFound = true;
                continue;
            }
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter '" + variableElement.toString() + "'. %s signature should be " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar, int progress, boolean fromUser). The 'fromUser' and 'progress' parameters are optional.");
            valid.invalidate();
        }
    }

    public void hasSeekBarTouchTrackingMethodParameters(ExecutableElement executableElement, IsValid valid) {
        String parameterType;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 1) {
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can only have one parameter of type android.widget.SeekBar. Try declaring " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar);");
            valid.invalidate();
            return;
        }
        if (parameters.size() == 1 && !(parameterType = ((Object)parameters.get(0).asType()).toString()).equals("android.widget.SeekBar")) {
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. You can only have one parameter of type android.widget.SeekBar. Try declaring " + executableElement.getSimpleName() + "(" + "android.widget.SeekBar" + " seekBar);");
            valid.invalidate();
        }
    }

    public void hasOnResultMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean resultCodeParameterFound = false;
        boolean intentParameterFound = false;
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterType = variableElement.asType();
            if (((Object)parameterType).toString().equals(CanonicalNameConstants.INTEGER) || parameterType.getKind().equals((Object)TypeKind.INT)) {
                if (resultCodeParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type int or java.lang.Integer");
                    valid.invalidate();
                }
                resultCodeParameterFound = true;
                continue;
            }
            if (((Object)parameterType).toString().equals("android.content.Intent")) {
                if (intentParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.content.Intent");
                    valid.invalidate();
                }
                intentParameterFound = true;
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter type. %s can only have a android.content.Intent parameter and/or an Integer parameter");
        }
    }

    public void hasNotMultipleAnnotatedMethodWithSameName(Element element, IsValid valid, Class<? extends Annotation> annotation) {
        TreeSet<String> actionNames = new TreeSet<String>();
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            if (element2.getKind() != ElementKind.METHOD || !this.annotationHelper.hasOneOfClassAnnotations(element2, annotation)) continue;
            String enclosedElementName = element2.getSimpleName().toString();
            if (actionNames.contains(enclosedElementName)) {
                valid.invalidate();
                this.annotationHelper.printError(element2, "The " + TargetAnnotationHelper.annotationName(ServiceAction.class) + " annotated method must have unique name even if the signature is not the same");
                continue;
            }
            actionNames.add(enclosedElementName);
        }
    }

    private class TypeKindAnnotationCondition
    implements DefaultAnnotationCondition {
        private final TypeKind typeKind;

        public TypeKindAnnotationCondition(TypeKind typeKind) {
            this.typeKind = typeKind;
        }

        @Override
        public boolean correctReturnType(TypeMirror returnType) {
            return returnType.getKind() == this.typeKind;
        }
    }

    private static interface DefaultAnnotationCondition {
        public boolean correctReturnType(TypeMirror var1);
    }
}

