/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.process.ProcessHolder;

public abstract class BaseGeneratedClassHolder
implements GeneratedClassHolder {
    protected final ProcessHolder processHolder;
    protected JDefinedClass generatedClass;
    protected final TypeElement annotatedElement;
    protected final APTCodeModelHelper codeModelHelper;

    public BaseGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        this.processHolder = processHolder;
        this.annotatedElement = annotatedElement;
        this.codeModelHelper = new APTCodeModelHelper();
        this.setGeneratedClass();
    }

    protected void setGeneratedClass() throws Exception {
        String annotatedComponentQualifiedName = this.annotatedElement.getQualifiedName().toString();
        String subComponentQualifiedName = annotatedComponentQualifiedName + "_";
        JClass annotatedComponent = this.codeModel().directClass(((Object)this.annotatedElement.asType()).toString());
        this.generatedClass = this.codeModel()._class(9, subComponentQualifiedName, ClassType.CLASS);
        for (TypeParameterElement typeParameterElement : this.annotatedElement.getTypeParameters()) {
            JClass bound = this.codeModelHelper.typeBoundsToJClass(this, typeParameterElement.getBounds());
            this.generatedClass.generify(typeParameterElement.getSimpleName().toString(), bound);
        }
        this.generatedClass._extends(annotatedComponent);
    }

    @Override
    public JDefinedClass getGeneratedClass() {
        return this.generatedClass;
    }

    @Override
    public TypeElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public ProcessingEnvironment processingEnvironment() {
        return this.processHolder.processingEnvironment();
    }

    @Override
    public ProcessHolder.Classes classes() {
        return this.processHolder.classes();
    }

    @Override
    public JCodeModel codeModel() {
        return this.processHolder.codeModel();
    }

    @Override
    public JClass refClass(String fullyQualifiedClassName) {
        return this.processHolder.refClass(fullyQualifiedClassName);
    }

    @Override
    public JClass refClass(Class<?> clazz) {
        return this.processHolder.refClass(clazz);
    }

    @Override
    public JDefinedClass definedClass(String fullyQualifiedClassName) {
        return this.processHolder.definedClass(fullyQualifiedClassName);
    }
}

