/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.process;

import com.sun.codemodel.JCodeModel;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.androidannotations.exception.ProcessingException;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.OriginatingElements;
import org.androidannotations.process.ProcessHolder;

public class ModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelProcessor.class);
    private final ProcessingEnvironment processingEnv;
    private final AnnotationHandlers annotationHandlers;

    public ModelProcessor(ProcessingEnvironment processingEnv, AnnotationHandlers annotationHandlers) {
        this.processingEnv = processingEnv;
        this.annotationHandlers = annotationHandlers;
    }

    public ProcessResult process(AnnotationElements validatedModel) throws ProcessingException, Exception {
        String annotationName;
        ProcessHolder processHolder = new ProcessHolder(this.processingEnv);
        this.annotationHandlers.setProcessHolder(processHolder);
        LOGGER.info("Processing root elements", new Object[0]);
        for (GeneratingAnnotationHandler<? extends GeneratedClassHolder> generatingAnnotationHandler : this.annotationHandlers.getGenerating()) {
            annotationName = generatingAnnotationHandler.getTarget();
            Set<? extends Element> annotatedElements = validatedModel.getRootAnnotatedElements(annotationName);
            if (!annotatedElements.isEmpty()) {
                LOGGER.debug("Processing root elements {}: {}", generatingAnnotationHandler.getClass().getSimpleName(), annotatedElements);
            }
            for (Element element : annotatedElements) {
                if (!this.isAbstractClass(element)) {
                    TypeElement typeElement = (TypeElement)element;
                    GeneratedClassHolder generatedClassHolder = generatingAnnotationHandler.createGeneratedClassHolder(processHolder, typeElement);
                    processHolder.put(element, generatedClassHolder);
                    this.processThrowing(generatingAnnotationHandler, element, generatedClassHolder);
                    continue;
                }
                LOGGER.trace("Skip element {} because it's abstract", element, new Object[0]);
            }
        }
        LOGGER.info("Processing enclosed elements", new Object[0]);
        for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers.getDecorating()) {
            annotationName = annotationHandler.getTarget();
            Set<AnnotationElements.AnnotatedAndRootElements> ancestorAnnotatedElements = validatedModel.getAncestorAnnotatedElements(annotationName);
            if (!ancestorAnnotatedElements.isEmpty()) {
                LOGGER.debug("Processing enclosed elements with {}: {}", annotationHandler.getClass().getSimpleName(), ancestorAnnotatedElements);
            }
            for (AnnotationElements.AnnotatedAndRootElements annotatedAndRootElements : ancestorAnnotatedElements) {
                GeneratedClassHolder generatedClassHolder = processHolder.getGeneratedClassHolder(annotatedAndRootElements.rootTypeElement);
                if (generatedClassHolder == null) continue;
                this.processThrowing(annotationHandler, annotatedAndRootElements.annotatedElement, generatedClassHolder);
            }
            Set<? extends Element> rootAnnotatedElements = validatedModel.getRootAnnotatedElements(annotationName);
            for (Element element : rootAnnotatedElements) {
                Element enclosingElement = element instanceof TypeElement ? element : element.getEnclosingElement();
                if (!this.isAbstractClass(enclosingElement)) {
                    GeneratedClassHolder holder = processHolder.getGeneratedClassHolder(enclosingElement);
                    this.processThrowing(annotationHandler, element, holder);
                    continue;
                }
                LOGGER.trace("Skip element {} because enclosing element {} is abstract", element, enclosingElement);
            }
        }
        return new ProcessResult(processHolder.codeModel(), processHolder.getOriginatingElements(), processHolder.getApiClassesToGenerate());
    }

    private <T extends GeneratedClassHolder> void processThrowing(AnnotationHandler<T> handler, Element element, T generatedClassHolder) throws ProcessingException {
        try {
            handler.process(element, generatedClassHolder);
        }
        catch (Exception e) {
            throw new ProcessingException(e, element);
        }
    }

    private boolean isAbstractClass(Element annotatedElement) {
        if (annotatedElement instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)annotatedElement;
            return typeElement.getKind() == ElementKind.CLASS && typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        return false;
    }

    public static class ProcessResult {
        public final JCodeModel codeModel;
        public final OriginatingElements originatingElements;
        public final Set<Class<?>> apiClassesToGenerate;

        public ProcessResult(JCodeModel codeModel, OriginatingElements originatingElements, Set<Class<?>> apiClassesToGenerate) {
            this.codeModel = codeModel;
            this.originatingElements = originatingElements;
            this.apiClassesToGenerate = apiClassesToGenerate;
        }
    }
}

