package com.example.nfc;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import android.R.bool;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.NfcF;
import android.os.Bundle;
import android.os.Parcelable;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentFilter.MalformedMimeTypeException;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

	private NfcAdapter mAdapter;
	private PendingIntent mPendingIntent;
	private IntentFilter[] mFilters;
	private String[][] mTechLists;
	private TextView mText;
	private SharedPreferences sharedPreferences;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.main);
		mText = (TextView) findViewById(R.id.text);
		mText.setText("Scan a tag");
		
		sharedPreferences = getSharedPreferences("carinfo", MODE_PRIVATE);
		
		mAdapter = NfcAdapter.getDefaultAdapter(this);
		mPendingIntent = PendingIntent.getActivity(this, 0, new Intent(this,
				getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);

		IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_NDEF_DISCOVERED);
		try {
			ndef.addDataType("*/*");
		} catch (MalformedMimeTypeException e) {
			throw new RuntimeException("fail", e);
		}
		mFilters = new IntentFilter[] { ndef };

		mTechLists = new String[][] { new String[] { NfcF.class.getName() } };
	}

	@Override
	public void onResume() {
		super.onResume();
		if (mAdapter != null)
			mAdapter.enableForegroundDispatch(this, mPendingIntent, mFilters,
					mTechLists);
	}

	@Override
	public void onNewIntent(Intent intent) {
		super.onNewIntent(intent);

		NfcMessageParser nfcMessageParser = new NfcMessageParser(intent);
		List<String> tagMessage = nfcMessageParser.getTagMessage();
		if (tagMessage == null || tagMessage.size() == 0) {
			Toast.makeText(this, "NFCʽ֧...", Toast.LENGTH_LONG).show();
		} else {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd " + "hh:mm:ss");
			String[] carinfo = tagMessage.get(0).split(";");
			SharedPreferences.Editor editor = sharedPreferences.edit();
			editor.putString("address", carinfo[0]);
			editor.putString("area", carinfo[1]);
			editor.putString("number", carinfo[2]);
			editor.putString("time", sdf.format(new Date()));
			editor.commit();
			
			startActivity(new Intent(MainActivity.this, extra.class));
			
		}

	}

	@Override
	public void onPause() {
		super.onPause();
		if (mAdapter != null)
			mAdapter.disableForegroundDispatch(this);
	}
}
