/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Checkable;
import java.util.LinkedList;
import java.util.List;
import se.emilsjolander.stickylistheaders.CheckableWrapperView;
import se.emilsjolander.stickylistheaders.StickyListHeadersAdapter;
import se.emilsjolander.stickylistheaders.WrapperView;

class AdapterWrapper
extends BaseAdapter
implements StickyListHeadersAdapter {
    final StickyListHeadersAdapter mDelegate;
    private final List<View> mHeaderCache = new LinkedList<View>();
    private final Context mContext;
    private Drawable mDivider;
    private int mDividerHeight;
    private OnHeaderClickListener mOnHeaderClickListener;
    private DataSetObserver mDataSetObserver = new DataSetObserver(){

        public void onInvalidated() {
            AdapterWrapper.this.mHeaderCache.clear();
            AdapterWrapper.super.notifyDataSetInvalidated();
        }

        public void onChanged() {
            AdapterWrapper.super.notifyDataSetChanged();
        }
    };

    AdapterWrapper(Context context, StickyListHeadersAdapter delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
        delegate.registerDataSetObserver(this.mDataSetObserver);
    }

    void setDivider(Drawable divider, int dividerHeight) {
        this.mDivider = divider;
        this.mDividerHeight = dividerHeight;
        this.notifyDataSetChanged();
    }

    public boolean areAllItemsEnabled() {
        return this.mDelegate.areAllItemsEnabled();
    }

    public boolean isEnabled(int position) {
        return this.mDelegate.isEnabled(position);
    }

    public int getCount() {
        return this.mDelegate.getCount();
    }

    public Object getItem(int position) {
        return this.mDelegate.getItem(position);
    }

    public long getItemId(int position) {
        return this.mDelegate.getItemId(position);
    }

    public boolean hasStableIds() {
        return this.mDelegate.hasStableIds();
    }

    public int getItemViewType(int position) {
        return this.mDelegate.getItemViewType(position);
    }

    public int getViewTypeCount() {
        return this.mDelegate.getViewTypeCount();
    }

    public boolean isEmpty() {
        return this.mDelegate.isEmpty();
    }

    private void recycleHeaderIfExists(WrapperView wv) {
        View header = wv.mHeader;
        if (header != null) {
            header.setVisibility(0);
            this.mHeaderCache.add(header);
        }
    }

    private View configureHeader(WrapperView wv, final int position) {
        View header = wv.mHeader == null ? this.popHeader() : wv.mHeader;
        if ((header = this.mDelegate.getHeaderView(position, header, wv)) == null) {
            throw new NullPointerException("Header view must not be null.");
        }
        header.setClickable(true);
        header.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AdapterWrapper.this.mOnHeaderClickListener != null) {
                    long headerId = AdapterWrapper.this.mDelegate.getHeaderId(position);
                    AdapterWrapper.this.mOnHeaderClickListener.onHeaderClick(v, position, headerId);
                }
            }
        });
        return header;
    }

    private View popHeader() {
        if (this.mHeaderCache.size() > 0) {
            return this.mHeaderCache.remove(0);
        }
        return null;
    }

    private boolean previousPositionHasSameHeader(int position) {
        return position != 0 && this.mDelegate.getHeaderId(position) == this.mDelegate.getHeaderId(position - 1);
    }

    public WrapperView getView(int position, View convertView, ViewGroup parent) {
        WrapperView wv = convertView == null ? new WrapperView(this.mContext) : (WrapperView)convertView;
        View item = this.mDelegate.getView(position, wv.mItem, parent);
        View header = null;
        if (this.previousPositionHasSameHeader(position)) {
            this.recycleHeaderIfExists(wv);
        } else {
            header = this.configureHeader(wv, position);
        }
        if (item instanceof Checkable && !(wv instanceof CheckableWrapperView)) {
            wv = new CheckableWrapperView(this.mContext);
        } else if (!(item instanceof Checkable) && wv instanceof CheckableWrapperView) {
            wv = new WrapperView(this.mContext);
        }
        wv.update(item, header, this.mDivider, this.mDividerHeight);
        return wv;
    }

    public void setOnHeaderClickListener(OnHeaderClickListener onHeaderClickListener) {
        this.mOnHeaderClickListener = onHeaderClickListener;
    }

    public boolean equals(Object o) {
        return this.mDelegate.equals(o);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return ((BaseAdapter)this.mDelegate).getDropDownView(position, convertView, parent);
    }

    public int hashCode() {
        return this.mDelegate.hashCode();
    }

    public void notifyDataSetChanged() {
        ((BaseAdapter)this.mDelegate).notifyDataSetChanged();
    }

    public void notifyDataSetInvalidated() {
        ((BaseAdapter)this.mDelegate).notifyDataSetInvalidated();
    }

    public String toString() {
        return this.mDelegate.toString();
    }

    @Override
    public View getHeaderView(int position, View convertView, ViewGroup parent) {
        return this.mDelegate.getHeaderView(position, convertView, parent);
    }

    @Override
    public long getHeaderId(int position) {
        return this.mDelegate.getHeaderId(position);
    }

    static interface OnHeaderClickListener {
        public void onHeaderClick(View var1, int var2, long var3);
    }
}

