/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.SectionIndexer;
import se.emilsjolander.stickylistheaders.AdapterWrapper;
import se.emilsjolander.stickylistheaders.ApiLevelTooLowException;
import se.emilsjolander.stickylistheaders.R;
import se.emilsjolander.stickylistheaders.SectionIndexerAdapterWrapper;
import se.emilsjolander.stickylistheaders.StickyListHeadersAdapter;
import se.emilsjolander.stickylistheaders.WrapperView;
import se.emilsjolander.stickylistheaders.WrapperViewList;

public class StickyListHeadersListView
extends FrameLayout {
    private WrapperViewList mList;
    private View mHeader;
    private Long mHeaderId;
    private Integer mHeaderPosition;
    private Integer mHeaderOffset;
    private AbsListView.OnScrollListener mOnScrollListenerDelegate;
    private boolean mAreHeadersSticky = true;
    private boolean mClippingToPadding = true;
    private boolean mIsDrawingListUnderStickyHeader = true;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;
    private AdapterWrapper mAdapter;
    private OnHeaderClickListener mOnHeaderClickListener;
    private Drawable mDivider;
    private int mDividerHeight;
    private AdapterWrapperDataSetObserver mDataSetObserver;

    public StickyListHeadersListView(Context context) {
        this(context, null);
    }

    public StickyListHeadersListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @TargetApi(value=11)
    public StickyListHeadersListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mList = new WrapperViewList(context);
        this.mDivider = this.mList.getDivider();
        this.mDividerHeight = this.mList.getDividerHeight();
        this.mList.setDivider(null);
        this.mList.setDividerHeight(0);
        this.mList.setLifeCycleListener(new WrapperViewListLifeCycleListener());
        this.mList.setOnScrollListener(new WrapperListScrollListener());
        this.addView((View)this.mList);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.StickyListHeadersListView, 0, 0);
            try {
                if (a.hasValue(1)) {
                    int padding;
                    this.mPaddingLeft = padding = a.getDimensionPixelSize(1, 0);
                    this.mPaddingTop = padding;
                    this.mPaddingRight = padding;
                    this.mPaddingBottom = padding;
                } else {
                    this.mPaddingLeft = a.getDimensionPixelSize(2, 0);
                    this.mPaddingTop = a.getDimensionPixelSize(3, 0);
                    this.mPaddingRight = a.getDimensionPixelSize(4, 0);
                    this.mPaddingBottom = a.getDimensionPixelSize(5, 0);
                }
                this.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
                this.mClippingToPadding = a.getBoolean(7, true);
                super.setClipToPadding(true);
                this.mList.setClipToPadding(this.mClippingToPadding);
                this.mList.setFadingEdgeLength(a.getDimensionPixelSize(6, this.mList.getVerticalFadingEdgeLength()));
                int fadingEdge = a.getInt(16, 0);
                if (fadingEdge == 4096) {
                    this.mList.setVerticalFadingEdgeEnabled(false);
                    this.mList.setHorizontalFadingEdgeEnabled(true);
                } else if (fadingEdge == 8192) {
                    this.mList.setVerticalFadingEdgeEnabled(true);
                    this.mList.setHorizontalFadingEdgeEnabled(false);
                } else {
                    this.mList.setVerticalFadingEdgeEnabled(false);
                    this.mList.setHorizontalFadingEdgeEnabled(false);
                }
                this.mList.setCacheColorHint(a.getColor(11, this.mList.getCacheColorHint()));
                if (Build.VERSION.SDK_INT >= 11) {
                    this.mList.setChoiceMode(a.getInt(14, this.mList.getChoiceMode()));
                }
                this.mList.setDrawSelectorOnTop(a.getBoolean(9, false));
                this.mList.setFastScrollEnabled(a.getBoolean(15, this.mList.isFastScrollEnabled()));
                this.mList.setScrollBarStyle(a.getInt(0, 0));
                Drawable selector = a.getDrawable(8);
                if (selector != null) {
                    this.mList.setSelector(selector);
                }
                this.mList.setScrollingCacheEnabled(a.getBoolean(10, this.mList.isScrollingCacheEnabled()));
                Drawable divider = a.getDrawable(12);
                if (divider != null) {
                    this.mDivider = divider;
                }
                this.mDividerHeight = a.getDimensionPixelSize(13, this.mDividerHeight);
                this.mAreHeadersSticky = a.getBoolean(17, true);
                this.mIsDrawingListUnderStickyHeader = a.getBoolean(18, true);
            }
            finally {
                a.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureHeader(this.mHeader);
    }

    private void ensureHeaderHasCorrectLayoutParams(View header) {
        ViewGroup.LayoutParams lp = header.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -2);
        } else if (lp.height == -1) {
            lp.height = -2;
        }
        header.setLayoutParams(lp);
    }

    private void measureHeader(View header) {
        if (header != null) {
            int width = this.getMeasuredWidth() - this.mPaddingLeft - this.mPaddingRight;
            int parentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            int parentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.measureChild(header, parentWidthMeasureSpec, parentHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mList.layout(0, 0, this.mList.getMeasuredWidth(), this.getHeight());
        if (this.mHeader != null) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
            int headerTop = lp.topMargin + (this.mClippingToPadding ? this.mPaddingTop : 0);
            this.mHeader.layout(this.mPaddingLeft, headerTop, this.mHeader.getMeasuredWidth() + this.mPaddingLeft, headerTop + this.mHeader.getMeasuredHeight());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        this.drawChild(canvas, (View)this.mList, 0L);
    }

    private void clearHeader() {
        if (this.mHeader != null) {
            this.removeView(this.mHeader);
            this.mHeader = null;
            this.mHeaderId = null;
            this.mHeaderPosition = null;
            this.mHeaderOffset = null;
            this.mList.setTopClippingLength(0);
            this.updateHeaderVisibilities();
        }
    }

    private void updateOrClearHeader(int firstVisiblePosition) {
        boolean isFirstVisibleItemOutsideAdapterRange;
        int adapterCount;
        int n = adapterCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (adapterCount == 0 || !this.mAreHeadersSticky) {
            return;
        }
        int headerViewCount = this.mList.getHeaderViewsCount();
        int realFirstVisibleItem = firstVisiblePosition - headerViewCount;
        boolean doesListHaveChildren = this.mList.getChildCount() != 0;
        boolean isFirstViewBelowTop = doesListHaveChildren && this.mList.getFirstVisiblePosition() == 0 && this.mList.getChildAt(0).getTop() > 0;
        boolean bl = isFirstVisibleItemOutsideAdapterRange = realFirstVisibleItem > adapterCount - 1 || realFirstVisibleItem < 0;
        if (!doesListHaveChildren || isFirstVisibleItemOutsideAdapterRange || isFirstViewBelowTop) {
            this.clearHeader();
            return;
        }
        this.updateHeader(realFirstVisibleItem);
    }

    private void updateHeader(int firstVisiblePosition) {
        if (this.mHeaderPosition == null || this.mHeaderPosition != firstVisiblePosition) {
            this.mHeaderPosition = firstVisiblePosition;
            long headerId = this.mAdapter.getHeaderId(firstVisiblePosition);
            if (this.mHeaderId == null || this.mHeaderId != headerId) {
                this.mHeaderId = headerId;
                View header = this.mAdapter.getHeaderView(this.mHeaderPosition, this.mHeader, (ViewGroup)this);
                if (this.mHeader != header) {
                    if (header == null) {
                        throw new NullPointerException("header may not be null");
                    }
                    this.swapHeader(header);
                }
                this.ensureHeaderHasCorrectLayoutParams(this.mHeader);
                this.measureHeader(this.mHeader);
                this.mHeaderOffset = null;
            }
        }
        int headerOffset = 0;
        int headerBottom = this.mHeader.getMeasuredHeight() + (this.mClippingToPadding ? this.mPaddingTop : 0);
        int i = 0;
        while (i < this.mList.getChildCount()) {
            View child = this.mList.getChildAt(i);
            boolean doesChildHaveHeader = child instanceof WrapperView && ((WrapperView)child).hasHeader();
            boolean isChildFooter = this.mList.containsFooterView(child);
            if (child.getTop() >= (this.mClippingToPadding ? this.mPaddingTop : 0) && (doesChildHaveHeader || isChildFooter)) {
                headerOffset = Math.min(child.getTop() - headerBottom, 0);
                break;
            }
            ++i;
        }
        this.setHeaderOffet(headerOffset);
        if (!this.mIsDrawingListUnderStickyHeader) {
            this.mList.setTopClippingLength(this.mHeader.getMeasuredHeight() + this.mHeaderOffset);
        }
        this.updateHeaderVisibilities();
    }

    private void swapHeader(View newHeader) {
        if (this.mHeader != null) {
            this.removeView(this.mHeader);
        }
        this.mHeader = newHeader;
        this.addView(this.mHeader);
        this.mHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StickyListHeadersListView.this.mOnHeaderClickListener != null) {
                    StickyListHeadersListView.this.mOnHeaderClickListener.onHeaderClick(StickyListHeadersListView.this, StickyListHeadersListView.this.mHeader, StickyListHeadersListView.this.mHeaderPosition, StickyListHeadersListView.this.mHeaderId, true);
                }
            }
        });
    }

    private void updateHeaderVisibilities() {
        int top = this.mHeader != null ? this.mHeader.getMeasuredHeight() + (this.mHeaderOffset != null ? this.mHeaderOffset : 0) : (this.mClippingToPadding ? this.mPaddingTop : 0);
        int childCount = this.mList.getChildCount();
        int i = 0;
        while (i < childCount) {
            WrapperView wrapperViewChild;
            View child = this.mList.getChildAt(i);
            if (child instanceof WrapperView && (wrapperViewChild = (WrapperView)child).hasHeader()) {
                View childHeader = wrapperViewChild.mHeader;
                if (wrapperViewChild.getTop() < top) {
                    if (childHeader.getVisibility() != 4) {
                        childHeader.setVisibility(4);
                    }
                } else if (childHeader.getVisibility() != 0) {
                    childHeader.setVisibility(0);
                }
            }
            ++i;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setHeaderOffet(int offset) {
        if (this.mHeaderOffset == null || this.mHeaderOffset != offset) {
            this.mHeaderOffset = offset;
            if (Build.VERSION.SDK_INT >= 11) {
                this.mHeader.setTranslationY((float)this.mHeaderOffset.intValue());
            } else {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
                params.topMargin = this.mHeaderOffset;
                this.mHeader.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    private boolean isStartOfSection(int position) {
        return position == 0 || this.mAdapter.getHeaderId(position) == this.mAdapter.getHeaderId(position - 1);
    }

    private int getHeaderOverlap(int position) {
        boolean isStartOfSection = this.isStartOfSection(position);
        if (!isStartOfSection) {
            View header = this.mAdapter.getHeaderView(position, null, (ViewGroup)this.mList);
            if (header == null) {
                throw new NullPointerException("header may not be null");
            }
            this.ensureHeaderHasCorrectLayoutParams(header);
            this.measureHeader(header);
            return header.getMeasuredHeight();
        }
        return 0;
    }

    public void setAreHeadersSticky(boolean areHeadersSticky) {
        this.mAreHeadersSticky = areHeadersSticky;
        if (!areHeadersSticky) {
            this.clearHeader();
        } else {
            this.updateOrClearHeader(this.mList.getFixedFirstVisibleItem());
        }
        this.mList.invalidate();
    }

    public boolean areHeadersSticky() {
        return this.mAreHeadersSticky;
    }

    @Deprecated
    public boolean getAreHeadersSticky() {
        return this.areHeadersSticky();
    }

    public void setDrawingListUnderStickyHeader(boolean drawingListUnderStickyHeader) {
        this.mIsDrawingListUnderStickyHeader = drawingListUnderStickyHeader;
        this.mList.setTopClippingLength(0);
    }

    public boolean isDrawingListUnderStickyHeader() {
        return this.mIsDrawingListUnderStickyHeader;
    }

    public void setOnHeaderClickListener(OnHeaderClickListener onHeaderClickListener) {
        this.mOnHeaderClickListener = onHeaderClickListener;
        if (this.mAdapter != null) {
            if (this.mOnHeaderClickListener != null) {
                this.mAdapter.setOnHeaderClickListener(new AdapterWrapperHeaderClickHandler());
            } else {
                this.mAdapter.setOnHeaderClickListener(null);
            }
        }
    }

    public View getListChildAt(int index) {
        return this.mList.getChildAt(index);
    }

    public int getListChildCount() {
        return this.mList.getChildCount();
    }

    public ListView getWrappedList() {
        return this.mList;
    }

    public void setAdapter(StickyListHeadersAdapter adapter) {
        if (adapter == null) {
            this.mList.setAdapter(null);
            this.clearHeader();
            return;
        }
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter instanceof SectionIndexer ? new SectionIndexerAdapterWrapper(this.getContext(), adapter) : new AdapterWrapper(this.getContext(), adapter);
        this.mDataSetObserver = new AdapterWrapperDataSetObserver();
        this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        if (this.mOnHeaderClickListener != null) {
            this.mAdapter.setOnHeaderClickListener(new AdapterWrapperHeaderClickHandler());
        } else {
            this.mAdapter.setOnHeaderClickListener(null);
        }
        this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        this.mList.setAdapter(this.mAdapter);
        this.clearHeader();
    }

    public StickyListHeadersAdapter getAdapter() {
        return this.mAdapter == null ? null : this.mAdapter.mDelegate;
    }

    public void setDivider(Drawable divider) {
        this.mDivider = divider;
        if (this.mAdapter != null) {
            this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        }
    }

    public void setDividerHeight(int dividerHeight) {
        this.mDividerHeight = dividerHeight;
        if (this.mAdapter != null) {
            this.mAdapter.setDivider(this.mDivider, this.mDividerHeight);
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public int getDividerHeight() {
        return this.mDividerHeight;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.mOnScrollListenerDelegate = onScrollListener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mList.setOnItemClickListener(listener);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mList.setOnItemLongClickListener(listener);
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        this.mList.addHeaderView(v, data, isSelectable);
    }

    public void addHeaderView(View v) {
        this.mList.addHeaderView(v);
    }

    public void removeHeaderView(View v) {
        this.mList.removeHeaderView(v);
    }

    public int getHeaderViewsCount() {
        return this.mList.getHeaderViewsCount();
    }

    public void addFooterView(View v) {
        this.mList.addFooterView(v);
    }

    public void removeFooterView(View v) {
        this.mList.removeFooterView(v);
    }

    public int getFooterViewsCount() {
        return this.mList.getFooterViewsCount();
    }

    public void setEmptyView(View v) {
        this.mList.setEmptyView(v);
    }

    public View getEmptyView() {
        return this.mList.getEmptyView();
    }

    @TargetApi(value=8)
    public void smoothScrollBy(int distance, int duration) {
        this.requireSdkVersion(8);
        this.mList.smoothScrollBy(distance, duration);
    }

    @TargetApi(value=11)
    public void smoothScrollByOffset(int offset) {
        this.requireSdkVersion(11);
        this.mList.smoothScrollByOffset(offset);
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=8)
    public void smoothScrollToPosition(int position) {
        if (Build.VERSION.SDK_INT < 11) {
            this.mList.smoothScrollToPosition(position);
        } else {
            int offset = this.mAdapter == null ? 0 : this.getHeaderOverlap(position);
            this.mList.smoothScrollToPositionFromTop(position, offset);
        }
    }

    @TargetApi(value=8)
    public void smoothScrollToPosition(int position, int boundPosition) {
        this.requireSdkVersion(8);
        this.mList.smoothScrollToPosition(position, boundPosition);
    }

    @TargetApi(value=11)
    public void smoothScrollToPositionFromTop(int position, int offset) {
        this.requireSdkVersion(11);
        this.mList.smoothScrollToPositionFromTop(position, offset += this.mAdapter == null ? 0 : this.getHeaderOverlap(position));
    }

    @TargetApi(value=11)
    public void smoothScrollToPositionFromTop(int position, int offset, int duration) {
        this.requireSdkVersion(11);
        this.mList.smoothScrollToPositionFromTop(position, offset += this.mAdapter == null ? 0 : this.getHeaderOverlap(position), duration);
    }

    public void setSelection(int position) {
        this.setSelectionFromTop(position, 0);
    }

    public void setSelectionAfterHeaderView() {
        this.mList.setSelectionAfterHeaderView();
    }

    public void setSelectionFromTop(int position, int y) {
        this.mList.setSelectionFromTop(position, y += this.mAdapter == null ? 0 : this.getHeaderOverlap(position));
    }

    public void setSelector(Drawable sel) {
        this.mList.setSelector(sel);
    }

    public void setSelector(int resID) {
        this.mList.setSelector(resID);
    }

    public int getFirstVisiblePosition() {
        return this.mList.getFirstVisiblePosition();
    }

    public int getLastVisiblePosition() {
        return this.mList.getLastVisiblePosition();
    }

    public void setChoiceMode(int choiceMode) {
        this.mList.setChoiceMode(choiceMode);
    }

    public void setItemChecked(int position, boolean value) {
        this.mList.setItemChecked(position, value);
    }

    @TargetApi(value=11)
    public int getCheckedItemCount() {
        this.requireSdkVersion(11);
        return this.mList.getCheckedItemCount();
    }

    @TargetApi(value=8)
    public long[] getCheckedItemIds() {
        this.requireSdkVersion(8);
        return this.mList.getCheckedItemIds();
    }

    public int getCheckedItemPosition() {
        return this.mList.getCheckedItemPosition();
    }

    public SparseBooleanArray getCheckedItemPositions() {
        return this.mList.getCheckedItemPositions();
    }

    public int getCount() {
        return this.mList.getCount();
    }

    public Object getItemAtPosition(int position) {
        return this.mList.getItemAtPosition(position);
    }

    public long getItemIdAtPosition(int position) {
        return this.mList.getItemIdAtPosition(position);
    }

    public void setOnCreateContextMenuListener(View.OnCreateContextMenuListener l) {
        this.mList.setOnCreateContextMenuListener(l);
    }

    public boolean showContextMenu() {
        return this.mList.showContextMenu();
    }

    public void invalidateViews() {
        this.mList.invalidateViews();
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (this.mList != null) {
            this.mList.setClipToPadding(clipToPadding);
        }
        this.mClippingToPadding = clipToPadding;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
        if (this.mList != null) {
            this.mList.setPadding(left, top, right, bottom);
        }
        super.setPadding(0, 0, 0, 0);
        this.requestLayout();
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public void setFastScrollEnabled(boolean fastScrollEnabled) {
        this.mList.setFastScrollEnabled(fastScrollEnabled);
    }

    private void requireSdkVersion(int versionCode) {
        if (Build.VERSION.SDK_INT < versionCode) {
            throw new ApiLevelTooLowException(versionCode);
        }
    }

    public int getPositionForView(View view) {
        return this.mList.getPositionForView(view);
    }

    private class AdapterWrapperDataSetObserver
    extends DataSetObserver {
        private AdapterWrapperDataSetObserver() {
        }

        public void onChanged() {
            StickyListHeadersListView.this.clearHeader();
        }

        public void onInvalidated() {
            StickyListHeadersListView.this.clearHeader();
        }
    }

    private class AdapterWrapperHeaderClickHandler
    implements AdapterWrapper.OnHeaderClickListener {
        private AdapterWrapperHeaderClickHandler() {
        }

        @Override
        public void onHeaderClick(View header, int itemPosition, long headerId) {
            StickyListHeadersListView.this.mOnHeaderClickListener.onHeaderClick(StickyListHeadersListView.this, header, itemPosition, headerId, false);
        }
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(StickyListHeadersListView var1, View var2, int var3, long var4, boolean var6);
    }

    private class WrapperListScrollListener
    implements AbsListView.OnScrollListener {
        private WrapperListScrollListener() {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (StickyListHeadersListView.this.mOnScrollListenerDelegate != null) {
                StickyListHeadersListView.this.mOnScrollListenerDelegate.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            StickyListHeadersListView.this.updateOrClearHeader(StickyListHeadersListView.this.mList.getFixedFirstVisibleItem());
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (StickyListHeadersListView.this.mOnScrollListenerDelegate != null) {
                StickyListHeadersListView.this.mOnScrollListenerDelegate.onScrollStateChanged(view, scrollState);
            }
        }
    }

    private class WrapperViewListLifeCycleListener
    implements WrapperViewList.LifeCycleListener {
        private WrapperViewListLifeCycleListener() {
        }

        @Override
        public void onDispatchDrawOccurred(Canvas canvas) {
            if (Build.VERSION.SDK_INT < 8) {
                StickyListHeadersListView.this.updateOrClearHeader(StickyListHeadersListView.this.mList.getFixedFirstVisibleItem());
            }
            if (StickyListHeadersListView.this.mHeader != null) {
                if (StickyListHeadersListView.this.mClippingToPadding) {
                    canvas.save();
                    canvas.clipRect(0, StickyListHeadersListView.this.mPaddingTop, StickyListHeadersListView.this.getRight(), StickyListHeadersListView.this.getBottom());
                    StickyListHeadersListView.this.drawChild(canvas, StickyListHeadersListView.this.mHeader, 0L);
                    canvas.restore();
                } else {
                    StickyListHeadersListView.this.drawChild(canvas, StickyListHeadersListView.this.mHeader, 0L);
                }
            }
        }
    }
}

