# 2.0 介紹

Hyperf 是基於 `Swoole 4.5+` 實現的高效能、高靈活性的 PHP 協程框架，內建協程伺服器及大量常用的元件，效能較傳統基於 `PHP-FPM` 的框架有質的提升，提供超高效能的同時，也保持著極其靈活的可擴充套件性，標準組件均基於 [PSR 標準](https://www.php-fig.org/psr) 實現，基於強大的依賴注入設計，保證了絕大部分元件或類都是 `可替換` 與 `可複用` 的。
   
框架元件庫除了常見的協程版的 `MySQL 客戶端`、`Redis 客戶端`，還為您準備了協程版的 `Eloquent ORM`、`WebSocket 服務端及客戶端`、`JSON RPC 服務端及客戶端`、`GRPC 服務端及客戶端`、`Zipkin/Jaeger (OpenTracing) 客戶端`、`Guzzle HTTP 客戶端`、`Elasticsearch 客戶端`、`Consul 客戶端`、`ETCD 客戶端`、`AMQP 元件`、`Apollo 配置中心`、`阿里雲 ACM 應用配置管理`、`ETCD 配置中心`、`基於令牌桶演算法的限流器`、`通用連線池`、`熔斷器`、`Swagger 文件生成`、`Swoole Tracker`、`檢視引擎`、`Snowflake 全域性 ID 生成器` 等元件，省去了自己實現對應協程版本的麻煩。  

Hyperf 還提供了 `基於 PSR-11 的依賴注入容器`、`註解`、`AOP 面向切面程式設計`、`基於 PSR-15 的中介軟體`、`自定義程序`、`基於 PSR-14 的事件管理器`、`Redis/RabbitMQ 訊息佇列`、`自動模型快取`、`基於 PSR-16 的快取`、`Crontab 秒級定時任務`、`國際化`、`Validation 表單驗證器` 等非常便捷的功能，滿足豐富的技術場景和業務場景，開箱即用。

# 框架初衷

儘管現在基於 PHP 語言開發的框架處於一個百家爭鳴的時代，但仍舊未能看到一個優雅的設計與超高效能的共存的完美框架，亦沒有看到一個真正為 PHP 微服務鋪路的框架，此為 Hyperf 及其團隊成員的初衷，我們將持續投入併為此付出努力，也歡迎你加入我們參與開源建設。

# 設計理念

`Hyperspeed + Flexibility = Hyperf`，從名字上我們就將 `超高速` 和 `靈活性` 作為 Hyperf 的基因。
   
- 對於超高速，我們基於 Swoole 協程並在框架設計上進行大量的優化以確保超高效能的輸出。   
- 對於靈活性，我們基於 Hyperf 強大的依賴注入元件，元件均基於 [PSR 標準](https://www.php-fig.org/psr) 的契約和由 Hyperf 定義的契約實現，達到框架內的絕大部分的元件或類都是可替換的。   

基於以上的特點，Hyperf 將存在豐富的可能性，如實現 Web 服務，閘道器服務，分散式中介軟體，微服務架構，遊戲伺服器，物聯網（IOT）等。

# 生產可用

我們為元件進行了大量的單元測試以保證邏輯的正確，同時維護了高質量的文件，在 Hyperf 正式對外開放之前，便已經過了嚴酷的生產環境的考驗，我們才正式的對外開放該專案，至今，已有很多的大型/中小型網際網路公司在生產環境使用 Hyperf。
