$(function(){
	  function mainSlider() {
				var BasicSlider = $(".slider-active");
				BasicSlider.on("init", function(e, slick) {
				  var $firstAnimatingElements = $(".sliderbg:first-child").find(
					"[data-animation]"
				  );
				  //console.log($firstAnimatingElements);
				  doAnimations($firstAnimatingElements);
				});
				BasicSlider.on("beforeChange", function(e, slick, currentSlide, nextSlide) {
				  var $animatingElements = $(
					'.sliderbg[data-slick-index="' + nextSlide + '"]'
				  ).find("[data-animation]");
				  doAnimations($animatingElements);
				});
				BasicSlider.slick({
				  autoplay: true,
				  autoplaySpeed: 10000,
				  fade: true,
				  prevArrow:
					'<button type="button" class="slick-prev"><i class="icofont-long-arrow-left"></i>Prev</button>',
				  nextArrow:
					'<button type="button" class="slick-next"><i class="icofont-long-arrow-right"></i>Next</button>',
				  arrows: true,
				  dots: true,
				  responsive: [
					{ breakpoint: 767, settings: { dots: false, arrows: true } }
				  ]
				});

				function doAnimations(elements) {
				  var animationEndEvents =
					"webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
				  elements.each(function() {
					var $this = $(this);
					var $animationDelay = $this.data("delay");
					var $animationType = "animated " + $this.data("animation");
					$this.css({
					  "animation-delay": $animationDelay,
					  "-webkit-animation-delay": $animationDelay
					});
					$this.addClass($animationType).one(animationEndEvents, function() {
					  $this.removeClass($animationType);
					});
				  });
				}
  }

  mainSlider();


});
