<?php

if(!defined('OT_ROOT')) {
	exit('Access Denied');
}



class UserGroup{
	public $userID		= 0;
	public $groupID		= 0;
	public $row			= null;
	public $fieldStr	= '';
	public $errMode	= '';

	public function __construct($userID=0, $fieldStr='UG_theme,UG_infoTotalNum,UG_infoDayNum,UG_infoScore1,UG_infoScore2,UG_infoScore3,UG_event', $errMode='die'){
		$this->GetId($userID);
		if ($fieldStr != 'no'){
			$this->GetData($fieldStr);
		}
		$this->fieldStr	= $fieldStr;
		$this->errMode	= $errMode;
	}


	// 获取当前真实会员组ID
	public static function CurrId($groupID, $isTime, $endTime){
		if ($isTime == 1){
			if (strtotime($endTime) >= time()){
				return $groupID;
			}else{
				return 1;
			}
		}else{
			return $groupID;
		}
	}


	// 获取会员组名称
	public static function CurrName($groupID, $userGroupArr=array()){
		if (count($userGroupArr) == 0){
			$userGroupArr = Cache::PhpFile('userGroup');
		}
		return isset($userGroupArr[$groupID]) ? $userGroupArr[$groupID] : '无';
	}

	// 获取会员组名称（旧函数，为兼容保留，后期废弃）
	public static function ArrName($groupID, $userGroupArr=array()){
		return self::CurrName($groupID, $userGroupArr);
	}


	// 获取会员组ID
	public function GetId($userID=0){
		if ($userID > 0){
			global $DB;
			$this->userID = $userID;
			$urow = $DB->GetRow('select UE_groupID,UE_isGroupTime,UE_groupTime from '. OT_dbPref .'users where UE_ID='. $userID);
			$this->groupID = self::CurrId($urow['UE_groupID'], $urow['UE_isGroupTime'], $urow['UE_groupTime']);
		}
		return $this->groupID;
	}


	// 获取会员组名称
	public function GetName($userGroupArr=array()){
		if (isset($this->row['UG_theme'])){
			return $this->row['UG_theme'];
		}else{
			if (count($userGroupArr) == 0){
				$userGroupArr = Cache::PhpFile('userGroup');
			}
			return isset($userGroupArr[$this->groupID]) ? $userGroupArr[$this->groupID] : '无';
		}
	}


	// 获取会员组字段信息
	public function GetData($fieldStr=''){
		if ($this->row && strlen($fieldStr)==0){
		
		}else{
			global $DB;
			if (strlen($fieldStr)==0){ $fieldStr = $this->fieldStr; }
			$this->row = $DB->GetRow('select '. $fieldStr .' from '. OT_dbPref .'userGroup where UG_ID='. $this->groupID);
		}
		return $this->row;
	}


	// 获取会员总投稿数限制
	public function InfoTotalNumArr(){
		if (isset($this->row['UG_infoTotalNum'])){
			if ($this->row['UG_infoTotalNum'] > 0){
				global $DB;
				$currInfoNum = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_userID='. $this->userID);
				$diffNum = $this->row['UG_infoTotalNum'] - $currInfoNum;
				if ($diffNum <= 0){
					if ($diffNum < 0){ $diffNum = 0; }
					return array('res'=>false, 'note'=>'您当前总投稿数限制 '. $this->row['UG_infoTotalNum'] .' 篇，已投稿 '. $currInfoNum .' 篇，还剩 '. $diffNum .' 篇。');
				}else{
					return array('res'=>true, 'note'=>'您当前总投稿数限制 '. $this->row['UG_infoTotalNum'] .' 篇，已投稿 '. $currInfoNum .' 篇，还剩 '. $diffNum .' 篇。');
				}
			}else{
				return array('res'=>true, 'note'=>'');	// 您当前会员组总投稿数无限制。
			}
		}else{
			return array('res'=>false, 'note'=>'您当前会员组不存在，有问题请联系管理员。');
		}
	}


	// 获取会员每日投稿限制
	public function InfoDayNumArr(){
		if (isset($this->row['UG_infoDayNum'])){
			global $DB;
			$todayDate	= TimeDate::Get('date');
			$todayTomo	= TimeDate::Add('d',1,$todayDate);
			$currInfoNum = $DB->GetOne('select count(IF_ID) from '. OT_dbPref .'info where IF_userID='. $this->userID .' and IF_time>='. $DB->ForTime($todayDate) .' and IF_time<'. $DB->ForTime($todayTomo));
			$diffNum = $this->row['UG_infoDayNum'] - $currInfoNum;
			if ($diffNum <= 0){
				if ($diffNum < 0){ $diffNum = 0; }
				return array('res'=>false, 'note'=>'您当前每日投稿限制 '. $this->row['UG_infoDayNum'] .' 篇，已投稿 '. $currInfoNum .' 篇，还剩 '. $diffNum .' 篇。');
			}else{
				return array('res'=>true, 'note'=>'您当前每日投稿限制 '. $this->row['UG_infoDayNum'] .' 篇，已投稿 '. $currInfoNum .' 篇，还剩 '. $diffNum .' 篇。');
			}
		}else{
			return array('res'=>false, 'note'=>'您当前会员组不存在，有问题请联系管理员。');
		}
	}

}
?>