<?php

/**
 * Korean language file
 *
 * 
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author YoungJoon Kim <yjkim@terratech.com>
 * @copyright 2004-2020 phpMyFAQ Team
 * @license http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2004-07-10
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "ko";
$PMF_LANG["language"] = "Korean";
$PMF_LANG["dir"] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "카테고리";
$PMF_LANG["msgShowAllCategories"] = "모든 카테고리 보이기";
$PMF_LANG["msgSearch"] = "검색";
$PMF_LANG["msgAddContent"] = "FAQ 추가(제안)";
$PMF_LANG["msgQuestion"] = "질문 하기";
$PMF_LANG["msgOpenQuestions"] = "질문 보기";
$PMF_LANG["msgHelp"] = "도움말";
$PMF_LANG["msgContact"] = "문의";
$PMF_LANG["msgHome"] = "FAQ 홈";
$PMF_LANG["msgNews"] = "공지사항";
$PMF_LANG["msgUserOnline"] = " 사용자 접속중";
$PMF_LANG["msgXMLExport"] = "XML파일";
$PMF_LANG["msgBack2Home"] = "홈페이지로";

// Contentpages
$PMF_LANG["msgFullCategories"] = "카테고리";
$PMF_LANG["msgFullCategoriesIn"] = "카테고리";
$PMF_LANG["msgSubCategories"] = "하위 카테고리";
$PMF_LANG["msgEntries"] = "개";
$PMF_LANG["msgEntriesIn"] = "카테고리명: ";
$PMF_LANG["msgViews"] = "회 열람";
$PMF_LANG["msgPage"] = "페이지 ";
$PMF_LANG["msgPages"] = "페이지 중";
$PMF_LANG["msgPrevious"] = "이전";
$PMF_LANG["msgNext"] = "다음";
$PMF_LANG["msgCategoryUp"] = "상위 카테고리로";
$PMF_LANG["msgLastUpdateArticle"] = "마지막 수정: ";
$PMF_LANG["msgAuthor"] = "작성자: ";
$PMF_LANG["msgPrinterFriendly"] = "인쇄용 페이지";
$PMF_LANG["msgPrintArticle"] = "이 내용을 인쇄";
$PMF_LANG["msgMakeXMLExport"] = "XML형식으로 내보내기";
$PMF_LANG["msgAverageVote"] = "평점";
$PMF_LANG["msgVoteUsability"] = "이 내용을 평가해 주세요";
$PMF_LANG["msgVoteFrom"] = " - ";
$PMF_LANG["msgVoteBad"] = "전혀 도움 안됨";
$PMF_LANG["msgVoteGood"] = "매우 유익함";
$PMF_LANG["msgVotings"] = "투표 ";
$PMF_LANG["msgVoteSubmit"] = "평가";
$PMF_LANG["msgVoteThanks"] = "평가해 주셔서 감사합니다.";
$PMF_LANG["msgYouCan"] = " ";
$PMF_LANG["msgWriteComment"] = "코멘트 달기";
$PMF_LANG["msgShowCategory"] = "카테고리: ";
$PMF_LANG["msgCommentBy"] = "작성자 -  ";
$PMF_LANG["msgCommentHeader"] = "이 내용에 대해 코멘트 달기";
$PMF_LANG["msgYourComment "] = "당신의 코멘트";
$PMF_LANG["msgCommentThanks"] = "코멘트를 해 주셔서 감사합니다.";
$PMF_LANG["msgSeeXMLFile"] = "XML파일 열기";
$PMF_LANG["msgSend2Friend"] = "친구에게 보내기";
$PMF_LANG["msgS2FName"] = "이름";
$PMF_LANG["msgS2FEMail"] = "메일주소";
$PMF_LANG["msgS2FFriends"] = "친구 주소";
$PMF_LANG["msgS2FEMails"] = ". 메일주소";
$PMF_LANG["msgS2FText"] = "아래에 추가해서 보낼 내용을 입력해 주세요";
$PMF_LANG["msgS2FText2"] = "다음 주소에서 아래 내용을 보실 수 있습니다";
$PMF_LANG["msgS2FMessage"] = "추가 메시지";
$PMF_LANG["msgS2FButton"] = "메일 보내기";
$PMF_LANG["msgS2FThx"] = "추천해 주셔서 감사합니다.";
$PMF_LANG["msgS2FMailSubject"] = "Recommendation from ";

// Search
$PMF_LANG["msgSearchWord"] = "검색어";
$PMF_LANG["msgSearchFind"] = "검색 결과 ";
$PMF_LANG["msgSearchAmount"] = " 검색 결과";
$PMF_LANG["msgSearchAmounts"] = " 검색 결과";
$PMF_LANG["msgSearchCategory"] = "카테고리: ";
$PMF_LANG["msgSearchContent"] = "내용: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "FAQ 추가(제안)";
$PMF_LANG["msgNewContentAddon"] = "제안하신 내용은 곧바로 추가되지는 않습니다. 관리자가 검토한 후에 추가될 것입니다. <strong>이름</strong>, <strong>메일주소</strong>, <strong>카테고리</strong>, <strong>제목</strong>, <strong>FAQ 내용</strong>은 필수 입력 항목입니다. 키워드에는 '스페이스(Space)'키로 분리해서 입력하십시오.";
$PMF_LANG["msgNewContentName"] = "이름";
$PMF_LANG["msgNewContentMail"] = "메일주소";
$PMF_LANG["msgNewContentCategory"] = "카테고리 선택";
$PMF_LANG["msgNewContentTheme"] = "제목";
$PMF_LANG["msgNewContentArticle"] = "FAQ 내용";
$PMF_LANG["msgNewContentKeywords"] = "키워드";
$PMF_LANG["msgNewContentLink"] = "관련 URL";
$PMF_LANG["msgNewContentSubmit"] = "전송";
$PMF_LANG["msgInfo"] = "추가 정보: ";
$PMF_LANG["msgNewContentThanks"] = "제안해 주셔서 감사합니다.";
$PMF_LANG["msgNoQuestionsAvailable"] = "현재 처리해야 할 질문이 없습니다.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "질문하고 싶은 내용을 입력해 주세요";
$PMF_LANG["msgAskCategory"] = "카테고리 선택";
$PMF_LANG["msgAskYourQuestion"] = "질문 내용";
$PMF_LANG["msgAskThx4Mail"] = "<h2>질문해 주셔서 감사합니다.</h2>";
$PMF_LANG["msgDate_User"] = "날짜 / 사용자";
$PMF_LANG["msgQuestion2"] = "질문";
$PMF_LANG["msg2answer"] = "답변";
$PMF_LANG["msgQuestionText"] = "다른 사용자가 질문한 내용을 보실 수 있습니다. 질문에 답변하시면 FAQ에 추가될 수 있습니다.";

// Help
$PMF_LANG["msgHelpText"] = "FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) 의 사용 방법은 간단합니다. <strong><a href=\"?action=show\">카테고리</a></strong> 에서 궁금한 내용을 항목별로 찾거나 <strong><a href=\"?action=search\">검색</a></strong> 에서 검색어를 입력하여 찾으실 수 있습니다.";

// Contact
$PMF_LANG["msgContactEMail"] = "관리자에게 메일 보내기";
$PMF_LANG["msgMessage"] = "메시지 내용";

// Startseite
$PMF_LANG["msgNews"] = " 공지사항";
$PMF_LANG["msgTopTen"] = "TOP 10";
$PMF_LANG["msgHomeThereAre"] = "총 ";
$PMF_LANG["msgHomeArticlesOnline"] = " 개의 FAQ가 있습니다.";
$PMF_LANG["msgNoNews"] = "새로운 소식이 없습니다.";
$PMF_LANG["msgLatestArticles"] = "최근에 작성된 5개의 질문";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "FAQ에 제안을 해 주셔서 대단히 감사합니다.";
$PMF_LANG["msgMailCheck"] = "새로운 내용이 있습니다.\n 관리자 페이지를 확인해 주십시오.";
$PMF_LANG["msgMailContact"] = "관리자에게 메시지가 전달되었습니다.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "데이터베이스에 접속할 수 없습니다.";
$PMF_LANG["err_noHeaders"] = "등록된 카테고리가 없습니다.";
$PMF_LANG["err_noArticles"] = "등록된 데이터가 없습니다.";
$PMF_LANG["err_badID"] = "잘못된 ID";
$PMF_LANG["err_noTopTen"] = "TOP 10을 이용하실 수 없습니다.";
$PMF_LANG["err_nothingFound"] = "검색 결과가 없습니다.";
$PMF_LANG["err_SaveEntries"] = "<strong>이름</strong>, <strong>메일주소</strong>, <strong>카테고리</strong>, <strong>제목</strong>, <strong>FAQ 내용</strong>은 필수 입력 항목입니다.<br><br>\n<a href=\"javascript:history.back();\">되돌아 가기</a><br><br>\n";
$PMF_LANG["err_SaveComment"] = "<strong>이름</strong>, <strong>메일주소</strong>, <strong>코멘트 내용</strong>은 필수 입력 항목입니다.<br><br>\n<a href=\"javascript:history.back();\">되돌아 가기</a><br><br>\n";
$PMF_LANG["err_VoteTooMuch"] = "중복 평가 하실 수 없습니다. 되돌아 가시려면여기를 클릭하세요.";
$PMF_LANG["err_noVote"] = "<strong>평점을 선택하지 않으셨습니다.</strong> 평가를  다시 하시려면<a href=\"javascript:history.back();\">여기</a>를 클릭하세요.";
$PMF_LANG["err_noMailAdress"] = "메일주소가 바르지 않습니다.<br><a href=\"javascript:history.back();\">되돌아 가기</a>";
$PMF_LANG["err_sendMail"] = "<strong>이름</strong>, <strong>메일주소</strong>, <strong>질문 내용</strong>은 필수 입력 항목입니다.";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>내용 검색:</strong><br><strong style=\"color: Red;\">단어1 단어2</strong>로 검색하시면, 2개 이상의 검색 결과를 관련이 높은 순서대로 찾으실 수 있습니다.<strong>주의:</strong> 검색시에는 적어도 영문 4자 이상을 입력하셔야 합니다.";

// Men
$PMF_LANG["ad"] = "관리자 페이지";
$PMF_LANG["ad_menu_user_administration"] = "사용자 관리";
$PMF_LANG["ad_menu_entry_aprove"] = "FAQ 승인";
$PMF_LANG["ad_menu_entry_edit"] = "FAQ 관리";
$PMF_LANG["ad_menu_categ_add"] = "카테고리 추가";
$PMF_LANG["ad_menu_categ_edit"] = "카테고리 수정";
$PMF_LANG["ad_menu_news_add"] = "공지 추가";
$PMF_LANG["ad_menu_news_edit"] = "공지 수정";
$PMF_LANG["ad_menu_open"] = "질문 수정";
$PMF_LANG["ad_menu_stat"] = "통계";
$PMF_LANG["ad_menu_cookie"] = "쿠키 설정";
$PMF_LANG["ad_menu_session"] = "세션 보기";
$PMF_LANG["ad_menu_adminlog"] = "관리 로그 보기";
$PMF_LANG["ad_menu_passwd"] = "비밀번호 변경";
$PMF_LANG["ad_menu_logout"] = "로그아웃";
$PMF_LANG["ad_menu_startpage"] = "시작 페이지";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "로그인을 하십시오.";
$PMF_LANG["ad_msg_passmatch"] = "비밀번호는 반드시 <strong>일치</strong>하여야 합니다.";
$PMF_LANG["ad_msg_savedsuc_1"] = "";
$PMF_LANG["ad_msg_savedsuc_2"] = " 의 프로필이 성공적으로 저장되었습니다.";
$PMF_LANG["ad_msg_mysqlerr"] = "<strong>데이터베이스 에러</strong>로 인하여 프로필을 저장할 수 없습니다.";
$PMF_LANG["ad_msg_noauth"] = "사용 권한이 없습니다.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "페이지";
$PMF_LANG["ad_gen_of"] = "of";
$PMF_LANG["ad_gen_lastpage"] = "이전 페이지";
$PMF_LANG["ad_gen_nextpage"] = "다음 페이지";
$PMF_LANG["ad_gen_save"] = "저장";
$PMF_LANG["ad_gen_reset"] = "리셋";
$PMF_LANG["ad_gen_yes"] = "예";
$PMF_LANG["ad_gen_no"] = "아니오";
$PMF_LANG["ad_gen_top"] = "제일 위로";
$PMF_LANG["ad_gen_ncf"] = "등록된 카테고리가 없습니다.";
$PMF_LANG["ad_gen_delete"] = "삭제";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "사용자 관리";
$PMF_LANG["ad_user_username"] = "등록 사용자";
$PMF_LANG["ad_user_rights"] = "권한";
$PMF_LANG["ad_user_edit"] = "수정";
$PMF_LANG["ad_user_delete"] = "삭제";
$PMF_LANG["ad_user_add"] = "사용자 추가";
$PMF_LANG["ad_user_profou"] = "사용자 프로필: ";
$PMF_LANG["ad_user_name"] = "ID";
$PMF_LANG["ad_user_password"] = "비밀번호";
$PMF_LANG["ad_user_confirm"] = "비밀번호 확인";
$PMF_LANG["ad_user_rights"] = "권한";
$PMF_LANG["ad_user_del_1"] = "사용자";
$PMF_LANG["ad_user_del_2"] = " 를 삭제 합니다.";
$PMF_LANG["ad_user_del_3"] = "삭제 하시겠습니까?";
$PMF_LANG["ad_user_deleted"] = "사용자를 성공적으로 삭제하였습니다.";
$PMF_LANG["ad_user_checkall"] = "전체 선택";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "FAQ 관리";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Topic";
$PMF_LANG["ad_entry_action"] = "동작";
$PMF_LANG["ad_entry_edit_1"] = "FAQ 추가(수정)";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "제목";
$PMF_LANG["ad_entry_content"] = "내용";
$PMF_LANG["ad_entry_keywords"] = "키워드";
$PMF_LANG["ad_entry_author"] = "작성자";
$PMF_LANG["ad_entry_category"] = "카테고리";
$PMF_LANG["ad_entry_active"] = "사용";
$PMF_LANG["ad_entry_date"] = "날짜";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "변경?";
$PMF_LANG["ad_entry_changelog"] = "변경이력";
$PMF_LANG["ad_entry_commentby 	"] = "코멘트 작성자";
$PMF_LANG["ad_entry_comment"] = "코멘트";
$PMF_LANG["ad_entry_save"] = "저장";
$PMF_LANG["ad_entry_delete"] = "삭제";
$PMF_LANG["ad_entry_delcom_1"] = " ";
$PMF_LANG["ad_entry_delcom_2"] = " 님의 코멘트를 삭제하시겠습니까?";
$PMF_LANG["ad_entry_commentdelsuc"] = "코멘트가 <strong>성공적으로</strong> 삭제되었습니다.";
$PMF_LANG["ad_entry_back"] = "돌아가기";
$PMF_LANG["ad_entry_commentdelfail"] = "코멘트는 삭제 되지 않았습니다.";
$PMF_LANG["ad_entry_savedsuc"] = "변경 내용이 <strong>성공적으로</strong> 저장되었습니다.";
$PMF_LANG["ad_entry_savedfail 	"] = "<strong>데이터베이스 에러</strong> 가 발생하였습니다.";
$PMF_LANG["ad_entry_del_1"] = "";
$PMF_LANG["ad_entry_del_2"] = "에 관한";
$PMF_LANG["ad_entry_del_3"] = " 님의 FAQ를 삭제하시겠습니까?";
$PMF_LANG["ad_entry_delsuc"] = "<strong>성공적으로</strong> 삭제되었습니다.";
$PMF_LANG["ad_entry_delfail"] = "삭제 되지 않았습니다.";
$PMF_LANG["ad_entry_back"] = "뒤로";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "공지 제목";
$PMF_LANG["ad_news_text"] = "내용";
$PMF_LANG["ad_news_link_url"] = "관련 Link: (<strong>http:// 없이 입력</strong>)!";
$PMF_LANG["ad_news_link_title"] = "Link의 간략 설명(타이틀)";
$PMF_LANG["ad_news_link_target"] = "Link 보이기";
$PMF_LANG["ad_news_link_window"] = "새창에서 보이기";
$PMF_LANG["ad_news_link_faq"] = "현재창(FAQ)에서 보이기";
$PMF_LANG["ad_news_add"] = "공지 추가";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "제목";
$PMF_LANG["ad_news_date"] = "날짜";
$PMF_LANG["ad_news_action"] = "동작";
$PMF_LANG["ad_news_update"] = "수정";
$PMF_LANG["ad_news_delete"] = "삭제";
$PMF_LANG["ad_news_nodata"] = "등록된 데이터가 없습니다.";
$PMF_LANG["ad_news_updatesuc"] = "수정되었습니다.";
$PMF_LANG["ad_news_del"] = "공지사항을 삭제하시겠습니까?";
$PMF_LANG["ad_news_yesdelete"] = "예";
$PMF_LANG["ad_news_nodelete"] = "아니오";
$PMF_LANG["ad_news_delsuc"] = "삭제되었습니다.";
$PMF_LANG["ad_news_updatenews"] = "공지 수정";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "카테고리 추가";
$PMF_LANG["ad_categ_catnum"] = "카테고리 번호";
$PMF_LANG["ad_categ_subcatnum"] = "하위 카테고리 번호";
$PMF_LANG["ad_categ_nya"] = "<em>사용할 수 없습니다.</em>";
$PMF_LANG["ad_categ_titel"] = "카테고리명";
$PMF_LANG["ad_categ_add"] = "카테고리 추가";
$PMF_LANG["ad_categ_existing"] = "등록된 카테고리";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "카테고리";
$PMF_LANG["ad_categ_subcateg"] = "하위 카테고리";
$PMF_LANG["ad_categ_titel"] = "카테고리명";
$PMF_LANG["ad_categ_action"] = "동작";
$PMF_LANG["ad_categ_update"] = "수정";
$PMF_LANG["ad_categ_delete"] = "삭제";
$PMF_LANG["ad_categ_updatecateg"] = "카테고리 수정";
$PMF_LANG["ad_categ_nodata"] = "등록된 데이터가 없습니다.";
$PMF_LANG["ad_categ_remark"] = "카테고리를 삭제하면 해당 카테고리의 FAQ를 더 이상 볼 수 없습니다. 해당 FAQ를 삭제하던지 새로운 카테고리를 지정하여야만 합니다.";
$PMF_LANG["ad_categ_edit_1"] = "수정";
$PMF_LANG["ad_categ_edit_2"] = "카테고리";
$PMF_LANG["ad_categ_add"] = "카테고리 추가";
$PMF_LANG["ad_categ_added"] = "카테고리가 추가되었습니다.";
$PMF_LANG["ad_categ_updated"] = "카테고리가 수정되었습니다.";
$PMF_LANG["ad_categ_del_yes"] = "예";
$PMF_LANG["ad_categ_del_no"] = "아니오";
$PMF_LANG["ad_categ_deletesure"] = "카테고리를 삭제하시겠습니까?";
$PMF_LANG["ad_categ_deleted"] = "카테고리가 삭제되었습니다.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc 	"] = "쿠키가 <strong>성공적으로</strong> 설정되었습니다.";
$PMF_LANG["ad_cookie_already"] = "쿠키가 이미 설정되어 있습니다. 다음과 같은 옵션이 있습니다.";
$PMF_LANG["ad_cookie_again"] = "쿠키 다시 설정";
$PMF_LANG["ad_cookie_delete"] = "쿠키 삭제";
$PMF_LANG["ad_cookie_no"] = "저장된 쿠키가 없습니다. 쿠키를 가지고 로그인 스크립트를 저장할 수 있게됩니다. 아래와 같은 옵션이 있습니다.";
$PMF_LANG["ad_cookie_set"] = "쿠키 설정";
$PMF_LANG["ad_cookie_deleted"] = "쿠키가 성공적으로 삭제되었습니다.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "관리 로그";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "비밀번호 변경";
$PMF_LANG["ad_passwd_old"] = "현재 비밀번호";
$PMF_LANG["ad_passwd_new"] = "새로운 비밀번호";
$PMF_LANG["ad_passwd_con"] = "새로운 비밀번호 재확인";
$PMF_LANG["ad_passwd_change"] = "비밀번호 변경";
$PMF_LANG["ad_passwd_suc"] = "비밀번호가 성공적으로 변경되었습니다.";
$PMF_LANG["ad_passwd_remark"] = "<strong>주의:</strong><br>쿠키를 다시 설정하여 주십시오.";
$PMF_LANG["ad_passwd_fail"] = "'현재 비밀번호'를 <strong>정확하게</strong> 입력하시고, '새로운 비밀번호' 와 '새로운 비밀번호 재확인' 은 반드시 <strong>일치</strong>하여야 합니다.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "사용자 추가";
$PMF_LANG["ad_adus_name"] = "ID";
$PMF_LANG["ad_adus_password"] = "비밀번호";
$PMF_LANG["ad_adus_add"] = "사용자 추가";
$PMF_LANG["ad_adus_suc"] = "사용자가 <strong>성공적으로</strong> 추가되었습니다.";
$PMF_LANG["ad_adus_edit"] = "프로필 수정";
$PMF_LANG["ad_adus_dberr"] = "<strong>데이터베이스 에러!</strong>";
$PMF_LANG["ad_adus_exerr"] = "사용자명이 이미 <strong>존재</strong>합니다.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "세션 ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "시간";
$PMF_LANG["ad_sess_pageviews"] = "페이지뷰";
$PMF_LANG["ad_sess_search"] = "검색";
$PMF_LANG["ad_sess_sfs"] = "세션 검색";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "min. actions";
$PMF_LANG["ad_sess_s_date"] = "날짜";
$PMF_LANG["ad_sess_s_after"] = "시작";
$PMF_LANG["ad_sess_s_before"] = "종료";
$PMF_LANG["ad_sess_s_search"] = "검색";
$PMF_LANG["ad_sess_session"] = "세션";
$PMF_LANG["ad_sess_r"] = "검색 결과 - ";
$PMF_LANG["ad_sess_referer"] = "참조 페이지";
$PMF_LANG["ad_sess_browser"] = "브라우저";
$PMF_LANG["ad_sess_ai_rubrik"] = "카테고리";
$PMF_LANG["ad_sess_ai_artikel"] = "내용";
$PMF_LANG["ad_sess_ai_sb"] = "검색어";
$PMF_LANG["ad_sess_ai_sid"] = "세션 ID";
$PMF_LANG["ad_sess_back"] = "뒤로";

// Statistik
$PMF_LANG["ad_rs"] = "평점 통계";
$PMF_LANG["ad_rs_rating_1"] = "The ranking of";
$PMF_LANG["ad_rs_rating_2"] = "users shows";
$PMF_LANG["ad_rs_red"] = "빨강";
$PMF_LANG["ad_rs_green"] = "초록";
$PMF_LANG["ad_rs_altt"] = "평균 2보다 낮음";
$PMF_LANG["ad_rs_ahtf"] = "평균 4보다 높음";
$PMF_LANG["ad_rs_no"] = "등록된 데이터가 없습니다.";

// Auth
$PMF_LANG["ad_auth_insert"] = "ID와 비밀번호를 입력하세요.";
$PMF_LANG["ad_auth_user"] = "ID";
$PMF_LANG["ad_auth_passwd"] = "비밀번호";
$PMF_LANG["ad_auth_ok"] = "로그인";
$PMF_LANG["ad_auth_reset"] = "리셋";
$PMF_LANG["ad_auth_fail"] = "ID 또는 비밀번호가 바르지 않습니다.";
$PMF_LANG["ad_auth_sess"] = "세션 ID가 종료되었습니다.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "환경설정";
$PMF_LANG["ad_config_save"] = "저장";
$PMF_LANG["ad_config_reset"] = "취소";
$PMF_LANG["ad_config_saved"] = "환경설정이 성공적으로 저장되었습니다.";
$PMF_LANG["ad_menu_editconfig"] = "환경설정";
$PMF_LANG["ad_att_none"] = "파일을 첨부할 수 없습니다.";
$PMF_LANG["ad_att_att"] = "첨부";
$PMF_LANG["ad_att_add"] = "첨부 파일";
$PMF_LANG["ad_entryins_suc"] = "성공적으로 저장되었습니다.";
$PMF_LANG["ad_entryins_fail"] = "에러가 발생하였습니다.";
$PMF_LANG["ad_att_del"] = "삭제";
$PMF_LANG["ad_att_nope"] = "첨부파일은 내용 편집중에만 추가될 수 있습니다.";
$PMF_LANG["ad_att_delsuc"] = "첨부파일을 성공적으로 삭제하였습니다.";
$PMF_LANG["ad_att_delfail"] = "첨부 삭제시 에러가 발생하였습니다.";
$PMF_LANG["ad_entry_add"] = "FAQ 내용 추가";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "데이터베이스의 내용을 그대로 백업합니다. 적어도 1달에 1번은 백업을 하시기 바랍니다. 백업 파일은 MySQL의 트랜잭션 파일 포맷으로 phpMyAdmin이나 MySQL 클라이언트 등에 의해서도 불러올 수 있습니다.";
$PMF_LANG["ad_csv_link"] = "백업 다운로드";
$PMF_LANG["ad_csv_head"] = "백업 하기";
$PMF_LANG["ad_att_addto"] = "파일을 첨부하기";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "파일";
$PMF_LANG["ad_att_butt"] = "확인";
$PMF_LANG["ad_att_suc"] = "파일이 성공적으로 첨부되었습니다.";
$PMF_LANG["ad_att_fail"] = "파일 첨부시 에러가 발생하였습니다.";
$PMF_LANG["ad_att_close"] = "윈도우 닫기";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "phpMyFAQ에서 만들어진 백업 데이터를 복구할수 있습니다. 복구를 할 경우 기존의 데이터는 사라집니다.";
$PMF_LANG["ad_csv_file"] = "파일";
$PMF_LANG["ad_csv_ok"] = "확인";
$PMF_LANG["ad_csv_linklog"] = "로그 백업";
$PMF_LANG["ad_csv_linkdat"] = "데이터 백업";
$PMF_LANG["ad_csv_head2"] = "복구";
$PMF_LANG["ad_csv_no"] = "phpMyFAQ의 백업 파일이 아닌것 같습니다.";
$PMF_LANG["ad_csv_prepare"] = "데이터베이스 쿼리 준비중......";
$PMF_LANG["ad_csv_process"] = "쿼리중......";
$PMF_LANG["ad_csv_of"] = "";
$PMF_LANG["ad_csv_suc"] = " 이(가) 성공하였습니다.";
$PMF_LANG["ad_csv_backup"] = "백업";
$PMF_LANG["ad_csv_rest"] = "백업 복구";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "백업";
$PMF_LANG["ad_logout"] = "세션이 성공적으로 종료되었습니다.";
$PMF_LANG["ad_news_add"] = "공지 추가";
$PMF_LANG["ad_news_edit"] = "공지 수정";
$PMF_LANG["ad_cookie"] = "쿠키";
$PMF_LANG["ad_sess_head"] = "세션 보기";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "카테고리 관리";
$PMF_LANG["ad_menu_stat"] = "평점 통계";
$PMF_LANG["ad_kateg_add"] = "카테고리 추가";
$PMF_LANG["ad_kateg_rename"] = "이름변경";
$PMF_LANG["ad_adminlog_date"] = "날짜";
$PMF_LANG["ad_adminlog_user"] = "사용자";
$PMF_LANG["ad_adminlog_ip"] = "IP주소";

$PMF_LANG["ad_stat_sess"] = "세션";
$PMF_LANG["ad_stat_days"] = "기간(일)";
$PMF_LANG["ad_stat_vis"] = "세션수 (방문수)";
$PMF_LANG["ad_stat_vpd"] = "일 방문자수";
$PMF_LANG["ad_stat_fien"] = "처음 로그";
$PMF_LANG["ad_stat_laen"] = "마지막 로그";
$PMF_LANG["ad_stat_browse"] = "세션 보기";
$PMF_LANG["ad_stat_ok"] = "확인";

$PMF_LANG["ad_sess_time"] = "시간";
$PMF_LANG["ad_sess_sid"] = "세션ID";
$PMF_LANG["ad_sess_ip"] = "IP주소";

$PMF_LANG["ad_ques_take"] = "질문 확인 및 편집";
$PMF_LANG["no_cats"] = "카테고리가 발견되지 않았습니다.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "ID 또는 비밀번호가 바르지 않습니다.";
$PMF_LANG["ad_log_sess"] = "세션이 종료되었습니다.";
$PMF_LANG["ad_log_edit"] = "\"사용자 수정\"- 다음 사용자 입력폼: ";
$PMF_LANG["ad_log_crea"] = "\"새로운 글\" 폼.";
$PMF_LANG["ad_log_crsa"] = "새로운 글(FAQ)이 추가되었습니다.";
$PMF_LANG["ad_log_ussa"] = "다음 사용자의 프로필 수정: ";
$PMF_LANG["ad_log_usde"] = "다음 사용자가 삭제됨: ";
$PMF_LANG["ad_log_beed"] = "다음 사용자의 폼을 변경: ";
$PMF_LANG["ad_log_bede"] = "다음 글이 삭제됨: ";

$PMF_LANG["ad_start_visits"] = "방문";
$PMF_LANG["ad_start_articles"] = "글(FAQ)";
$PMF_LANG["ad_start_comments"] = "코멘트";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "붙여넣기";
$PMF_LANG["ad_categ_cut"] = "잘라내기";
$PMF_LANG["ad_categ_copy"] = "복사";
$PMF_LANG["ad_categ_process"] = "카테고리 처리중......";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>사용 권한이 없습니다.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "이전 페이지";
$PMF_LANG["msgNextPage"] = "다음 페이지";
$PMF_LANG["msgPageDoublePoint"] = "페이지: ";
$PMF_LANG["msgMainCategory"] = "메인 카테고리";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "비밀번호가 변경되었습니다.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "PDF 형식으로 보기";
$PMF_LANG["ad_xml_head"] = "XML-백업";
$PMF_LANG["ad_xml_hint"] = "모든 FAQ를 한개의 XML 파일로 저장";
$PMF_LANG["ad_xml_gen"] = "XML 파일 만들기";
$PMF_LANG["ad_entry_locale"] = "언어";
$PMF_LANG["msgLanguageSubmit"] = "언어 변경";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "미리 보기";
$PMF_LANG["ad_attach_1"] = "환경설정에서 첨부파일을 저장하기 위한 디렉터리를 먼저 설정하여 주시기 바랍니다.";
$PMF_LANG["ad_attach_2"] = "환경설정에서 첨부파일을 위한 링크를 먼저 설정하여 주시기 바랍니다.";
$PMF_LANG["ad_attach_3"] = "attachment.php 파일은 권한 없이 열수 없습니다.";
$PMF_LANG["ad_attach_4"] = "첨부파일의 사이즈는 %s Bytes 보다 작아야 합니다.";
$PMF_LANG["ad_menu_export"] = "FAQ 내보내기";
$PMF_LANG["ad_export_file"] = "에러: 파일쓰기에 실패하였습니다.";
$PMF_LANG["ad_export_pdf"] = "PDF- 모든 내용을 내보내기";

$PMF_LANG["rightsLanguage"]['add_user'] = "사용자 추가";
$PMF_LANG["rightsLanguage"]['edit_user'] = "사용자 수정";
$PMF_LANG["rightsLanguage"]['delete_user'] = "사용자 삭제";
$PMF_LANG["rightsLanguage"]['add_faq'] = "내용 추가";
$PMF_LANG["rightsLanguage"]['edit_faq'] = "내용 수정";
$PMF_LANG["rightsLanguage"]['delete_faq'] = "내용 삭제";
$PMF_LANG["rightsLanguage"]['viewlog'] = "로그 보기";
$PMF_LANG["rightsLanguage"]['adminlog'] = "관리 로그 보기";
$PMF_LANG["rightsLanguage"]['delcomment'] = "코멘트 삭제";
$PMF_LANG["rightsLanguage"]['addnews'] = "공지 추가";
$PMF_LANG["rightsLanguage"]['editnews'] = "공지 수정";
$PMF_LANG["rightsLanguage"]['delnews'] = "공지 삭제";
$PMF_LANG["rightsLanguage"]['addcateg'] = "카테고리 추가";
$PMF_LANG["rightsLanguage"]['editcateg'] = "카테고리 수정";
$PMF_LANG["rightsLanguage"]['delcateg'] = "카테고리 삭제";
$PMF_LANG["rightsLanguage"]['passwd'] = "비밀번호 변경";
$PMF_LANG["rightsLanguage"]['editconfig'] = "환경설정 수정";
$PMF_LANG["rightsLanguage"]['addatt'] = "첨부 추가";
$PMF_LANG["rightsLanguage"]['delatt'] = "첨부 삭제";
$PMF_LANG["rightsLanguage"]['backup'] = "백업 하기";
$PMF_LANG["rightsLanguage"]['restore'] = "복구 하기";
$PMF_LANG["rightsLanguage"]['delquestion'] = "질문 삭제";

$PMF_LANG["msgAttachedFiles"] = "첨부 파일";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "동작";
$PMF_LANG["ad_entry_email"] = "메일주소";
$PMF_LANG["ad_entry_allowComments"] = "코멘트 가능";
$PMF_LANG["msgWriteNoComment"] = "이 항목에는 코멘트 할 수 없습니다.";
$PMF_LANG["ad_user_realname"] = "성명";
$PMF_LANG["ad_export_generate_pdf"] = "PDF 파일 생성";
$PMF_LANG["ad_export_full_faq"] = "PDF 파일로 FAQ 내보내기: ";
$PMF_LANG["err_bannedIP"] = "당신의 IP는 접근 금지되었습니다.";
$PMF_LANG["err_SaveQuestion"] = "<strong>이름</strong>, <strong>메일주소</strong>, <strong>질문 내용</strong>은 필수 입력 항목입니다.<br><br><a href=\"javascript:history.back();\">되돌아 가기</a><br><br>\n";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "색상: ";
$PMF_LANG["ad_entry_fontsize"] = "크기: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array("select", "언어");
$LANG_CONF["main.languageDetection"] = array("checkbox", "언어 자동 인식");
$LANG_CONF['main.titleFAQ'] = array("input", "홈페이지 타이틀");
$LANG_CONF['main.currentVersion'] = array("print", "FAQ 버전");
$LANG_CONF["main.metaDescription"] = array("input", "페이지 설명");
$LANG_CONF["main.metaKeywords"] = array("input", "검색 로봇을 위한 키워드 설정");
$LANG_CONF["main.metaPublisher"] = array("input", "관리자 이름");
$LANG_CONF['main.administrationMail'] = array("input", "관리자 메일주소");
$LANG_CONF["main.contactInformations"] = array("area", "문의 정보");
$LANG_CONF["main.send2friendText"] = array("area", "친구에게 보내기 페이지를 위한 텍스트");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "최대 첨부 파일 사이즈(Bytes) (최대 %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", "내용의 아래에 첨부파일 링크걸기");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", "추적기능 사용 여부");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", "관리로그 사용 여부");
$LANG_CONF["security.ipCheck"] = array("checkbox", "admin.php에서 UINs를 체크할 때 IP주소를 체크할지의 여부");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", "페이지당 표시할 글의 수");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", "공지사항 표시 개수");
$LANG_CONF['security.bannedIPs'] = array("area", "해당 IP주소로 부터 사용 금지");
$LANG_CONF["main.enableRewriteRules"] = array("checkbox", "mod_rewrite 기능을 사용하시겠습니까? (기본값: 사용안함)");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", "LDAP을 지원하도록 하시겠습니까? (기본값: 사용안함)");

$PMF_LANG["ad_categ_new_main_cat"] = "새로운 메인 카테고리로";
$PMF_LANG["ad_categ_paste_error"] = "이 카테고리를 옮기는 것은 불가능합니다.";
$PMF_LANG["ad_categ_move"] = "카테고리 이동";
$PMF_LANG["ad_categ_lang"] = "언어";
$PMF_LANG["ad_categ_desc"] = "설명";
$PMF_LANG["ad_categ_change"] = "선택한 카테고리와 자리 바꿈";

$PMF_LANG["lostPassword"] = "비밀번호를 잊으셨나요? 여기를 클릭하세요.";
$PMF_LANG["lostpwd_err_1"] = "에러: ID와 메일주소를 찾을 수 없습니다.";
$PMF_LANG["lostpwd_err_2"] = "에러: ID 와 메일주소를 입력하여 주세요.";
$PMF_LANG["lostpwd_text_1"] = "사용자 정보를 요청하셨습니다.";
$PMF_LANG["lostpwd_text_2"] = "관리자 페이지에서 새로운 비밀번호를 설정하시기 바랍니다.";
$PMF_LANG["lostpwd_mail_okay"] = "E-Mail을 보냈습니다.";

$PMF_LANG["ad_xmlrpc_button"] = "최신의 phpMyFAQ 버전을 확인하세요. ";
$PMF_LANG["ad_xmlrpc_latest"] = "최신버전을 다음 사이트에서 이용하실 수 있습니다.";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Select category language';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Sitemap';
