<?php
/**
 * 本站api接口大全
 */
$title = '系统接口中心';
include "header.php";
$cid = $DB->get_row("SELECT * FROM `sky_class` where `state` = 1 ORDER BY `cid` LIMIT 1");
$gid = $DB->get_row("SELECT * FROM `sky_goods` where `state` = 1 ORDER BY `cid` LIMIT 1");
?>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="mb-3 header-title text-success"><?= $title ?></h3>
                    </div>
                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('getclass','GET')" class="btn btn-sm btn-light">
                                        测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 getclass" title="Revenue">商品分类数据获取</h6>
                                <code class="mb-0 mt-0 font-16" id="getclass"><?= is_https(false) . href() ?>/ajax.php?act=getclass</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('getgoods','GET')" class="btn btn-sm btn-light">
                                        测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 getgoods" title="Revenue">获取分类下的商品列表</h6>
                                <code class="mb-0 mt-0 font-16" id="getgoods"><?= is_https(false) . href() ?>/ajax.php?act=getgoods&cid=<?= $cid['cid'] ?></code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="分类id">cid</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('getgoods_details','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 getgoods_details" title="Revenue">
                                    获取详细商品信息</h6>
                                <code class="mb-0 mt-0 font-16" id="getgoods_details"><?= is_https(false) . href() ?>/ajax.php?act=getgoods_details&gid=<?= $gid['gid'] ?></code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="商品id">gid</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('WebsiteData','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 WebsiteData" title="Revenue">获取系统开放数据</h6>
                                <code class="mb-0 mt-0 font-16" id="WebsiteData"><?= is_https(false) . href() ?>/api.php?act=WebsiteData</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('cashier','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 cashier" title="cashier">调用商品收银台接口</h6>
                                <code class="mb-0 mt-0 font-16" id="cashier"><?= is_https(false) . href() ?>/ajax.php?act=orders_transit&gid=<?=$gid['gid']?>&data[]=123&num=1&conts=%3Cdiv%3EQQ%E5%8F%B7%E7%A0%81%EF%BC%9A123%3C%2Fdiv%3E</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="商品id">gid</span>
                                    <span class="badge badge-primary-lighten" title="商品下单数据，数组">data</span>
                                    <span class="badge badge-primary-lighten" title="下单数量">num</span>
                                    <span class="badge badge-primary-lighten" title="下单信息，传递用户可看到的下单验证信息">conts</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                                <div class="mt-1">
                                    <span class="badge badge-dark-lighten" title="付款类型">data[]=下单参数1&data[]=下单参数2&data[]=下单参数3</span>
                                    <span class="badge badge-dark-lighten" title="下单信息2">conts=下单信息区域内容,可自定义</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('submit_input','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 submit_input" title="Revenue">调用在线付款接口</h6>
                                <code class="mb-0 mt-0 font-16" id="submit_input"><?= is_https(false) . href() ?>/ajax.php?act=submit_input&gid=<?= $gid['gid'] ?>&type=1&mode=wxpay&data=array&num=2</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="商品id">gid</span>
                                    <span class="badge badge-primary-lighten" title="付款类型">type</span>
                                    <span class="badge badge-primary-lighten" title="wxpay/qqpay/alipay">mode</span>
                                    <span class="badge badge-primary-lighten" title="商品下单数据，数组">data</span>
                                    <span class="badge badge-primary-lighten" title="下单数量">num</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                                <div class="mt-1">
                                    <span class="badge badge-dark-lighten" title="付款类型">data[]=下单参数1&data[]=下单参数2&data[]=下单参数3</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="window.open('http://docs.api.ln.cn/')"
                                            class="btn btn-sm btn-light">进入开发文档
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 submit_input" title="Revenue">同系统对接开发文档</h6>
                                <code class="mb-0 mt-0 font-16" id="submit_input">对接较为复杂，不在此处展示，请移步到：<a
                                            href="http://docs.api.ln.cn/" target="_blank">http://docs.api.ln.cn/</a>查看详细文档内容！</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">同系统对接</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                                <div class="mt-1">
                                    <span class="badge badge-warning-lighten" title="开发文档">若有意向对接商城，可查阅开发文档！</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('query_goods','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 query_goods" title="Revenue">
                                    根据商品关键词查询相关商品</h6>
                                <code class="mb-0 mt-0 font-16" id="query_goods"><?= is_https(false) . href() ?>/ajax.php?act=query_goods&name=<?= mb_substr($gid['name'], 0, 2) ?></code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="查询商品相关列表">name</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('OrdersTesting','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 OrdersTesting" title="漏单检测">
                                    <font color="red">易支付漏单检测接口</font>，每次只会检测到易支付前50条支付订单！</h6>
                                <code class="mb-0 mt-0 font-16" id="OrdersTesting"><?= is_https(false) . href() ?>/api.php?act=OrdersTesting</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten">易支付</span>
                                    <span class="badge badge-success-lighten">推荐监控频率：5分钟1次！</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('SharePoster','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 SharePoster" title="商品分享海报">
                                    <font color="#1e90ff">商品分享海报生成</font> 部分商品可能会因为图片原因无法合成海报图！</h6>
                                <code class="mb-0 mt-0 font-16" id="SharePoster"><?= is_https(false) . href() ?>/ajax.php?act=SharePoster&gid=<?= $gid['gid'] ?></code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="商品ID">gid</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card widget-flat shadow-lg">
                            <div class="card-body" style="position: relative;">
                                <div class="float-right">
                                    <button type="button" onclick="test('UserMoneyApi','GET')"
                                            class="btn btn-sm btn-light">测试接口
                                    </button>
                                </div>
                                <h6 class="text-muted text-uppercase mt-0 UserMoneyApi" title="后台加款/扣款api">
                                    后台加款/扣款API接口</h6>
                                <code class="mb-0 mt-0 font-16" id="UserMoneyApi"><?= is_https(false) . href() ?>/api.php?act=UserMoneyApi&token=<?= $conf['secret'] ?>&uid=84&type=1&money=0.01</code>
                                <div class="mt-1">
                                    <span class="badge badge-danger-lighten">GET / POST</span>
                                    <span class="badge badge-primary-lighten" title="金额">money</span>
                                    <span class="badge badge-primary-lighten" title="用户ID">uid</span>
                                    <span class="badge badge-primary-lighten" title="API密钥">token</span>
                                    <span class="badge badge-primary-lighten" title="1充值，2扣款">type</span>
                                    <span class="badge badge-success-lighten">无限制</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "bottom.php"; ?>

<script>
    function test(id, type, data = null) {
        var api = $("#" + id).text();
        var index = layer.msg('接口数据获取中', {icon: 16, time: 999999});
        $.ajax({
            type: type,
            url: api,
            data: data,
            dataType: "json",
            success: function (data) {
                data = JSON.stringify(data, null, "\t");
                layer.alert(' <pre class="layui-code" id="code" lay-encode="true">' + data + '</pre>', {
                        title: $("." + id).text(),
                        anim: 3,
                        area: ['96%', '96%'],
                    }
                );
                layui.code({
                    title: '接口地址：' + api
                    , skin: 'notepad'
                });
            },
            error: function () {
                layer.alert('接口访问失败！');
                layer.close(index);
            }
        });
    }
</script>