<?php
/**
 * 添加可兑换商品
 */
if (empty($_GET['gid'])) {
    $title = '添加商品';
} else {
    $title = '编辑商品-' . $_GET['gid'];
}
include "header.php";

/**
 * 遍历出可对接货源社区！
 * $shequ_arr
 */
$re = $DB->query("SELECT * FROM `sky_shequ` ");
$shequ_arr = [];
while ($res = $DB->fetch($re)) {
    $shequ_arr[] = ['url' => $res['url'], 'id' => $res['id'], 'type' => $res['type']];
}
/**
 * 遍历出可用分类！
 * $cid_arr
 */

$rec = $DB->query("SELECT * FROM `sky_class` ORDER BY `sort` DESC ");
$cid_arr = [];
while ($res = $DB->fetch($rec)) {
    $cid_arr[] = ['cid' => $res['cid'], 'name' => $res['name'], 'state' => $res['state']];
}

/**
 * 遍历出可用运费模板！
 * $freight_tem
 */

$rec = $DB->query("SELECT * FROM `sky_freight` ORDER BY `id` DESC ");
$freight_tem = [];
while ($res = $DB->fetch($rec)) {
    $freight_tem[] = ['id' => $res['id'], 'name' => $res['name'], 'threshold' => $res['threshold']];
}

/**
 * 遍历出可用代理等级！
 * $cid_arr
 */


$rec = $DB->query("SELECT * FROM `sky_price` WHERE `state` = 1 ORDER BY `sort` DESC ");
$mid_arr = [];
while ($res = $DB->fetch($rec)) {
    $mid_arr[] = ['mid' => $res['mid'], 'name' => $res['name'], 'priceis' => $res['priceis'], 'pointsis' => $res['pointsis']];
}

/**
 * 若是修改，则执行数据获取
 */

if (!empty($_QET['gid'])) {
    $data_gid = $DB->get_row("SELECT * FROM `sky_goods` WHERE `gid` = {$_QET['gid']} ");
    if (!$data_gid) show_msg('温馨提示', '商品' . $_QET['gid'] . '不存在！', '2');
    if ($data_gid['method'] == 1) {
        $method = [1, 2, 3, 4, 5, 6, 7];
    } else {
        $method = json_decode($data_gid['method'], true);
    }
} else {
    $method = [1, 2, 3, 4, 5, 6, 7];
    $data_gid = [];
}
?>
<div class="row" id="goods" data-gid="<?= $_QET['gid'] ?>">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header bg-primary text-white font-15">商品对接配置</div>
                            <div class="card-body">
                                <!--对接类型-->
                                <div class="layui-form">
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal" class="text-danger">商品下单数量：</label>
                                        <input type="number" name="quantity"
                                               value="<?= ($data_gid['quantity'] == '' ? '1' : $data_gid['quantity']) ?>"
                                               lay-verify="required" lay-verType="tips"
                                               class="form-control" placeholder="对接货源后请手动调整数量！">
                                    </div>
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">用户下单后执行的操作：</label>
                                        <select name="operation" class="custom-select mt-3" lay-verType="tips"
                                                lay-filter="operation">
                                            <option></option>
                                            <option value="1" <?= $data_gid['sqid'] == '-1' ? 'selected' : '' ?>>无任何操作 / 自营商品
                                            </option>
                                            <option value="2" <?= $data_gid['sqid'] == '-2' ? 'selected' : '' ?>>访问自定义链接 / 支持POST
                                            </option>
                                            <option value="3" <?= $data_gid['sqid'] == '-3' ? 'selected' : '' ?>>自动发送卡密 / 需添加卡密库存
                                            </option>
                                            <option value="4" <?= (int)$data_gid['sqid'] > 1 ? 'selected' : '' ?>>对接到货源社区 / 对接货源
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <!--对接类型end-->

                                <!--CURL对接-->
                                <div style="display: none" id="type_2" class="good_type layui-form">
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">URL链接：</label>
                                        <input type="text" id="CURL_URL" name="CURL_URL"
                                               value="<?= $data_gid['curl'] ?>" lay-verType="tips" class="form-control"
                                               placeholder="请填写url地址,下单成功后自动访问此地址!">
                                    </div>
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">POST数据：</label>
                                        <input type="text" id="CURL_POST" name="CURL_POST"
                                               value="<?= $data_gid['post_data'] ?>" lay-verType="tips"
                                               class="form-control" placeholder="不提交POST留空!格式：?a=123&b=456">
                                    </div>

                                    <div class="card">
                                        <div class="card-header text-primary font-14">填写帮助信息</div>
                                        <div class="card-body p-1">
                                            <pre class="text-left p-1 font-14 shadow-sm"
                                                 style="background-color: whitesmoke;border-radius: 0.5em;">
变量代码：
<a href="#" onclick="goods_add.add_str('CURL_URL','[input1]');return false">[input1]</a>&nbsp;第一个输入框内容
<a href="#" onclick="goods_add.add_str('CURL_URL','[input2]');return false">[input2]</a>&nbsp;第二个输入框内容
<a href="#" onclick="goods_add.add_str('CURL_URL','[input3]');return false">[input3]</a>&nbsp;第三个输入框内容
<a href="#" onclick="goods_add.add_str('CURL_URL','[input4]');return false">[input4]</a>&nbsp;第四个输入框内容
<a href="#" onclick="goods_add.add_str('CURL_URL','[input5]');return false">[input5]</a>&nbsp;第五个输入框内容
<a href="#" onclick="goods_add.add_str('CURL_URL','[num]');return false">[num]</a>&nbsp;下单数量
<a href="#" onclick="goods_add.add_str('CURL_URL','[time]');return false">[time]</a>&nbsp;当前时间戳
<a href="#" onclick="goods_add.add_str('CURL_URL','[date]');return false">[date]</a>&nbsp;当前时间
<a href="#" onclick="goods_add.add_str('CURL_URL','[url]');return false">[url]</a>&nbsp;当前域名
<hr>判断字段: <font color="red">code</font> 或 <font color="red">status</font> 大于等于 0 则判断成功,其他失败
获取回执消息的字段为: <font color="red">msg</font> 或 <font color="red">message</font>
获取返回的余额或金额的字段为：<font color="red">money</font>
回执数据仅支持JSON格式!,详情可咨询接口方开发者
成功例子:
   {'code':1,'msg':'提交成功 success','money':'100'}
   {'status':0,'message':'提交成功 success','money':'100'}
失败例子:
   {'code':-1,'msg':'抱歉,余额不足 error','money':'0'}
   {'status':-2,'message':'抱歉,余额不足 error','money':'0'}</pre>
                                        </div>
                                    </div>
                                </div>
                                <!--CURL对接end-->

                                <!--卡密发送-->
                                <div style="display: none" id="type_3" class="good_type layui-form">
                                    <div class="card">
                                        <div class="card-header text-primary font-14">卡密商品相关帮助</div>
                                        <div class="card-body">
                                            <span class="font-13">1、用户下单后无需手动提卡，可在订单管理界面直接获取自己购买的卡密！</span>
                                            <span class="font-13"><br><br>2、卡密商品用户购买成功后会直接将卡密显示到弹窗上,用户可直接获取,若库存不足,则只会提示下单成功,站长补卡补单后,用户可直接在订单管理列表获取卡密！</span>
                                            <span class="font-13"><br><br>3、卡密商品可被同样使用<code>小储系统</code>的用户对接,对接后显示为对接商品,用户购买商品后,会直接提取你对接的<code>小储系统</code>里面的卡密,并且卡密会加入到你的卡密库存内,用户可直接在提卡界面提取卡密！完美对接小储</span>
                                        </div>
                                    </div>
                                </div>
                                <!--卡密发送end-->

                                <!--对接社区-->
                                <div style="display:none" id="type_4" class="good_type layui-form">
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">可对接社区列表：(<a href="admin.source.add.php"
                                                                                      target="_blank">添加</a>)</label>
                                        <select name="SupplyList" class="custom-select mt-3" lay-verType="tips"
                                                lay-search lay-filter="SupplyList">
                                            <?php
                                            foreach ($shequ_arr as $item) {
                                                switch ($item['type']) {
                                                    case 1:
                                                        $type = '玖伍社区';
                                                        break;
                                                    case 2:
                                                        $type = '亿乐社区';
                                                        break;
                                                    case 3:
                                                        $type = '小储系统';
                                                        break;
                                                    case 4:
                                                        $type = '卡易信';
                                                        break;
                                                }
                                                echo '<option ' . ($data_gid['sqid'] == $item['id'] ? 'selected' : '') . ' value="' . $item['id'] . '_' . $item['type'] . '" >' . $item['url'] . ' [ ' . $type . ' ]</option>';
                                            }
                                            if (count($shequ_arr) == 0) {
                                                echo '<option value="0_0">没有一个可对接社区,快去添加一个吧</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <div class="form-group mb-2 supply_2" style="display: none">
                                        <style>.GoodsCatalogList .layui-form-select {
                                                width: 80%
                                            }</style>
                                        <label for="example-input-normal">卡易信商品目录： <a
                                                    href="javascript:goods_add.SupplyGoodsCatalogList(3)"
                                                    class="text-danger">[余额]</a> <a
                                                    href="javascript:goods_add.SupplyGoodsCatalogList(2)">[获取最新]</a>
                                            <span id="kayix_catalog" style="display: none"></span></label>
                                        <div class="input-group GoodsCatalogList" style="width: 100%;">
                                            <select name="GoodsCatalogList" class="custom-select mt-2" lay-search
                                                    lay-filter="GoodsCatalogList">
                                                <option></option>
                                            </select>

                                            <div class="input-group-append" style="width: 20%;text-align: center;">
                                                <span class="input-group-text"
                                                      style="cursor: pointer;background-color: #f47e49;color: white;width: 100%;height: 100%;display: block;line-height: 200%"
                                                      onclick="goods_add.SupplyGoodsCatalogList()">获取</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2">
                                        <style>.GoodsList .layui-form-select {
                                                width: 80%
                                            }</style>
                                        <label for="example-input-normal">对接商品列表：<span id="kayix_goods_catalog"
                                                                                       style="display: none"></span></label>
                                        <div class="input-group GoodsList" style="width: 100%;">
                                            <select name="GoodsList" class="custom-select mt-2" style="" lay-search
                                                    lay-filter="GoodsList">
                                                <?php
                                                if (!empty($_QET['gid'])) {
                                                    echo '<option value="' . $data_gid['goods_id'] . '_' . $data_gid['goods_type'] . '">' . $data_gid['name'] . '</option>';
                                                } else {
                                                    echo '<option></option>';
                                                }
                                                ?>
                                            </select>

                                            <div class="input-group-append" style="width: 20%;">
                                                <span class="input-group-text"
                                                      style="cursor: pointer;background-color: #bcf42f;color: white;width: 100%;height: 100%;display: block;line-height: 200%"
                                                      onclick="goods_add.SupplyGoodsList()">获取</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">货源商品ID：</label>
                                        <input type="text" name="GoodsId" value="<?= $data_gid['goods_id'] ?>"
                                               lay-verType="tips" class="form-control" placeholder="对接货源商品ID">
                                    </div>

                                    <div class="form-group mb-2 supply_1" style="display: none">
                                        <label for="example-input-normal">货源分类ID：</label>
                                        <input type="text" name="GoodsType" value="<?= $data_gid['goods_type'] ?>"
                                               lay-verType="tips" class="form-control" placeholder="玖伍货源分类ID">
                                    </div>

                                    <div class="form-group mb-2 supply_3" style="display: none">
                                        <label for="example-input-normal">卡易信下单链接：</label>
                                        <input type="text" name="GoodsUrl" value="<?= $data_gid['goods_url'] ?>"
                                               lay-verType="tips" class="form-control" placeholder="卡易信商品购买链接,获取后勿动">
                                    </div>

                                    <div class="form-group mb-2 supply_4" style="display: none">
                                        <label for="example-input-normal">KEY参数(mainKey)：</label>
                                        <input type="text" name="GoodsMainKey" value="<?= $data_gid['goods_mainKey'] ?>"
                                               lay-verType="tips" class="form-control" placeholder="勿动就行了,一般为0">
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">货源对接参数：</label>
                                        <input type="text" name="GoodsArguments"
                                               value="<?= $data_gid['submit_the_field'] ?>" lay-verType="tips"
                                               class="form-control" placeholder="对接货源提交参数">
                                    </div>

                                    <div class="card" id="details" style="display:none ">
                                        <div class="card-header text-primary font-14">对接商品信息</div>
                                        <div class="card-body">
                                            商品名称：<span class="goods_name"></span><br>
                                            商品图片：<span class="goods_image"></span><br>
                                            商品单价：<span class="goods_price" style="color: red"></span><br>
                                            最低下单：<span class="goods_min"></span><br>
                                            最多下单：<span class="goods_max"></span><br>
                                            商品链接：<a class="goods_url" href="" target="_blank">打开下单地址</a><br>
                                            商品说明：<span class="goods_content"></span>
                                        </div>
                                    </div>

                                </div>
                                <!--对接社区end-->
                            </div>
                        </div>

                    </div> <!-- end col -->

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header bg-success text-white font-15">商品参数配置</div>
                            <div class="card-body">
                                <div class="layui-form">
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">商品分类(<a
                                                    href="admin.class.add.php" target="_blank">添加</a>)</label>
                                        <select lay-verify="required" class="custom-select mt-3" lay-verType="tips"
                                                lay-search name="cid">
                                            <?php
                                            $CIDS = $DB->get_row("SELECT * FROM `sky_class` WHERE `cid` = '{$data_gid['cid']}' ");
                                            echo $data_gid['cid'] == null ? '<option></option>' : '<option value="' . $CIDS['cid'] . '">' . $CIDS['name'] . '[当前选择]</option>';
                                            foreach ($cid_arr as $v) {
                                                $state = $v['state'] == 1 ? '显示中' : '已掩藏';
                                                if ($data_gid['cid'] != $v['cid']) {
                                                    echo '<option value="' . $v['cid'] . '">' . $v['name'] . '[' . $state . ']</option>';
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">运费模板(<a
                                                    href="admin.goods.express.php" target="_blank">添加</a>)</label>
                                        <select class="custom-select mt-3" name="freight">
                                            <option value="-1" <?= $data_gid['freight'] == -1 ? 'selected' : null ?>>不使用运费模板
                                            </option>
                                            <?php
                                            foreach ($freight_tem as $v) {
                                                echo '<option value="' . $v['id'] . '" ' . ($data_gid['freight'] == $v['id'] ? 'selected' : '') . ' >' . $v['name'] . ' | 购买价高于' . $v['threshold'] . '免运费</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">商品状态</label>
                                        <select class="custom-select mt-3" name="state">
                                            <option value="1" <?= $data_gid['state'] == 1 ? 'selected' : null ?>>上架中
                                            </option>
                                            <option value="2" <?= $data_gid['state'] == 2 ? 'selected' : null ?>>已下架
                                            </option>
                                        </select>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">商品名称：</label>
                                        <input type="text" name="name" value="<?= $data_gid['name'] ?>"
                                               lay-verify="required" lay-verType="tips"
                                               class="form-control" placeholder="请填写商品名称,对接社区可自动获取">
                                    </div>

                                    <div class="form-group mb-2" id="money"
                                         data-cost="<?= $data_gid['money'] / $data_gid['quantity'] ?>"
                                         data-arr='<?= json_encode($mid_arr) ?>'>
                                        <label for="example-input-normal">商品成本：<a
                                                    href="javascript:layer.alert('1、商品售价计算规则：<br>售价是根据你自定义的用户等级利润 加上 商品成本来计算的，如商品成本100元，游客等级利润为30%，则游客看到的商品售价为130元，以此类推！<hr>Ps：如果不想按照用户等级来设定利润，可以在下方填写利润比例哦~',{title:'商品售价计算规则说明'})">说明</a></label>
                                        <div class="input-group">
                                            <input type="number" name="money" lay-verify="required"
                                                   value="<?= $data_gid['money'] ?>"
                                                   lay-verType="tips"
                                                   class="form-control" placeholder="非对接商品请手动填写">
                                            <div class="input-group-append">
                                                <a href="javascript:layer.alert($('input[name=money]').attr('data-text'),{title:'商品等级售价列表',area: ['auto', '96%'],title:false,btn:false,shade: [0.3],shadeClose:true});"
                                                   class="input-group-text"
                                                   style="cursor: pointer;background: linear-gradient(to right, #8e2de2, #4a00e0);color: white">V1
                                                    / 游客 <span
                                                            id="tourists">0</span>元</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">利润比例 <font color="red">(填0商品售价=成本)</font>：<a
                                                    href="javascript:layer.alert('1、填写规则：<br>100 = 100%，50 = 50%，150 = 150% 以此类推！<br>2、此处的利润百分比解释：<br>此处是用于调整个别商品需要在等级利润的基础上调高或者调低而设置的！<br>如：你的商品成本 = 100元<br>游客等级利润为30%，售价等于 130元<br>但是你想要将这个商品的价格调低点，可以在这里编辑利润比例！<br>如在此处填写50，则游客所看到的商品价格为：115元，利润的50%！<br>如果填写150，则游客所看到的商品价格为：145元，利润的150%，以此类推！',{title:'利润比例说明'})">说明</a></label>
                                        <input type="number" name="profits"
                                               value="<?= ($data_gid['profits'] == '' ? 100 : $data_gid['profits']) ?>"
                                               lay-verify="required" lay-verType="tips"
                                               class="form-control" placeholder="默认获得100%利润,可以自定义">
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">下单输入框： </label>
                                        <div class="input-group">
                                            <input type="text" name="input" id="input" lay-verify="required"
                                                   value="<?= $data_gid['value'] ?>"
                                                   lay-verType="tips"
                                                   class="form-control" placeholder="输入框之间请用|隔开,不限制输入框数量">
                                            <div class="input-group-append">
                                                <a href="javascript:goods_add.alert()" class="input-group-text"
                                                   style="cursor: pointer;background-color: #f4c040;color: white">填写帮助</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="goods_sum" <?= !in_array(7, $method) ? 'style="display: none"' : '' ?>>
                                        <div class="form-group mb-2">
                                            <label for="example-input-normal">下单数量限制(关闭购买多份不限制)： </label>
                                            <div class="input-group">
                                                <input type="number" name="min"
                                                       value="<?= $data_gid['min'] ?>"
                                                       lay-verType="tips"
                                                       class="form-control" placeholder="最小下单数量限制">
                                                <div class="input-group-append" style="width: 50%">
                                                    <input type="number" name="max"
                                                           value="<?= $data_gid['max'] ?>"
                                                           lay-verType="tips"
                                                           class="form-control" placeholder="最大下单数量限制">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">商品图片：</label>
                                        <div class="input-group">
                                            <input type="text" name="image" lay-verType="tips"
                                                   class="form-control" id="image"
                                                   value="<?= $_QET['gid'] == '' ? '/assets/img/sc.jpg' : $data_gid['image'] ?>"
                                                   placeholder="赠送商品的图片"/>
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="upload"
                                                      style="cursor: pointer">上传</span>
                                            </div>
                                            <div class="input-group-append">
                                                <span class="input-group-text"
                                                      onclick="layer.alert('<img src=\''+$('#image').val()+'\' style=width:100%  />')"
                                                      style="cursor: pointer;background-color: #fc6879;color: white">预览</span>
                                            </div>
                                            <div class="input-group-append">
                                                <a href="http://cdn.vue8.cn/s/pieoksig"
                                                   target="_blank" class="input-group-text"
                                                   style="cursor: pointer;background-color: #9393f4;color: white">图库</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">商品详情图：(点击图片可删除)</label>
                                        <div class="input-group">
                                            <div class="Picture"
                                                 data-img="<?= $data_gid['picture'] ?>">
                                            </div>
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="upload_Picture"
                                                      style="cursor: pointer">上传一张详情图</span>
                                            </div>
                                            <div class="input-group-append">
                                                <span class="input-group-text"
                                                      onclick="goods_add.QuicklyEditProductPictures()"
                                                      style="cursor: pointer;margin-left: 1em">快速编辑</span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">每日商品库存：</label>
                                        <input type="number"
                                               value="<?= $data_gid['quota'] == '' ? '100' : $data_gid['quota'] ?>"
                                               lay-verify="required" name="quota" lay-verType="tips"
                                               class="form-control" placeholder="每日商品库存,售完即止！">
                                    </div>

                                    <div class="form-group mb-2">
                                        <label for="example-input-normal">扩展参数</label>
                                        <div class="">
                                            <?php
                                            $met = 0;
                                            $method_name = ['允许在线购买', '允许余额购买', '允许被兑换', '允许被对接', '启用商品价格监控', '允许被克隆', '允许购买多份'];
                                            foreach ($method_name as $v) {
                                                ?>
                                                <input type="checkbox" name="method[]"
                                                       lay-skin="primary" value="<?= ($met + 1) ?>" lay-filter="ckeck"
                                                       title="<?= $method_name[$met] ?>"
                                                       <?= in_array(($met + 1), $method) ? ' checked=""' : null ?>>
                                                <?php $met++;
                                            } ?>
                                        </div>
                                    </div>

                                    <div class="form-group mb-2" style="">
                                        <label for="example-input-normal">弹窗提示：</label>
                                        <input type="text" name="alert"
                                               class="form-control" value="<?= $data_gid['alert'] ?>"
                                               placeholder="留空则不显示弹窗！">
                                    </div>

                                    <div class="form-group mb-2" style="">
                                        <label for="example-input-normal" style="position: relative;bottom: 0;left: 0">下单说明</label>
                                        <textarea class="form-control" name="docs" id="content"
                                                  lay-verType="tips" rows="6"
                                                  placeholder="请输入商品下单提示"><?= $data_gid['docs'] ?></textarea>
                                    </div>
                                    <button type="submit" lay-submit lay-filter="submit"
                                            class="btn btn-block btn-xs btn-success">保存商品数据
                                    </button>

                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- end row -->
            </div> <!-- end card-body-->
        </div> <!-- end card -->
    </div> <!-- end col -->
</div>
<!-- end row -->

<div class="rightbar-overlay"></div>
<style>
    .Picture {
        width: 100%;
        border-radius: 0.3em;
        margin-bottom: 0.5em;
        padding: 0.5em;
    }

    .Picture img {
        margin: 0.3em;
        box-shadow: 3px 3px 16px #eee;
        border-radius: 0.5em;
        width: 50px;
        height: 50px;
    }

    .level {
        text-align: center;
        margin-bottom: 1.5em;
        box-shadow: 3px 3px 16px 2px #e5e8eb;
        overflow: hidden;
        border-radius: 0.5em;
        max-width: 300px;
    }
</style>
<?php include "bottom.php"; ?>
<link href="<?= $cdnpublic ?>summernote/0.8.12/summernote.css" rel="stylesheet">
<script src="<?= $cdnpublic ?>summernote/0.8.12/summernote.min.js"></script>
<script src="<?= $cdnpublic ?>summernote/0.8.12/lang/summernote-zh-CN.min.js"></script>
<script>
    $(document).ready(function () {
        $('#content').summernote({
            lang: 'zh-CN',
            placeholder: '请输入下单说明！',
            minHeight:200,
            callbacks: {
                onImageUpload: function (files, editor, $editable) {
                    UploadFiles(files, 'content');
                }
            },
        });
        function UploadFiles(files,id){
            var imageData = new FormData();
            $.each( files, function( key, val ) {
                imageData.append("imageData"+key, val);
            });
            $.ajax({
                data:imageData,
                type: "POST",
                url: "ajax.php?act=image_content",
                cache: false,
                contentType: false,
                processData: false,
                success: function(imageUrl) {
                    if(imageUrl.code==1){
                        var content = '';
                        $.each( imageUrl['SrcArr'], function( key, val ) {
                            $('#'+id).summernote('editor.insertImage',val['src']);
                            content += '图片：<font color=red>'+val['name']+'</font>大小为：<font color=red>'+val['size']+'</font><br>';
                        });
                        layer.alert(content + '<hr>Ps:图片可一次上传多张！',{title:imageUrl.msg});
                    }else layer.msg(imageUrl.msg);
                },
                error: function() {
                    layer.msg('图片上传接口异常，上传失败！');
                }
            })
        }
    });

    var goods_add = {
        operation: function () { //对接类型
            return $("select[name='operation']").val();
        },
        supply: function () { //返回对接社区ID,类型
            var supply = $("select[name='SupplyList']").val();
            return (supply).split('_');
        },
        GoodsCatalogList: function () { //返回卡易信商品目录
            var GoodsCatalogList = $("select[name='GoodsCatalogList']").val();
            return (GoodsCatalogList).split('_');
        },
        GoodsList: function () { //获取商品详细信息
            var GoodsList = $("select[name='GoodsList']").val();
            return (GoodsList).split('_');
        },
        LayerReloads: function (str) { //重载layui form 全部
            layui.use('form', function () {
                var form = layui.form;
                if (str == '') {
                    form.render();
                } else {
                    form.render(str);
                }
            });
        },
        TypeShow: function (type) { //根据操作类型显示对应界面
            $(".good_type").hide(300);
            $("#type_" + type).show(300);
            switch (type) {
                case '1': //自营

                    break;
                case '2': //CURL

                    break;
                case '3': //卡密

                    break;
                case '4': //对接

                    break;
            }
        },
        alert: function () { //商品填写帮助
            layer.open({
                title: '下单信息填写帮助',
                btn: '关闭',
                area: ['auto', '90%'],
                content: '输入框填写规则：<br>每个输入框之间用符号 | 分割，如：<br><font color=red>下单QQ|QQ密码</font><br>多选框填写规范如下：<br><font color=red>选择框1{可选项1,可选项2}</font><br>混合输入框如下：<br><font color=red>下单QQ|所在大区{湖北一区,北京二区}|下单密码 </font><hr>带功能的输入框字段：<br>QQ空间类：<a href="javascript:goods_add.add_str(\'input\',\'下单QQ|说说ID\')">下单QQ|说说ID</a><br>' +
                    '快手商品类：<a href="javascript:goods_add.add_str(\'input\',\'作品链接|作品ID\')">作品链接|作品ID</a><br>实物商品类：<a href="javascript:goods_add.add_str(\'input\',\'收货姓名|联系电话|收货地址\')">收货姓名|联系电话|收货地址</a><br>抖音视频类：<a href="javascript:goods_add.add_str(\'input\',\'抖音ＩＤ\')">抖音ＩＤ</a>|<a href="javascript:goods_add.add_str(\'input\',\'抖音视频ＩＤ\')">抖音视频ＩＤ</a>|<a href="javascript:goods_add.add_str(\'input\',\'抖音ID\')">抖音ID</a><br>火山视频类：<a href="javascript:goods_add.add_str(\'input\',\'火山ＩＤ\')">火山ＩＤ</a>|<a href="javascript:goods_add.add_str(\'input\',\'火山视频ID\')">火山视频ID</a><br>' +
                    '微视商品类：<a href="javascript:goods_add.add_str(\'input\',\'微视ＩＤ\')">微视ＩＤ</a>|<a href="javascript:goods_add.add_str(\'input\',\'微视作品ID\')">微视作品ID</a><br>' +
                    '今日头条商品类：<a href="javascript:goods_add.add_str(\'input\',\'头条ID\')">头条ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'头条ＩＤ\')">头条ＩＤ</a><br>' +
                    '小红书/皮皮虾商品类：<a href="javascript:goods_add.add_str(\'input\',\'小红书ID\')">小红书ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'皮皮虾ID\')">皮皮虾ID</a><br>' +
                    '美拍商品类：<a href="javascript:goods_add.add_str(\'input\',\'美拍ID\')">美拍ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'美拍ＩＤ\')">美拍ＩＤ</a><br>' +
                    '哔哩哔哩商品类：<a href="javascript:goods_add.add_str(\'input\',\'哔哩哔哩ID\')">哔哩哔哩ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'哔哩视频ID\')">哔哩视频ID</a><br>' +
                    '最右商品类：<a href="javascript:goods_add.add_str(\'input\',\'最右帖子ID\')">最右帖子ID</a><br>' +
                    '全民K歌商品类：<a href="javascript:goods_add.add_str(\'input\',\'全民K歌ID\')">全民K歌ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'全民ID\')">全民ID</a><br>' +
                    '美图秀秀商品类：<a href="javascript:goods_add.add_str(\'input\',\'美图作品ID\')">美图作品ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'美图视频ID\')">美图视频ID</a><br>' +
                    '绿洲商品类：<a href="javascript:goods_add.add_str(\'input\',\'绿洲作品ID\')">绿洲作品ID</a>|<a href="javascript:goods_add.add_str(\'input\',\'绿洲视频ID\')">绿洲视频ID</a><br>'
            })
        },
        add_str: function (id, str) { //快速填写
            if (id == 'CURL_URL') {
                if ($("#CURL_POST").val() != '') {
                    $("#CURL_POST").val($("#CURL_POST").val() + str);
                } else {
                    $("#" + id).val($("#" + id).val() + str);
                }
                return false;
            }
            $("#" + id).val(str);
        },
        TypeSupply: function (type) { //根据社区类型,显示不同内容
            $(".supply_1,.supply_2,.supply_3,.supply_4").hide(100);
            switch (type) {
                case '1': //玖伍
                    $(".supply_1").show(300);
                    break;
                case '2': //亿乐

                    break;
                case '3': //小储

                    break;
                case '4': //卡易信
                    $(".supply_2,.supply_3,.supply_4").show(300);
                    break;
            }
        },
        SupplyGoodsCatalogList: function (cache = 1) { //获取卡易信目录
            if (goods_add.operation() != '4') {
                layer.msg('请先选择操作类型为对接货源社区！', {icon: 2});
                return false;
            }
            var supply = goods_add.supply();
            if (cache == 1) {
                var index = layer.msg('卡易信商品目录获取中...', {icon: 16, time: 999999});
            } else if (cache == 2) {
                var index = layer.msg('最新的卡易信商品目录获取中...<br>Ps：会进行一次登陆操作哦,并且获取会慢一些', {icon: 16, time: 999999});
            } else {
                var index = layer.msg('当前所选卡易信货源余额查询中,请稍后...', {icon: 16, time: 999999});
            }
            $.post('ajax.php?act=product_list', {cache: cache, id: supply[0], type: supply[1]}, function (res) {
                layer.close();
                if (res.code > 0) {
                    if (cache == 3) {
                        layer.alert(res.msg, {icon: 1, title: '查询成功'});
                        return false;
                    }
                    $("#kayix_catalog").hide();
                    layer.alert(res.msg + '<br>数据更新时间:' + res.date, {icon: 1, title: '恭喜'});
                    goods_add.GoodsCatalogListAnalysis(res.data, supply[1]);
                } else {
                    layer.alert(res.msg, {icon: 2, title: '温馨提示'});
                }
            })
        },
        SupplyGoodsList: function (page = 1, cache = 1) { //获取商品列表
            if (goods_add.operation() != '4') {
                layer.msg('请先选择操作类型为对接货源社区！', {icon: 2});
                return false;
            }
            var supply = goods_add.supply();
            if (supply[0] == '') {
                layer.msg('请先选择一个对接货源！', {icon: 2});
                return false;
            }
            switch (supply[1]) {
                case '1': //玖伍
                case '2': //亿乐
                case '3': //小储
                    var index = layer.msg('商品列表获取中...', {icon: 16, time: 999999});
                    $.post('ajax.php?act=product_list', {id: supply[0], type: supply[1]}, function (res) {
                        layer.close(index);
                        if (res.code > 0) {
                            layer.alert(res.msg + '共' + res.data.length + '个商品', {icon: 1, title: '恭喜'});
                            goods_add.GoodsListAnalysis(res.data, supply[1], page);
                        } else {
                            layer.alert(res.msg, {icon: 2, title: '温馨提示'});
                        }
                    })
                    break;
                case '4': //卡易信
                    var GoodsCatalogList = goods_add.GoodsCatalogList();
                    if (GoodsCatalogList[0] == '') {
                        layer.msg('请先选择一个卡易信的商品目录！', {icon: 2});
                        return false;
                    }
                    if (cache == 1) {
                        var index = layer.msg('商品列表获取中...', {icon: 16, time: 999999});
                    } else {
                        var index = layer.msg('最新的商品列表获取中...<br>Ps：会进行一次登陆操作哦,并且获取会慢一些', {icon: 16, time: 999999});
                    }

                    $.post('ajax.php?act=product_list', {
                        cache: cache,
                        page: page,
                        id: supply[0],
                        type: supply[1],
                        dirId: GoodsCatalogList[0],
                        kayixtype: 2
                    }, function (res) {
                        layer.close(index);
                        if (res.code > 0) {
                            layer.alert(res.msg + '<br>数据更新时间:' + res.date, {icon: 1, title: '恭喜'});
                        } else {
                            layer.alert(res.msg, {icon: 2, title: '温馨提示'});
                            res.data = [];
                        }
                        goods_add.GoodsListAnalysis(res.data, supply[1], page);
                    });
                    break;
            }
        },
        GoodsCatalogListAnalysis: function (arr, type) { //解析卡易信商品目录,显示
            var content = '<option></option>'; //初始化
            for (var a = 0; a < arr.length; a++) {
                content += '<option value="' + arr[a]['id'] + '_' + arr[a]['url'] + '">' + arr[a]['name'] + '</option>';
            }
            $("select[name='GoodsCatalogList']").html(content);
            goods_add.LayerReloads('select');
        },
        GoodsListAnalysis: function (arr, type, page) { //解析商品列表,显示
            console.log(page)
            var content = '<option></option>'; //初始化
            switch (type) {
                case '1': //玖伍
                case '2': //亿乐
                case '3': //小储
                    for (var a = 0; a < arr.length; a++) {
                        content += '<option value="' + arr[a]['gid'] + '_' + arr[a][(type == '3' ? 'cid' : 'type')] + '">' + arr[a][(type == '3' ? 'name' : 'title')] + (type == '3' ? ' | 成本:' + (arr[a]['price']) + '元' : '') + '</option>';
                    }
                    break;
                case '4': //卡易信
                    for (var a = 0; a < arr.length; a++) {
                        content += '<option value="' + arr[a]['url'] + '">' + arr[a]['name'] + ' | 售价:' + arr[a]['money'] + '</option>';
                    }

                    if (arr.length == 25) { //开启下一页
                        if (page > 1) {
                            $("#kayix_goods_catalog").html('<a href="javascript:goods_add.SupplyGoodsList(1,2)" >[获取最新]</a>  <a href="javascript:goods_add.SupplyGoodsList(' + (page - 1) + ')">[上一页]</a>  <a href="javascript:goods_add.SupplyGoodsList(' + (page + 1) + ')">[下一页]</a>');
                            $("#kayix_goods_catalog").show(100);
                        } else {
                            $("#kayix_goods_catalog").html('<a href="javascript:goods_add.SupplyGoodsList(1,2)" >[获取最新]</a>  <a href="javascript:goods_add.SupplyGoodsList(' + (page + 1) + ')">[下一页]</a>');
                            $("#kayix_goods_catalog").show(100);
                        }
                    } else if (page != 1 && (page != '' || page != undefined)) {
                        $("#kayix_goods_catalog").html('<a href="javascript:goods_add.SupplyGoodsList(1,2)" >[获取最新]</a>  <a href="javascript:goods_add.SupplyGoodsList(' + (page - 1) + ')">[上一页]</a>');
                        $("#kayix_goods_catalog").show(100);
                    }

                    break;
            }
            $("select[name='GoodsList']").html(content);
            goods_add.LayerReloads('select');
        },
        GoodsDetailed: function (sid, gid, typs = '') { //获取商品详细信息
            var index = layer.msg('商品详情获取中...', {icon: 16, time: 999999});
            $.post('ajax.php?act=Goods_in_detail', {id: sid, gid: gid, typs: typs}, function (res) {
                layer.close(index);
                if (res.code > 0) {
                    var supply = goods_add.supply();
                    goods_add.GoodsDetailedTeam(res.data, supply[1]);
                } else {
                    layer.alert(res.msg, {icon: 2, title: '温馨提示'});
                }
            })
        },
        GoodsDetailedTeam: function (data, type) { //渲染商品
            $("input[name='quantity']").val(data['min']);
            this.PriceList(data.price * data.min);
            $("input[name='GoodsId']").val(data['gid']);
            var input = ''; //下单信息;
            var GoodsArguments = ''; //商品参数;
            switch (type) {
                case '1': //玖伍
                    GoodsArguments = data.pipei;
                    if (data.inputs.length >= 1) {
                        var uina = data.inputs[0];
                        for (let a = 1; a < data.inputs.length; a++) {
                            uina += '|' + data.inputs[a];
                        }
                        input = uina;
                    } else {
                        input = '';
                    }
                    $("input[name='GoodsType']").val(data['goods_type']);
                    goods_add.GoodsDetailedTeamRendering(data, 1);
                    break;
                case '2': //亿乐
                    if (data.inputs.length >= 1) {
                        var am = data.inputs[0];
                        var postpe = am[2];
                        var uina = am[0];
                        for (let a = 1; a < data.inputs.length; a++) {
                            var am = data.inputs[a];
                            var postpe = postpe + '|' + am[2];
                            uina += '|' + am[0];
                        }
                        var input = uina;
                    } else {
                        var postpe = '';
                        var input = '';
                    }
                    input = input;
                    GoodsArguments = postpe;
                    goods_add.GoodsDetailedTeamRendering(data, 2);
                    break;
                case '3': //小储
                    GoodsArguments = data.pipei;
                    if (data.inputs.length >= 1) {
                        var uina = data.inputs[0];
                        for (let a = 1; a < data.inputs.length; a++) {
                            uina += '|' + data.inputs[a];
                        }
                        input = uina;
                    } else {
                        input = '';
                    }

                    $("input[name='quantity']").val(data['quantity']);
                    this.PriceList(data.price * data.quantity);
                    goods_add.GoodsDetailedTeamRendering(data, 3);
                    break;
                case '4': //卡易信
                    GoodsArguments = data.pipei;
                    if (data.inputs.length >= 1) {
                        var uina = data.inputs[0];
                        for (let a = 1; a < data.inputs.length; a++) {
                            uina += '|' + data.inputs[a];
                        }
                        input = uina;
                    } else {
                        input = '';
                    }
                    $("input[name='GoodsType']").val(data['goods_type']);
                    goods_add.GoodsDetailedTeamRendering(data, 4);
                    break;
            }
            $("input[name='input']").val(input);
            $("input[name='GoodsArguments']").val(GoodsArguments);
        },
        GoodsDetailedTeamRendering: function (data, type) { //根据商品数据渲染

            $("#details").show();
            $("#details .goods_name").html(data.name);
            $("#details .goods_price").html((data.price).toFixed(2) + '元1个');
            $("#details .goods_price").attr('data-price', data.price);
            $("#details .goods_min").html(data.min + '个(' + (data.price * data.min).toFixed(2) + '元)');
            $("#details .goods_min").attr('data-m', data.min);
            $("#details .goods_max").html((data.max == 0 ? '不限制' : data.max + '个(' + (data.price * data.max).toFixed(2) + '元)'));
            $("#details .goods_max").attr('data-m', (data.max == 0 ? 10000000000 : data.max));
            $("#details .goods_url").attr('href', data.url);

            $("input[name='name']").val(data.name);
            $("input[name='name']").attr('data-name', data.name);
            $("input[name='money']").val(data.price * data.min); //商品成本
            $("input[name='min']").val(data.min);
            $("input[name='max']").val(data.max);
            switch (type) {
                case 1: //玖伍
                case 2: //亿乐
                case 3: //小储
                    //需添加等级！
                    if (data['level'] != undefined && data['level_arr'] != undefined) {

                        if (data['level_arr'].length == 0) {
                            return false;
                        }
                        var contents = ''; //初始化
                        count = 1;//初始化
                        opacity = 0.7; //初始化
                        $.each(data['level_arr'], function (key, val) {
                            if (count == 1) {
                                tips = '<span style="float: right;margin-right: 1em;">当前' + val.price + '元</span>';
                            } else {
                                tips = '<span style="float: right;margin-right: 1em;">' + val.price + '元</span>';
                            }
                            contents += '<div class="layui-row layui-col-space8 level" style="opacity: ' + opacity + '">' +
                                '<div class="layui-col-xs12 font-14" style="background: linear-gradient(to right,#8e2de2, #4a00e0);color:white;text-align: left;text-indent: 1em">' + val['name'] + tips + '</div>' +
                                '</div>';
                            ++count;
                            opacity = opacity + 0.035;
                        });
                        $("#details .goods_price").attr('data-content', contents);
                        $("#details .goods_price").html(data.price + '元1个 | ' + data['level'] + ' <a href="javascript:goods_add.XiaochuyunMsg()">查看</a>');
                    }
                    if (data['alert'] != undefined) {
                        $("input[name='alert']").val(data.alert);
                    }
                    if (data['picture'] != undefined) {
                        $(".Picture").attr('data-img', data['picture']);
                        goods_add.RenderProductPictures();
                    }

                    $("#details .goods_image").html('<img src="' + data.image + '" height="30" />');
                    $("input[name='image']").val(data.image);
                    $("#details .goods_content").html(data.content);
                    $("textarea[name='docs']").val(data.content);
                    break;
                case 4: //卡易信
                    if (data.content == '' || data.content == ' ') {
                        data.content = '<font color=red>' + data.name + '</font>';
                    }

                    $("#details .goods_content").html(data.content);
                    $("textarea[name='docs']").val(data.content);
                    layer.alert(data.content)

                    $("input[name='GoodsMainKey']").val(data.mainKey);
                    $("input[name='GoodsUrl']").val(data.url);
                    $("#details .goods_image").html('卡易信无图片');
                    break;
            }
            this.RefreshDocs(data.content);
        },
        RefreshDocs: function (docs = '') {
            //content
            $('#content').summernote('code',docs);
        },
        XiaochuyunMsg: function () {
            layer.alert($("#details .goods_price").attr('data-content'), {
                title: '您可获得的密价级别表',
                btn: false,
                shade: [0.3],
                shadeClose: true
            })
        },
        Monitoring: function () { //成本+数量监控,此限制只在对接社区时出现！
            $("input[name='quantity']").bind("input propertychange", function (event) {
                if (goods_add.operation() != '4') { //非社区对接跳过
                    return false;
                }
                goods_add.PriceList();
                var a = $("input[name='quantity']").val();
                var b = $("#details .goods_price").attr('data-price');
                var c = $("#details .goods_min").attr('data-m');
                var d = $("#details .goods_max").attr('data-m');
                if (a == undefined || b == undefined || c == undefined || d == undefined) return false;

                a = parseInt(a);
                b = parseInt(b);
                c = parseInt(c);
                d = parseInt(d);

                if (a < c) {
                    layer.msg('低于最低下单数量限制!' + c + '个', {icon: 2});
                    return false;
                }
                if (a > d) {
                    $("input[name='quantity']").val(d);
                    layer.msg('高于最高下单数量限制!' + d + '个', {icon: 2});
                }
                if (c != '') {
                    var e = a % c;
                    if (e != 0) {
                        layer.msg('下单数量必须是最低下单数量的倍数！', {icon: 2});
                        return false;
                    } else {
                        layer.msg('下单数量检测正常！', {icon: 1});
                    }
                }

                var name = $("input[name='name']").attr('data-name');

                var a = $("input[name='quantity']").val() - 0;
                var b = $("#details .goods_price").attr('data-price') - 0;
                var e = a * b;

                goods_add.PriceList(e);
                $("input[name='name']").val(name);
                $("input[name='money']").val(e);
            });
        },
        GoodsSubmit: function (data) { //提交保存商品数据
            var index = layer.msg('商品数据保存中,请稍后...', {icon: 16, time: 999999});
            $.post('ajax.php?act=Save_the_content', data, function (res) {
                layer.close(index);
                if (res.code >= 1) {
                    layer.alert(res.msg, {
                        btn: ['继续', '返回列表'],
                        btn1: function (layero, index) {
                            location.reload();
                        },
                        btn2: function (layero, index) {
                            location.href = 'admin.goods.list.php'
                        }
                    });
                } else {
                    layer.alert(res.msg);
                }
            })
        },
        GoodsSubmitVerify: function (data) { //验证下单参数
            var quantity = $("input[name='quantity']").val() - 0; //下单数量
            /**
             * 验证区
             */
            if (quantity == '') {
                layer.msg('请将下单数量填写完整！', {icon: 2});
                return false;
            }
            if (data['cid'] == '') {
                layer.msg('请选择一个商品分类！', {icon: 2});
                return false;
            }

            var operation = goods_add.operation(); //对接类型

            switch (operation) {
                case '1': //自营
                    data['SupplyId'] = '-1';
                    break;
                case '2': //CURL
                    data['SupplyId'] = '-2';
                    var CURL_URL = $("input[name='CURL_URL']").val();
                    var CURL_POST = $("input[name='CURL_POST']").val();
                    if (CURL_URL == '') {
                        layer.msg('请将URL链接填写完整哦！', {icon: 2});
                        return false;
                    }
                    data['CURL_URL'] = CURL_URL; //加入链接
                    data['CURL_POST'] = CURL_POST; //加入POST数据
                    break;
                case '3': //卡密
                    data['SupplyId'] = '-3';
                    var input = data['input'].split('|');
                    if (input[0] != '提卡密码') {
                        var state = 1;
                        layer.alert('卡密商品推荐第一个输入框填写：提卡密码<br>用户下单时会有提卡提示<br>并且卡密商品默认第一个输入框为提卡密码！<br>点击下方按钮选择是否填写吧', {
                            icon: 3,
                            title: '温馨提示',
                            btn: ['帮我填写', '自己去填写', '跳过'],
                            btn1: function (layero, index) {
                                $("input[name='input']").val('提卡密码|' + data['input']);
                                state = 2;
                                layer.msg('填写成功！', {icon: 1});
                            },
                            btn2: function (layero, index) {
                                state = 2;
                            }
                        });
                        if (state != 1) {
                            return false;
                        }
                    }
                    break;
                case '4': //对接社区
                    var supply = goods_add.supply();
                    if (supply[0] == '') {
                        layer.msg('请选择要对接的社区！', {icon: 2});
                        return false;
                    }

                    data['SupplyId'] = supply[0]; //社区ID加入
                    data['SupplyType'] = supply[1]; //社区类型加入

                    var GoodsArguments = $("input[name='GoodsArguments']").val(); //对接参数
                    var GoodsId = $("input[name='GoodsId']").val(); //对接商品编号
                    var GoodsList = goods_add.GoodsList();

                    if (GoodsList[0] == '') {
                        layer.msg('请先获取一遍对接商品参数！', {icon: 2});
                        return false;
                    }

                    if (GoodsArguments == '') {
                        layer.msg('请填写完整商品对接参数！', {icon: 2});
                        return false;
                    }
                    if (GoodsId == '') {
                        layer.msg('请填写完整对接商品编号！', {icon: 2});
                        return false;
                    }

                    data['GoodsArguments'] = GoodsArguments; //加入货源商品分类
                    data['GoodsId'] = GoodsId; //加入对接商品ID

                    switch (supply[1]) {
                        case '1': //玖伍
                            var GoodsType = $("input[name='GoodsType']").val(); //对接商品编号
                            if (GoodsType == '') {
                                layer.msg('请填写完整玖伍货源的货源分类ID！', {icon: 2});
                                return false;
                            }
                            data['GoodsType'] = GoodsType; //加入货源商品分类
                            break;
                        case '2': //亿乐

                            break;
                        case '3': //小储

                            break;
                        case '4': //卡易信
                            data['GoodsUrl'] = $("input[name='GoodsUrl']").val();
                            data['GoodsMainKey'] = $("input[name='GoodsMainKey']").val();
                            break;
                    }
                    break;
                default:
                    layer.alert('请选择正确的对接类型！', {icon: 3});
                    break;
            }
            /**
             * 公共加入参数
             */
            data['quantity'] = quantity; //数量加入
            data['operation'] = operation; //商品类型加入

            return data;
        },
        Initialize: function () { //界面初始化
            this.PriceList();
            var Gid = $("#goods").attr('data-gid');
            if (Gid == '') {
                return false;
            } else { //开始初始化修改商品界面！
                var operation = goods_add.operation();
                $("#details").hide();
                var supply = goods_add.supply();
                goods_add.LayerReloads();
                goods_add.TypeSupply(supply[1]);
                goods_add.TypeShow(operation);
                goods_add.RenderProductPictures();
            }
        },
        RenderProductPictures: function () { //商品图渲染
            var image = $(".Picture").attr('data-img');
            if (image == '') {
                $(".Picture").text('留空默认显示商品图片');
            } else {
                arr = image.split('|');
                content = '';
                $.each(arr, function (key, val) {
                    content += '<img src="' + val + '" onclick="goods_add.DeletePicture(' + key + ')" />';
                });
                $(".Picture").html(content)
            }
        },
        AddImages: function (image) { //插入商品图片
            var images = $(".Picture").attr('data-img');
            if (images == '') {
                $(".Picture").attr('data-img', image);
            } else {
                $(".Picture").attr('data-img', images + '|' + image);
            }
            goods_add.RenderProductPictures();
        },
        DeletePicture: function (id) { //删除图片
            var images = $(".Picture").attr('data-img');
            if (images == '') {
                layer.msg('啥都没有删什么？');
                return false;
            } else {
                layer.open({
                    title: '操作确认',
                    content: '是否要删除第' + ((id - 0) + 1) + '张商品详情图？',
                    btn: ['取消', '确认删除'],
                    icon: 3,
                    btn2: function (layero, index) {
                        arr = images.split('|');
                        arr.splice(id, 1);
                        $(".Picture").attr('data-img', arr.join('|'));
                        goods_add.RenderProductPictures();
                        layer.close();
                    }
                });
            }
        },
        QuicklyEditProductPictures: function () {
            var images = $(".Picture").attr('data-img');
            var content = images.split('|');
            var content = content.join("\n");
            layer.prompt({
                formType: 2,
                value: content,
                title: '一行一张图片',
                maxlength: 99999999999,
                area: ['350px', '350px'] //自定义文本域宽高
            }, function (value, index, elem) {
                var content = value.split("\n");
                var content = content.join('|');
                $(".Picture").attr('data-img', content);
                goods_add.RenderProductPictures();
                layer.close(index);
            });
        },
        PriceList: function (cost = -1, profits = -1) { //根据成本渲染价格列表!
            arrays = JSON.parse($("#money").attr('data-arr'));
            console.log(arrays)
            arr_json = JSON.parse($("#money").attr('data-arr')).reverse();
            console.log(arr_json[0])




            if (arr_json.length == 0) return false;
            if (cost == -1) {
                cost = $("input[name='money']").val() - 0;
                if ($("#money").attr('data-cost') != 'NAN') {
                    var costs = $("#money").attr('data-cost') - 0;
                    var quantity = $('input[name="quantity"]').val() - 0
                    cost = costs * quantity;
                    $("input[name='money']").val(cost);
                }
            } else {
                cost = cost - 0;
            }


            if (profits == -1) {
                profits = $("input[name='profits']").val() - 0;
            } else {
                profits = profits - 0;
            }

            var content = ''; //初始化
            count = 1;//初始化
            opacity = 0.7; //初始化
            $.each(arr_json, function (key, val) {
                priceis = (val['priceis']-0) * (profits == 0 ? 0 : (profits / 100));
                pointsis = (val['pointsis']-0) * (profits == 0 ? 1 : (profits / 100));
                tips = '<span style="float: right;margin-right: 1em;">V' + count + '级</span>';
                content += '<div class="layui-row layui-col-space8 level" style="opacity: ' + opacity + '">' +
                    '<div class="layui-col-xs12 font-14" style="background: linear-gradient(to right,#8e2de2, #4a00e0);color:white;text-align: left;text-indent: 1em">' + val['name'] + '| ' + ((priceis / 100) * cost).toFixed(2) + '元 /' + priceis.toFixed(2) + '%利润' + tips + '</div>' +
                    '<div class="layui-col-xs6 text-success ">金额：' + (cost + ((priceis / 100) * cost)).toFixed(2) + '元</div>' +
                    '<div class="layui-col-xs6 text-danger ">兑换：' + (cost * (pointsis - 0)).toFixed(0) + '点</div>' +
                    '</div>';
                ++count;
                opacity = opacity + 0.035;
            });

            arr_json[(arr_json.length) - 1]['priceis'] = arr_json[0]['priceis'] * (profits / 100);
            content += '<p style="text-align: center" class="layui-text">小储云加盟系统 <a href="admin.level.list.php" target="_blank">[管理]</a></p>';
            $("input[name='money']").attr('data-text', content);
            $("#tourists").text((cost + ((arr_json[(arr_json.length) - 1]['priceis'] / 100) * cost)).toFixed(2));
        }
    };

    layui.use('form', function () {
        var form = layui.form;

        form.on('select(operation)', function (data) { //商品下单后执行类型
            $("#details,#kayix_goods_catalog").hide();
            goods_add.TypeShow(data.value);
        });

        form.on('select(SupplyList)', function (data) { //根据社区类型,显示不同内容
            var supply = goods_add.supply();
            $("select[name='GoodsList']").html('');
            $("#details,#kayix_goods_catalog").hide();
            goods_add.LayerReloads('select');
            goods_add.TypeSupply(supply[1]);
        });

        form.on('select(GoodsCatalogList)', function (data) { //卡易信目录列表
            $("#kayix_goods_catalog").hide();
            var supply = goods_add.supply();
            $("select[name='GoodsList']").html('');
            var GoodsCatalogList = goods_add.GoodsCatalogList();
            if (GoodsCatalogList[0] == '') {
                $("#kayix_catalog").html('');
                return false;
            }
            layer.msg('请点击下方的获取按钮获目录[' + GoodsCatalogList[0] + ']商品!')
            $("#kayix_catalog,#kayix_goods_catalog").show(100);
            $("#kayix_goods_catalog").html('<a href="javascript:goods_add.SupplyGoodsList(1,2)" >[获取最新]</a>');
            $("#kayix_catalog").html('<a href="' + GoodsCatalogList[1] + '" target="_blank">[打开目录]</a>');
        });

        form.on('select(GoodsList)', function (data) { //获取商品详细数据
            if (data.value == '') return false;
            $("#details").hide();
            var GoodsList = goods_add.GoodsList();
            var supply = goods_add.supply();
            goods_add.GoodsDetailed(supply[0], GoodsList[0], GoodsList[1]);
        });

        form.on('checkbox(ckeck)', function (data) {
            switch (data.value) {
                case '7':
                    if (data.elem.checked == true) { //开启
                        $("#goods_sum").show(200);
                    } else {
                        $("#goods_sum").hide(200);
                    }
                    break;
            }
        });

        form.on('submit(submit)', function (data) { //提交保存商品参数
            var data = data.field;
            var data = goods_add.GoodsSubmitVerify(data); //转换验证
            if (data == false) {
                return false;
            }

            var Gid = $("#goods").attr('data-gid');
            if (Gid != '') {
                data['Gid'] = Gid;
            }
            data['docs']  = $('#content').summernote('code');
            data['Picture'] = $(".Picture").attr('data-img');
            goods_add.GoodsSubmit(data);
            return false;
        });
        layui.use(['upload', 'form'], function () {
            var upload = layui.upload;
            var uploadInst = upload.render({
                elem: '#upload' //绑定元素
                , url: 'ajax.php?act=image_up' //上传接口
                , acceptMime: 'image/*'
                , accept: 'images'
                , done: function (res, index, upload) {
                    layer.msg(res.msg);
                    $("input[name='image']").val(res.src);
                }
                , error: function () {
                    layer.msg('图片上传失败!')
                }
            });
        });

        layui.use(['upload', 'form'], function () {
            var upload = layui.upload;
            var uploadInst = upload.render({
                elem: '#upload_Picture' //绑定元素
                , url: 'ajax.php?act=image_up' //上传接口
                , acceptMime: 'image/*'
                , accept: 'images'
                , done: function (res, index, upload) {
                    layer.msg(res.msg);
                    //插入图片
                    goods_add.AddImages(res.src);
                }
                , error: function () {
                    layer.msg('图片上传失败!')
                }
            });
        });
    });

    $("input[name='money']").bind("input propertychange", function (event) { //监控商品成本计算！
        goods_add.PriceList($("input[name='money']").val());
    });
    $("input[name='profits']").bind("input propertychange", function (event) { //监控商品成本计算！
        var prof = $("input[name='profits']").val() - 0;
        if (prof == '') prof = 0;
        goods_add.PriceList(-1, prof);
        layer.msg('保留利润比例为：' + prof + '%');
    });

    goods_add.Monitoring(); //初始化成本计算

    goods_add.Initialize(); //初始化商品显示

</script>
</body>
</html>
