<?php
/**
 * 订单列表
 */
$title = '订单列表';
include "header.php";
$sum = 16; #每页数量
$page = shop::page($sum, $_QET['page']); #取出翻页数据
$shop_list = shop::order_list($sum, $page['count'], $page['limit'], $_QET['val'], $_QET['sqid'], $_QET['uid'], $_QET['gid'], $_QET['state']); #获取订单列表
$paging = shop::paging($shop_list['count'], $_QET['page']); #取出翻页按钮数据
?>
<!-- third party css -->
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/dataTables.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<link href="<?= $cdnserver == null ? '../' : $cdnserver ?>assets/css/vendor/responsive.bootstrap4.css" rel="stylesheet"
      type="text/css"/>
<!-- third party css end -->
<!-- App css -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-sm-12">
                        <?php
                        if (!empty($_QET['val'])) {
                            echo '
                            <a href="admin.order.list.php" class="btn btn-success">
                               内容【' . $_QET['val'] . '】相关订单如下/查看全部
                            </a>';
                        } elseif (!empty($_QET['sqid'])) {
                            echo '
                            <a href="admin.source.list.php" class="btn btn-success">
                               返回货源管理
                            </a>';
                        } elseif (!empty($_QET['uid'])) {
                            echo '
                            <a href="admin.user.list.php" class="btn btn-success">
                                用户【' . $_QET['uid'] . '】相关订单如下/查看全部
                            </a>';
                        } elseif (!empty($_QET['gid'])) {
                            echo '
                            <a href="admin.goods.list.php" class="btn btn-success">
                               返回商品管理
                            </a>';
                        }
                        ?>
                        <span class="btn btn-primary" onclick="batch.query()"> 查找订单 </span>
                        <span class="btn btn-group p-0">
                            <select class="custom-select" name="batch_state" style="width: 16em">
                                <option value="">批量修改订单状态(需选中)</option>
                                <option value="1">修改为已完成</option>
                                <option value="2">修改为待处理</option>
                                <option value="3">修改为异常</option>
                                <option value="4">修改为处理中</option>
                                <option value="5">批量补单(非已完成/对接类订单)</option>
                            </select>
                        </span>
                        <span class="btn btn-group p-0">
                            <select class="custom-select" name="order_state" style="width: 16em">
                                <option value="0"
                                        <?= $_QET['state'] == 0 ? 'selected' : '' ?>>查看全部订单(<?= $DB->count("SELECT count(*) FROM `sky_order` ") ?>条)</option>
                                <option value="1"
                                        <?= $_QET['state'] == 1 ? 'selected' : '' ?>>查看已完成订单(<?= $DB->count("SELECT count(*) FROM `sky_order` WHERE state = 1 ") ?>条)</option>
                                <option value="2"
                                        <?= $_QET['state'] == 2 ? 'selected' : '' ?>>查看待处理(<?= $DB->count("SELECT count(*) FROM `sky_order` WHERE state = 2 ") ?>条)</option>
                                <option value="3"
                                        <?= $_QET['state'] == 3 ? 'selected' : '' ?>>查看异常订单(<?= $DB->count("SELECT count(*) FROM `sky_order` WHERE state = 3 ") ?>条)</option>
                                <option value="4"
                                        <?= $_QET['state'] == 4 ? 'selected' : '' ?>>查看处理中订单(<?= $DB->count("SELECT count(*) FROM `sky_order` WHERE state = 4 ") ?>条)</option>
                                <option value="5"
                                        <?= $_QET['state'] == 5 ? 'selected' : '' ?>>查看已退款订单(<?= $DB->count("SELECT count(*) FROM `sky_order` WHERE state = 5 ") ?>条)</option>
                        </select>
                        </span>
                        <span class="btn btn-danger" onclick="window.open('admin.order.list_log.php')"> 查看简化界面 </span>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-centered table-striped dt-responsive nowrap w-100"
                           id="products-datatable">
                        <thead>
                        <tr style="white-space: nowrap">
                            <th>
                                <input name="checkbox_all" id="list_all" type="checkbox" onclick="batch.select_all()"
                                       value="true">
                                ID(全选)
                            </th>
                            <th>UID</th>
                            <th>详情</th>
                            <th>付款方式</th>
                            <th>金额</th>
                            <th>成本</th>
                            <th>份数</th>
                            <th>下单信息</th>
                            <th>对接信息</th>
                            <th>修改时间</th>
                            <th>下单时间</th>
                            <th>对接类型</th>
                            <th>状态</th>
                            <th>对接余额</th>
                            <th>快捷操作订单</th>
                        </tr>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($shop_list['data'] as $v) {
                            ?>
                            <tr style="white-space: nowrap;font-size: 0.9em">
                                <td>
                                    <input type="checkbox" name="checkbox[]" class="list_box box_<?= $v['id'] ?>"
                                           onclick="batch.select_id(<?= $v['id'] ?>)" value="<?= $v['id'] ?>"/>
                                    <a class="badge badge-info-lighten" id="r<?= $v['id'] ?>"
                                       title="备注：<?= $v['remark'] ?>" data-txt="<?= $v['remark'] ?>"
                                       href="javascript:batch.remark(<?= $v['id'] ?>)">
                                        <?= $v['id'] ?>/备注
                                    </a>
                                </td>
                                <td>
                                    <a href="admin.order.list.php?uid=<?= $v['uid'] ?>"
                                       class="badge badge-dark-lighten">
                                        <?= $v['uid'] ?>号
                                    </a>
                                </td>
                                <td>
                                    <a href="javascript:batch.details(<?= $v['id'] ?>);" title="<?= $v['name'] ?>">
                                        <?= mb_strlen($v['name'], 'utf-8') > 4 ? mb_substr($v['name'], 0, 4, 'utf-8') . '...' : $v['name']; ?>
                                    </a>
                                </td>
                                <td>
                                    <?php
                                    switch ($v['payment']) {
                                        case 'alipay':
                                            echo '<div class="badge badge-info-lighten">支付宝</div>';
                                            break;
                                        case 'wxpay':
                                            echo '<div class="badge badge-success-lighten">微信付款</div>';
                                            break;
                                        case 'qqpay':
                                            echo '<div class="badge badge-primary-lighten">QQ付款</div>';
                                            break;
                                        default:
                                            echo '<div class="badge badge-light">' . $v['payment'] . '</div>';
                                            break;
                                    } ?>
                                </td>
                                <td style="color: #eb00ff">
                                    <?= round($v['price'], 3) ?><?= $v['payment'] == '积分兑换' ? $conf['currency'] : '元' ?>
                                </td>
                                <td>
                                <span class="text-danger" title="每单所扣掉的成本">
                                    <?= round($v['money'], 3) ?>元
                                </span>
                                </td>
                                <td>
                                    <?= $v['num'] ?>份
                                </td>
                                <td>
                                    <?= $v['input'] ?><a id="<?= $v['id'] ?>" data-input='<?= $v['inputs'] ?>'
                                                         style="color:red"
                                                         href="javascript:batch.set_order(<?= $v['id'] ?>)">[编辑]</a>
                                </td>
                                <td>
                                    <a href="javascript:layer.alert('<?= $v['return'] ?>',{title:'对接返回信息'})"
                                       style="color: #ff8839">
                                        <?= mb_strlen($v['return'], 'utf-8') > 4 ? mb_substr($v['return'], 0, 4, 'utf-8') . '...' : $v['return']; ?>
                                    </a>
                                </td>
                                <td>
                                    <?= $v['finishtime'][0] . '<br>' . $v['finishtime'][1] ?>
                                </td>
                                <td>
                                    <?= $v['addtitm'][0] . '<br>' . $v['addtitm'][1] ?>
                                </td>
                                <td>
                                    <?= $v['sqid'] ?>
                                </td>
                                <td style="cursor: pointer">
                                    <?= $v['state'] ?>
                                </td>
                                <td>
                                    <span class="badge badge-<?= ($v['state2'] == 1 ? 'primary' : 'danger') ?>-lighten">
                                        <?= ($v['state2'] == 1 ? (round($v['user_rmb'], 3) . '元') : '无法查看') ?>
                                    </span>
                                </td>
                                <td id="money_<?= $v['id'] ?>" data-money="<?= $v['price'] ?>">
                                    <select class="custom-select" data-id="<?= $v['id'] ?>" name="state">
                                        <option value="1" <?= $v['state2'] == 1 ? ' selected ' : '' ?>>已完成</option>
                                        <option value="2" <?= $v['state2'] == 2 ? ' selected ' : '' ?>>待处理</option>
                                        <option value="3" <?= $v['state2'] == 3 ? ' selected ' : '' ?>>异常</option>
                                        <option value="4" <?= $v['state2'] == 4 ? ' selected ' : '' ?>>处理中</option>
                                        <option value="5" <?= $v['state2'] == 5 ? ' selected ' : '' ?>>已退单(订单退款)
                                        </option>
                                        <option value="6">删除订单</option>
                                    </select>
                                </td>
                            </tr>
                            <?php
                        } ?>
                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination pagination-rounded" style="overflow: auto">
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=1<?= !empty($_QET['val']) ? '&val=' . $_QET['val'] : '' ?><?= !empty($_QET['sqid']) ? '&sqid=' . $_QET['sqid'] : '' ?><?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['state']) ? '&state=' . $_QET['state'] : '' ?>"
                               aria-label="Previous">
                                <span aria-hidden="true">«</span>
                                <span class="sr-only">Previous</span>
                            </a>
                        </li>
                        <?php foreach ($paging as $v) { ?>
                            <li class="page-item <?= $v['active'] ?>"><a class="page-link"
                                                                         href="?page=<?= $v['number'] ?><?= !empty($_QET['val']) ? '&val=' . $_QET['val'] : '' ?><?= !empty($_QET['sqid']) ? '&sqid=' . $_QET['sqid'] : '' ?><?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['state']) ? '&state=' . $_QET['state'] : '' ?>"><?= $v['number'] ?></a>
                            </li>
                        <?php } ?>
                        <li class="page-item">
                            <a class="page-link"
                               href="?page=<?= $shop_list['count'] ?><?= !empty($_QET['val']) ? '&val=' . $_QET['val'] : '' ?><?= !empty($_QET['sqid']) ? '&sqid=' . $_QET['sqid'] : '' ?><?= !empty($_QET['uid']) ? '&uid=' . $_QET['uid'] : '' ?><?= !empty($_QET['gid']) ? '&gid=' . $_QET['gid'] : '' ?><?= !empty($_QET['state']) ? '&state=' . $_QET['state'] : '' ?>"
                               aria-label="Next">
                                <span aria-hidden="true">»</span>
                                <span class="sr-only">Next</span>
                            </a>
                        </li>
                        <?php if (!empty($_QET['val']) || !empty($_QET['sqid']) || !empty($_QET['uid']) || !empty($_QET['gid']) || !empty($_QET['state'])) { ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=1" aria-label="Nexst">
                                    <span aria-hidden="true">查看全部</span>
                                    <span class="sr-only">Nexst</span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </nav>
            </div> <!-- end card-body-->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div>


<?php include "bottom.php"; ?>
<script>
    $("select[name='order_state']").change(function () {
        location.href = '?state=' + $(this).children('option:selected').val();
    });
    var batch = {
        select_id: function (id) {
            if ($('.box_' + id).prop('checked') == true) {
                $('.box_' + id).attr("checked", true);
                $('.box_' + id).prop("checked", true);
            } else {
                $('.box_' + id + ',#list_all').attr('checked', false);
                $('.box_' + id + ',#list_all').prop("checked", false);
            }
        },
        select_all: function () {
            if ($('#list_all').prop('checked') == true) {
                $(".list_box,#list_all").attr("checked", true);
                $(".list_box,#list_all").prop("checked", true);
            } else {
                $(".list_box,#list_all").attr('checked', false);
                $(".list_box,#list_all").prop("checked", false);
            }
        },
        pitch_on: function () {
            var amount = new Array();
            $("input[type='checkbox']").each(function () {
                if ($(this).is(":checked")) {
                    if ($(this).val() != 'true' && $(this).val() != '') amount.push($(this).val());
                }
            });
            return amount;
        },
        ajax_state: function (id, did, money = 0) {
            var index = layer.msg('修改中', {icon: 16, time: 9999999});
            $.ajax({
                type: "post",
                url: "ajax.php?act=ChangeOrders",
                data: {id: id, did: did, money: money},
                dataType: "json",
                success: function (data) {
                    if (data.code > 0) {
                        layer.alert(data.msg, {
                            icon: 1, end: function (layero, index) {
                                location.reload();
                            }
                        });
                    } else {
                        layer.msg(data.msg, {icon: 2});
                    }
                },
                error: function () {
                    layer.alert('修改失败！');
                    layer.close(index);
                }
            });
        },
        order_dispose: function (id, type = 1, arr = null, i) {
            var index = layer.msg('订单' + id + '补单中...', {icon: 16, time: 9999999});
            if (id == '' || id == undefined) return;
            $.ajax({
                type: "post",
                url: "ajax.php?act=replenishment",
                data: {id: id},
                dataType: "json",
                success: function (data) {
                    if (type != 1) {
                        batch.order_all(arr, ++i);
                        layer.alert('订单：' + id + '补单状态：<br>' + data.msg, {
                            anim: Math.ceil(Math.random() * 6),
                            shade: 0.5,
                            title: '批量补单！'
                        });
                        console.log(data)
                        return;
                    }
                    if (data.code > 0) {
                        layer.alert(data.msg, {
                            icon: 1, end: function (layero, index) {
                                location.reload();
                            }
                        });
                    } else {
                        layer.msg(data.msg, {icon: 2});
                    }
                },
                error: function () {
                    layer.alert('修改失败！');
                    layer.close(index);
                }
            });
        },
        details: function (id) {
            var index = layer.msg('订单查询中...', {icon: 16, time: 9999999});
            $.ajax({
                type: "post",
                url: "ajax.php?act=order_details",
                data: {id: id},
                dataType: "json",
                success: function (data) {
                    console.log(data);
                    layer.close(index);
                    if (data.code == 1) {
                        var content = '<div style="overflow:auto;max-height: 80vh">';
                        $.each(data.data, function (index, item) {
                            if (index == '') {
                                content += item;
                            } else {
                                if (item != null && item != '' && item != undefined) {
                                    content += '<font color=' + '#' + ('00000' + (Math.random() * 0x1000000 << 0).toString(18)).substr(-6) + '>' + index + '</font> ：' + item + '<br>';
                                }
                            }
                        });
                        content += '</div>';
                        var area = [$(window).width() > 480 ? '480px' : '100%'];
                        layer.open({
                            type: 0,
                            area: area,
                            title: data['name'] + ' 订单详情！',
                            content: content
                        });
                    } else {
                        layer.msg(data.msg);
                    }
                },
                error: function () {
                    layer.alert('查询失败！');
                    layer.close(index);
                }
            });
        },
        remark: function (id) {
            var area = [$(window).width() > 480 ? '480px' : '100%'];
            layer.prompt({
                formType: 2,
                value: $("#r" + id).attr('data-txt'),
                title: '填写物流订单格式：物流单号|xxxxxx，自动识别',
                area: area,
            }, function (value, index, elem) {
                layer.close(index);
                var index = layer.msg('修改中...', {icon: 16, time: 9999999});
                $.ajax({
                    type: "post",
                    url: "ajax.php?act=order_remark",
                    data: {id: id, txt: value},
                    dataType: "json",
                    success: function (data) {
                        if (data.code > 0) {
                            layer.alert(data.msg, {
                                icon: 1, end: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.msg(data.msg, {icon: 2});
                        }
                    },
                    error: function () {
                        layer.alert('修改失败！');
                        layer.close(index);
                    }
                });
            });
        },
        query: function () {
            layer.prompt({
                formType: 0,
                value: '',
                title: '请填写下单信息查询',
            }, function (value, index, elem) {
                location.href = '?val=' + value;
            });
        },
        set_order: function (id) {
            var area = [$(window).width() > 480 ? '480px' : '100%'];
            layer.prompt({
                formType: 2,
                value: $("#" + id).attr('data-input'),
                title: '编辑订单' + id + '原始下单内容！',
                area: area,
            }, function (value, index, elem) {
                layer.close(index);
                var index = layer.msg('修改中...', {icon: 16, time: 9999999});
                $.ajax({
                    type: "post",
                    url: "ajax.php?act=set_order",
                    data: {id: id, input: value},
                    dataType: "json",
                    success: function (data) {
                        if (data.code > 0) {
                            layer.alert(data.msg, {
                                icon: 1, end: function (layero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.msg(data.msg, {icon: 2});
                        }
                    },
                    error: function () {
                        layer.alert('修改失败！');
                        layer.close(index);
                    }
                });
            });
        },
        ajax_state_all: function (type, arr) {
            var index = layer.msg('批量操作中...', {icon: 16, time: 9999999});
            $.ajax({
                type: "post",
                url: "ajax.php?act=set_order_all",
                data: {type: type, arr: arr},
                dataType: "json",
                success: function (data) {
                    if (data.code > 0) {
                        layer.alert(data.msg, {
                            icon: 1, end: function (layero, index) {
                                location.reload();
                            }
                        });
                    } else {
                        layer.msg(data.msg, {icon: 2});
                    }
                },
                error: function () {
                    layer.alert('修改失败！');
                    layer.close(index);
                }
            });
        },
        order_all: function (arr, i = 0) {
            var se = setTimeout(function () {
                if (arr[i] != undefined) {
                    batch.order_dispose(arr[i], 2, arr, i);
                } else {
                    layer.alert(arr.length + '个订单批量补单执行完成<br>点击确定刷新界面哦~', {
                        icon: 1, anim: 5, end: function (layero, index) {
                            location.reload();
                        }
                    });
                }
            }, 1100);
        }
    };
    $("select[name='batch_state']").change(function () {
        var arr = batch.pitch_on();
        if (arr.length == 0) return;
        var type = $(this).children('option:selected').val();

        if (type == '') return;
        switch (type) {
            case '5': //批量补单！
                layer.alert('是否执行此操作？', {
                    title: '订单批量操作确认', icon: 3, btn: ['确认', '取消'], btn1: function (layero, index) {
                        layer.msg('即将开始执行批量补单操作！<br>本次共需执行' + arr.length + '条数据！', {icon: 16, time: 9999999});
                        batch.order_all(arr);
                    }
                })
                break;
            default:
                layer.alert('是否执行此操作？', {
                    title: '订单批量操作确认', icon: 3, btn: ['确认', '取消'], btn1: function (layero, index) {
                        batch.ajax_state_all(type, arr);
                    }
                })
                break;
        }
    })

    $("select[name='state']").change(function () {
        var id = $(this).children('option:selected').val();
        var did = $(this).attr('data-id');
        if (id == 5) {
            var money = $("#money_" + did).attr('data-money');
            console.log(money)
            layer.prompt({
                formType: 3,
                value: money,
                title: '请输入退款金额/<?=$conf['currency']?>',
                btn: ['确定退款', '取消退款'],
            }, function (value, index, elem) {
                batch.ajax_state(id, did, value);
                layer.close(index);
            });
        } else {
            layer.alert('是否执行此操作？', {
                title: '订单状态修改确认', icon: 3, btn: ['确认', '取消'], btn1: function (layero, index) {
                    batch.ajax_state(id, did);
                }
            })
        }
    });
</script>
