//站长后台登陆js
var AdminLogin = {
    do_login_wx: function () {
        layer.open({
            title: '是否要使用QQ互联登陆？',
            content: '登陆后若未创建账号会自动帮您创建哦！',
            btn: ['确认登陆', '取消'],
            icon: 3,
            anim: 6,
            btn1: function (layero, index) {
                location.href = '?act=login';
                layer.msg('正在跳转登陆中...', {icon: 16, time: 8999999})
            },
        });
    },
    do_admin_get_mobile_code() {
        var phone = $("input[name='phone']").val();
        if (phone == '') {
            layer.msg('请先填写手机号', {icon: 2});
            return false;
        }
        var phoneReg = /(^1[3|4|5|6|7|8]\d{9}$)|(^09\d{8}$)/;
        //电话
        if (!phoneReg.test(phone)) {
            layer.msg('请输入有效的手机号码！', {icon: 2});
            return false;
        }
        layer.open({
            title: '是否要发送短信验证码？',
            content: '发送短信验证码成功后会消耗1点短信额度哦~',
            btn: ['确认发送', '取消'],
            icon: 3,
            anim: 6,
            btn1: function (layero, index) {
                layer.msg('正在发送,请稍后', {icon: 16, time: 9999999});
                $.ajax({
                    type: "POST",
                    url: '?act=Send_verification_code_login',
                    data: {mobile: phone},
                    dataType: "json",
                    success: function (data) {
                        if (data.code > 0) {
                            AdminLogin.do_admin_codes(60);
                            layer.alert(data.msg, {icon: 1});
                        } else {
                            layer.alert(data.msg, {icon: 2});
                        }
                    },
                    error: function () {
                        layer.alert('服务器异常！');
                    },
                });
            },
        });
    },
    do_admin_codes(m) {
        $("#PhoneCode").attr('class', 'layui-btn layui-btn-fluid LgoinBtnDe');
        $("#PhoneCode").html('<span id="codes">' + m + '</span>秒后重发');
        $("#PhoneCode").attr('href', 'javascript:layer.msg(\'请填写短信！' + m + '秒后可重新发送！\')');
        var ms = $("#codes").text() - 0;
        if (ms <= 0) {
            $("#PhoneCode").attr('class', 'layui-btn layui-btn-fluid LgoinBtn');
            $("#PhoneCode").html('获取验证码');
            $("#PhoneCode").attr('href', 'javascript:AdminLogin.do_admin_get_mobile_code()');
        } else {
            setTimeout(function () {
                AdminLogin.do_admin_codes(ms - 1);
            }, 1000);
        }
    },
    do_admin_login_phone_verify() {
        var code = $("input[name='vercode']").val();
        layer.open({
            title: '是否确认登陆？',
            content: '若确认验证码填写正确，可点击确定登陆后台！',
            btn: ['确认', '取消'],
            icon: 3,
            anim: 6,
            btn1: function (layero, index) {
                layer.msg('正在验证,请稍后', {icon: 16, time: 9999999});
                $.ajax({
                    type: "POST",
                    url: '?act=Send_verification_login',
                    data: {code: code},
                    dataType: "json",
                    success: function (data) {
                        if (data.code > 0) {
                            layer.alert(data.msg, {
                                icon: 1, title: '恭喜', end: function (lyaero, index) {
                                    location.reload();
                                }
                            });
                        } else {
                            layer.alert(data.msg, {icon: 2});
                        }
                    },
                    error: function () {
                        layer.alert('服务器异常！');
                    },
                });
            },
        });
    },
};