<?php
/**
 * Author：晴天 QQ：1186258278
 * Creation：2020/3/19 20:39
 * Filename：Share.php
 * 公共类
 */

namespace extend;


class Share
{

    /**
     * @param $url
     * @param $cookie
     * @param $post
     * @param int $cookie_fils
     * @return bool|string
     * Curl 携带或获取Cookie数据
     */
    public static function CurlCookieObtain($url, $cookie = 0, $post = 0, $cookie_fils = 0)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HEADER, 0); //是否显示头信息
        $httpheader[] = "Accept: */*";
        $httpheader[] = "Accept-Encoding: gzip,deflate,sdch";
        $httpheader[] = "Accept-Language: zh-CN,zh;q=0.8";
        $httpheader[] = "Connection: close";
        $httpheader[] = "Content-Type: application/x-www-form-urlencoded; charset=UTF-8";
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_POST, 1); //post方式提交
        if ($post) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $httpheader);
        if ($cookie) {
            curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);
        }
        if ($cookie_fils) {
            curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_fils);
        }
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36');
        curl_setopt($ch, CURLOPT_ENCODING, "gzip,deflate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $ret = curl_exec($ch);
        curl_close($ch);
        return $ret;
    }

    /**
     * @param $url
     * @param int $post
     * @param int $cookie
     * @return bool|string
     * 卡易信商品下单提交类
     */
    public static function CurlGoodsPurchased($url, $post = 0, $cookie = 0, $urls = 0)
    {
        $urlsr = explode('/', $urls); //切割url
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $httpheader[] = "Accept: */*";
        $httpheader[] = "Accept-Encoding: gzip, deflate";
        $httpheader[] = "Accept-Language: zh-CN,zh;q=0.9,en;q=0.8";
        $httpheader[] = "Connection: keep-alive";
        $httpheader[] = "Content-Type: application/x-www-form-urlencoded; charset=UTF-8";
        $httpheader[] = "User-Agent: Mozilla/5.0 (Windows NT 10086.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36";
        $httpheader[] = "Referer: " . $urls;
        $httpheader[] = "Host: " . $urlsr[2];
        $httpheader[] = "Origin: " . $urlsr[0] . "//" . $urlsr[2];
        $httpheader[] = "X-Requested-With: XMLHttpRequest";
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_POST, 1); //post方式提交
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post)); //要提交的信息
        curl_setopt($ch, CURLOPT_HTTPHEADER, $httpheader);
        curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie); //读取存储的cookie
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36');
        curl_setopt($ch, CURLOPT_ENCODING, "gzip, deflate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $ret = curl_exec($ch);
        curl_close($ch);
        return $ret;
    }

}