/**
 * 小储云商城
 * 模板视图js调用类 simple
 * @type {{input_data: (function(*, *, *, *): string), data_class: (function(*): string), num: (function(): string), data_goods: (function(*): string)}}
 */
var template = {
    data_class: function (data) { //商品分类模板
        var cid = $("#cid").attr('data-cid');
        var selected = '';
        if ($_GET['cid'] == data.cid) {
            selected = 'selected';
        }
        if (cid == '0') {
            var content = '<option value="0">请选择分类</option><option ' + selected + ' value="' + data.cid + '">' + data.name + ' | ' + data.number + '个商品</option>';
            $("#cid").attr('data-cid', data.cid);
        } else {
            var content = '<option value="' + data.cid + '" ' + selected + ' >' + data.name + ' | ' + data.number + '个商品</option>';
        }
        return content;
    },
    data_goods: function (data) { //商品列表模板
        if (data.quota != 0) {
            var quota = '<br>' + data.quantity + '个';
        } else {
            var quota = '<br><font color=#EF5350>库存不足</font>'
        }
        var selected = '';
        if ($_GET['gid'] == data.gid) {
            selected = 'selected';
        }
        var gid = $("#gid").attr('data-gid');
        if (gid == '0') {
            $("#gid").attr('data-gid', data.cid + '_' + data.gid);
            var content = '<option value="0">请选择商品</option><option value="' + data.cid + '_' + data.gid + '" ' + selected + ' >' + data.name + ' | ' + (data.price - 0) + '元  ' + quota + '</option>';
        } else {
            var content = '<option value="' + data.cid + '_' + data.gid + '" ' + selected + ' >' + data.name + ' | ' + (data.price - 0) + '元  ' + quota + '</option>';
        }
        return content;
    },
    input_data: function (name, placeholder, id, addstr) {//商品输入框模板
        if (addstr != '') {
            var content = '<div class="form-group" id="points_os" style="center;color:#e1b617;font-weight:bold">\n' +
                '                <div class="input-group"><div class="input-group-addon"   id="var_c' + id + '"  >' + name + '</div>\n' +
                '                    <input type="text" class="form-control" onblur="checkInput(\'var_c' + id + '\',\'input_val_' + id + '\')" placeholder="' + placeholder + '"  id="input_val_' + id + '"  />\n' +
                '               <span class="input-group-btn">' + addstr + '</span> ' +
                '</div>\n' +
                '            </div>';
        } else {
            var content = '<div class="form-group" id="points_os" style="center;color:#e1b617;font-weight:bold">\n' +
                '                <div class="input-group"><div class="input-group-addon"   id="var_c' + id + '"  >' + name + '</div>\n' +
                '                    <input type="text" class="form-control" onblur="checkInput(\'var_c' + id + '\',\'input_val_' + id + '\')" placeholder="' + placeholder + '"  id="input_val_' + id + '"  />\n' +
                '                </div>\n' +
                '            </div>';
        }
        return content;
    },
    select_data: function (selectname, addstr, i) { //多选框构建
        var content = '<div class="form-group">\n' +
            '                <div class="input-group"><div class="input-group-addon" id="var_c' + i + '">' + selectname + '</div>\n' +
            '                    <select class="form-control" id="input_val_' + i + '"><option value=""></option>' + addstr + '</select>\n' +
            '                </div>\n' +
            '            </div>';
        return content;
    },
    num: function () { //商品下单数量模板
        var content = '<div class="form-group">\n' +
            '                <div class="input-group">\n' +
            '                    <div class="input-group-addon">下单份数</div>\n' +
            '                    <input id="num" name="num" class="form-control" type="number" min="1" value="1"/>\n' +
            '                </div>\n' +
            '            </div>';
        return content;
    }
    , success: function (data) {
        if (data.data['CarriageTem'] != undefined && data.data['freight'] != "") { //启用运费模板
            if (data.data['freight'] != "-1") {
                CarriageTem.start(data.data['CarriageTem'], data.data['freight'], data.data['price']);
            }
        }

        $("#level").html('<font color="#ff4500">' + data.data.level + '</font>');
        var level_arr = $("#gootsp").attr('data-level_arr');
        if (level_arr == '-1') {
            layer.tips('恭喜！您当前为最高等级密价！', '#level', {tips: [1, '#651FFF']});
            $("#level").attr('onclick', 'layer.msg(\'恭喜！您当前为最高等级密价！\')');
        } else {
            layer.tips('<font color="white">此商品有更多优惠哦！<br>点击查看获取！</font>', '#level', {tips: [3, '#6200EA']});
            $("#level").attr('onclick', 'layer.alert(\'' + unescape(level_arr) + '\',{title:\'密价等级表\',btn:[\'朕已阅\',\'升级密价\'],shade: [0.8, \'#000\'],shadeClose:true,btn2:function(layero,index){window.open(\'/user/grade.php\')}})');
        }
    },
    query_tem: function (data) { //订单模板
        $("#order_all").show(100);
        var content_error = '<div class="layui-card qt-card">\n' +
            '              <div class="layui-card-header">\n' +
            '               <p style="width: 70%" class="layui-elip">没有查询到相关订单</p>\n' +
            '                       </div>\n' +
            '                        <div class="layui-card-body">\n' +
            '                       <div class="layui-row layui-col-space10">\n' +
            '                            <div class="layui-col-xs4" style="text-align: center">\n' +
            '                                <img src="' + logo + '">\n' +
            '                            </div><div class="layui-col-xs8" style="text-align: center">\n' +
            '                                登陆后台可永久保存订单哦<hr><a href="user">进入后台</a>\n' +
            '                            </div>\n' +
            '         </div>\n' +
            '    </div>\n' +
            '</div>';
        if (data.code == 1) {
            var content = ''; //全部订单
            var content_a = ''; //已完成
            var content_b = ''; //待处理
            var content_c = ''; //异常订单
            var content_d = ''; //进行中
            var content_e = ''; //已退款
            $.each(data.data, function (key, val) {

                switch (val['state']) {
                    case '1': //成功
                        var state = '<font color="#43A047">已完成</font>';
                        break;
                    case '2': //待处理
                        var state = '<font color="#651FFF">待处理</font>';
                        break;
                    case '3': //异常
                        var state = '<font color="#FF1744">异常中</font>';
                        break;
                    case '4': //正在处理
                        var state = '<font color="#F57C00">正在处理</font>';
                        break;
                    case '5': //已退款
                        var state = '<font color="#424242">已退款</font>';
                        break;
                    default:
                        var state = '<font color="#607D8B">未知状态</font>';
                        break;
                }

                if (val.payment == '积分付款') {
                    val.price = val.price + '积分';
                } else if (val.payment == '免费领取') {
                    val.price = '<font color="#2e8b57">免费商品</font>';
                } else {
                    val.price = val.price + '元';
                }

                if (val.token !== "0") {
                    msg_token = (val.token).join('<br>');
                    btns = '<button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="layer.alert(\'卡密信息为：<br>' + msg_token + '\',{title:\'您购买的卡密信息\'})">\n' +
                        '                             提取卡密\n' +
                        '                      </button>';
                } else {
                    btns = '';
                }

                if (val.logistics != "-1") { //有快递？当然是查询
                    btne = '<button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="layer.alert(\'快递单号信息：<br>' + val.logistics + '\<hr>查询快递方法：复制快递单号，手机打开菜鸟包裹查询即可！\',{title:\'您的快递单号\'})">\n' +
                        '                             快递单号\n' +
                        '                      </button>';
                } else {
                    btne = '';
                }

                content += content_bf = '<div class="layui-col-xs12 layui-col-sm6"><div class="layui-card qt-card">\n' +
                    '              <div class="layui-card-header">\n' +
                    '               <p style="width: 70%" class="layui-elip">' + val.name + '</p>\n' +
                    '                    <span class="layui-layout-right layui-elip"\n' +
                    '                           style="width:30%;text-align: right;margin-right: 0.5em">\n' +
                    '                          ' + state + '\n' +
                    '                    </span>\n' +
                    '                       </div>\n' +
                    '                        <div class="layui-card-body">\n' +
                    '                       <div class="layui-row layui-col-space10">\n' +
                    '                            <div class="layui-col-xs4">\n' +
                    '                                <img src="' + val.image + '"/>\n' +
                    '                            </div>\n' +
                    '                       <div class="layui-col-xs8"\n' +
                    '                            style="font-size: 0.8em;color:black;font-family: \'微软雅黑\'">\n' +
                    '                            下单时间：' + val.addtitm + '<br>\n' +
                    '                            商品总价：' + val.price + '<br>\n' +
                    '                            购买方式：' + val.payment + '\n' +
                    '                      </div>\n' +
                    '                  <div style="width: 100%;text-align: right;margin-top: 1em">\n' +
                    '                       <button class="layui-btn qt-btn layui-btn-sm layui-btn-primary" onclick="merchandise.query_data(' + val.id + ')">\n' +
                    '                             查看详情\n' +
                    '                      </button>' + btns + btne + '\n' +
                    '               </div>\n' +
                    '         </div>\n' +
                    '    </div>\n' +
                    '</div></div>';

                switch (val['state']) {
                    case '1': //成功
                        content_a += content_bf;
                        break;
                    case '2': //待处理
                        content_b += content_bf;
                        break;
                    case '3': //异常
                        content_c += content_bf;
                        break;
                    case '4': //正在处理
                        content_d += content_bf;
                        break;
                    case '5': //已退款
                        content_e += content_bf;
                        break;
                }


                content_bf = '';
            });

            if (content == '') {
                content = content_error;
            }
            if (content_a == '') {
                content_a = content_error;
            }
            if (content_b == '') {
                content_b = content_error;
            }
            if (content_c == '') {
                content_c = content_error;
            }
            if (content_d == '') {
                content_d = content_error;
            }
            if (content_e == '') {
                content_e = content_error;
            }

            $("#order_all").html(content);
            $("#order_a").html(content_a);
            $("#order_b").html(content_b);
            $("#order_c").html(content_c);
            $("#order_d").html(content_d);
            $("#order_e").html(content_e);
            content = '';
        } else {
            $("#order_all,#order_a,#order_b,#order_c,#order_d,#order_e").html(content_error);
        }
    },
    SharePoster: function (gid) {
        if (gid == undefined) {
            layer.msg('请先选择商品');
            return false;
        }
        layer.msg('正在生成商品分享海报...', {icon: 16, time: 9999999})
        $.ajax({
            type: "post",
            url: "/ajax.php?act=SharePoster",
            data: {gid: gid},
            dataType: "json",
            success: function (data) {
                if (data.code == 1) {
                    layer.alert('<img src="' + data.src + '" width=300 heigth=450 />', {
                        area: ['340px', '490px'],
                        title: false,
                        btn: false, shade: [0.8, '#000'],
                        shadeClose: true,
                    })
                } else {
                    layer.msg(data.msg, {icon: 2});
                }
            },
            error: function () {
                layer.alert('生成失败！');
            }
        });
    },
};

if ($_GET['cid'] == undefined && $_GET['name'] == undefined || $_GET['cid'] == 0) {
    merchandise.cid_data();//调用分类
} else if ($_GET['cid'] != undefined && $_GET['gid'] == undefined && $_GET['cid'] != 0) {
    merchandise.cid_data();//调用分类
    merchandise.gid_data($_GET['cid'], $_GET['name'], 1);
} else if ($_GET['cid'] != undefined && $_GET['gid'] != undefined) {
    /**
     * 调用商品下单界面模块
     */
    merchandise.cid_data();//调用分类
    merchandise.gid_data($_GET['cid'], $_GET['name'], 1);
    merchandise.shop_data($_GET['gid']);
    $('#points').on('click', function () {
        var that = this;
        layer.tips('<font color=#fff>此商品支持积分付款哦,每日限量快来领取吧！</font>', that, {tips: [1, '#000']}); //在元素的事件回调体中，follow直接赋予this即可
    });
}

if ($_GET['name'] != '' && $_GET['name'] != undefined) { //调用搜索
    merchandise.cid_data();//调用分类
    merchandise.gid_data($_GET['cid'], $_GET['name'], 1);
}

$("#cid").change(function () {
    if ($("#cid").val() == 0) {
        location.href = '/';
    } else location.href = '?cid=' + $("#cid").val()
});

$("#gid").change(function () {
    var id = ($("#gid").val()).split('_');
    if (id[0] == 0) {
        location.href = '?cid=' + $_GET['cid'];
    } else location.href = '?cid=' + id[0] + '&gid=' + id[1];
});