<%@ Application Language="C#" %>
<script runat="server">
	void Application_Start(object sender, EventArgs e)
	{
		//在应用程序启动时运行的代码
	}

	void Application_End(object sender, EventArgs e)
	{
		//在应用程序关闭时运行的代码
	}

	void Application_Error(object sender, EventArgs e)
	{
		//在出现未处理的错误时运行的代码
	}

	void Session_Start(object sender, EventArgs e)
	{
		//在新会话启动时运行的代码
	}

	void Session_End(object sender, EventArgs e)
	{
		//在会话结束时运行的代码。
	}

	void Application_BeginRequest(object sender, EventArgs e)
	{
		try
		{
			string session_param_name = "ASPSESSID";
			string session_cookie_name = "ASP.NET_SESSIONID";
			if (HttpContext.Current.Request.Form[session_param_name] != null)
			{
				UpdateCookie(session_cookie_name, HttpContext.Current.Request.Form[session_param_name]);
			}
			else if (HttpContext.Current.Request.QueryString[session_param_name] != null)
			{
				UpdateCookie(session_cookie_name, HttpContext.Current.Request.QueryString[session_param_name]);
			}
		}
		catch (Exception)
		{
			Response.StatusCode = 500;
			Response.Write("Error Initializing Session");
		}
		try
		{
			string auth_param_name = "AUTHID";
			string auth_cookie_name = FormsAuthentication.FormsCookieName;
			if (HttpContext.Current.Request.Form[auth_param_name] != null)
			{
				UpdateCookie(auth_cookie_name, HttpContext.Current.Request.Form[auth_param_name]);
			}
			else if (HttpContext.Current.Request.QueryString[auth_param_name] != null)
			{
				UpdateCookie(auth_cookie_name, HttpContext.Current.Request.QueryString[auth_param_name]);
			}
		}
		catch (Exception)
		{
			Response.StatusCode = 500;
			Response.Write("Error Initializing Forms Authentication");
		}
	}

	void UpdateCookie(string cookie_name, string cookie_value)
	{
		HttpCookie cookie = HttpContext.Current.Request.Cookies.Get(cookie_name);
		if (cookie == null)
		{
			cookie = new HttpCookie(cookie_name);
			HttpContext.Current.Request.Cookies.Add(cookie);
		}
		cookie.Value = cookie_value;
		HttpContext.Current.Request.Cookies.Set(cookie);
	}
</script>