﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="System_TemplateList_TemplateTextEdit, QianboCMS" EnableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>文本编辑模板</title>
    <link rel="stylesheet" href="../Css/layout.css" type="text/css" />
    <script src="../../Js/Common.js" type="text/javascript"></script>
</head>

<body onmousemove="dragmove();" onmouseup="dragclear()" onload="GetLabel($('ddlCategory').value)">
    <form id="form1" runat="server">
        <div>
            <table cellpadding="2" border="0" cellspacing="1" class="border" align="center">
                <tr class="title">
                    <td align="left">文本编辑模板 文件名：<%=FileName%> 路径：<%=ShowPath%></td>
                </tr>
                <tr class="tdbg">
                    <td align="left">
                        <asp:DropDownList ID="ddlCategory" runat="server" onchange="GetLabel(this.value)"></asp:DropDownList>
                        <div id="lbShow"></div>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td>
                        <textarea id="lblContent" style="width: 100%;" rows="25" runat="server" onmouseup="dragend()" onmousemove="movePoint()"></textarea>
					</td>
                </tr>
                <tr class="tdbg">
                    <td>
                        <asp:Button ID="btnSave" runat="server" Text="保存模板" CssClass="btn" OnClick="btnSave_Click" />
                        <asp:Button ID="btnReset" CssClass="btn" runat="server" Text="恢复模板" OnClick="btnReset_Click" />
					</td>
                </tr>
            </table>
        </div>
    </form>
</body>
</html>
<script language="javascript">
    function GetLabel(categoryId) {
        System_TemplateList_TemplateTextEdit.GetLabelList(categoryId, Callback)
    }
    function Callback(result) {
        $('lbShow').innerHTML = "";
        var count = result.value.Rows.length;
        var str = "<table cellpadding='2' cellspacing='0' border='0'><tr>";
        for (var i = 0; i < count; i++) {
            var text = result.value.Rows[i]["Name"];
            str += "<td nowrap>" + FillText(text) + "</td>";
            if (i != 0 && (i + 1) % 7 == 0 && (i + 1) != count) {
                str += "</tr><tr>"
            }
        }
        str += "</tr></table>"
        $('lbShow').innerHTML = str;
    }
    function FillText(val) {
        return "<div onmousedown='DragStart()' onclick='SetValue()' style='cursor: hand; border: solid 1px #9c9c9c; width: 99%; height: 99%; text-align: center;'>" + val + "</div>"
    }
    var labelStr;
    function DragStart() {
        dragclear();
        window.drag = 1;
        dragspan = document.createElement('div');
        dragspan.style.position = "absolute";
        dragspan.className = "tips2";
        var mousePos = mouseCoords(window.event);
        dragspan.style.left = mousePos.x + 10;
        dragspan.style.top = mousePos.y + 8;
        labelStr = window.event.srcElement.innerText;
        dragspan.appendChild(document.createTextNode(window.event.srcElement.innerHTML));
        document.body.appendChild(dragspan);
    }
    function SetValue() {
        document.all.lblContent.focus();
        var tarobj = document.selection.createRange();
        tarobj.text = labelStr;
        if (window.drag) {
            window.drag = 0;
            window.event.returnValue = true;
        }
    }
    function dragend() {
        if (window.drag) {
            document.body.removeChild(dragspan);
            SetValue();
        }
    }
    function mouseCoords(ev) {
        if (ev.pageX || ev.pageY) {
            return {
                x: ev.pageX, y: ev.pageY
            };
        }
        return {
            x: ev.clientX + document.documentElement.scrollLeft - document.body.clientLeft,
            y: ev.clientY + document.documentElement.scrollTop - document.body.clientTop
        };
    }
    function dragclear() {
        if (window.drag) {
            document.body.removeChild(dragspan);
            window.drag = 0;
            window.event.returnValue = true;
        }
    }
    function dragmove() {
        if (window.drag) {
            var ev = ev || window.event;
            var mousePos = mouseCoords(ev);
            ev.returnValue = false;
            dragspan.style.left = mousePos.x + 10;
            dragspan.style.top = mousePos.y + 8;
        }
    }
    function movePoint() {
        if (window.drag) {
            var rng = event.srcElement.createTextRange();
            rng.moveToPoint(event.x, event.y);
            rng.select();
        }
    }
</script>