module.exports = {
  extends: "recommended",
  ignore: ["**/*.raw"],

  // Pending:
  // "eol-last": "always",

  rules: {
    "block-indentation": true,
    "deprecated-render-helper": true,
    "linebreak-style": true,
    "link-rel-noopener": "strict",
    "no-abstract-roles": true,
    "no-args-paths": true,
    "no-attrs-in-components": true,
    "no-debugger": true,
    "no-duplicate-attributes": true,
    "no-extra-mut-helper-argument": true,
    "no-html-comments": true,
    "no-index-component-invocation": true,
    "no-inline-styles": false,
    "no-input-block": true,
    "no-input-tagname": true,
    "no-implicit-this": false,
    "no-invalid-interactive": true,
    "no-invalid-link-text": true,
    "no-invalid-meta": true,
    "no-invalid-role": true,
    "no-log": true,
    "no-negated-condition": true,
    "no-nested-interactive": true,
    "no-multiple-empty-lines": true,
    "no-obsolete-elements": true,
    "no-outlet-outside-routes": true,
    "no-partial": true,
    "no-positive-tabindex": false,
    "no-quoteless-attributes": true,
    "no-shadowed-elements": true,
    "no-trailing-spaces": true,
    "no-triple-curlies": true,
    "no-unbound": true,
    "no-unnecessary-concat": true,
    "no-unnecessary-component-helper": true,
    "no-unused-block-params": true,
    quotes: "double",
    "require-button-type": true,
    "require-iframe-title": true,
    "require-valid-alt-text": false,
    "self-closing-void-elements": true,
    "simple-unless": true,
    "style-concatenation": true,
    "table-groups": true,
    "link-href-attributes": false,
  },
};
