import {
  queryAll,
  exists,
  acceptance,
} from "discourse/tests/helpers/qunit-helpers";
import { visit } from "@ember/test-helpers";
import { test } from "qunit";
import I18n from "I18n";

acceptance("Personal Message", function (needs) {
  needs.user();

  test("footer edit button", async function (assert) {
    await visit("/t/pm-for-testing/12");

    assert.ok(
      !exists(".edit-message"),
      "does not show edit first post button on footer by default"
    );
  });

  test("suggested messages", async function (assert) {
    await visit("/t/pm-for-testing/12");

    assert.equal(
      queryAll("#suggested-topics .suggested-topics-title").text().trim(),
      I18n.t("suggested_topics.pm_title")
    );
  });
});
