import { queryAll, acceptance } from "discourse/tests/helpers/qunit-helpers";
import { visit } from "@ember/test-helpers";
import { test } from "qunit";
import hbs from "htmlbars-inline-precompile";

const CONNECTOR =
  "javascripts/single-test/connectors/user-profile-primary/hello";

acceptance("Plugin Outlet - Single Template", function (needs) {
  needs.hooks.beforeEach(() => {
    Ember.TEMPLATES[
      CONNECTOR
    ] = hbs`<span class='hello-username'>{{model.username}}</span>`;
  });

  needs.hooks.afterEach(() => {
    delete Ember.TEMPLATES[CONNECTOR];
  });

  test("Renders a template into the outlet", async function (assert) {
    await visit("/u/eviltrout");
    assert.ok(
      queryAll(".user-profile-primary-outlet.hello").length === 1,
      "it has class names"
    );
    assert.equal(
      queryAll(".hello-username").text(),
      "eviltrout",
      "it renders into the outlet"
    );
  });
});
