import { test } from "qunit";
import { discourseModule } from "discourse/tests/helpers/qunit-helpers";

discourseModule("Unit | Utility | emoji-emojiStore", function (hooks) {
  hooks.beforeEach(function () {
    this.emojiStore = this.container.lookup("service:emoji-store");
    this.emojiStore.reset();
  });

  hooks.afterEach(function () {
    this.emojiStore.reset();
  });

  test("defaults", function (assert) {
    assert.deepEqual(this.emojiStore.favorites, []);
    assert.equal(this.emojiStore.diversity, 1);
  });

  test("diversity", function (assert) {
    this.emojiStore.diversity = 2;
    assert.equal(this.emojiStore.diversity, 2);
  });

  test("favorites", function (assert) {
    this.emojiStore.favorites = ["smile"];
    assert.deepEqual(this.emojiStore.favorites, ["smile"]);
  });

  test("track", function (assert) {
    this.emojiStore.track("woman:t4");
    assert.deepEqual(this.emojiStore.favorites, ["woman:t4"]);
    this.emojiStore.track("otter");
    this.emojiStore.track(":otter:");
    assert.deepEqual(this.emojiStore.favorites, ["otter", "woman:t4"]);
  });
});
