@name Invalid Element
@category compiler
@shortDescription Unknown HTML element or component

@description
One or more elements cannot be resolved during compilation because the element is not defined by the HTML spec, or there is no component or directive with such element selector.

<div class="alert is-helpful">

This is the compiler equivalent of a common runtime error `NG0304: '${tagName}' is not a known element: …`.

</div>

@debugging
Use the element name in the error to find the file(s) where the element is being used.

Check that the name and selector are correct. If the component is from a different module or import, check that the component is exported from its origin module and imported into the correct `*.modules.ts` file, and declared in the imports list.

When using custom elements or web components, ensure that you add [`CUSTOM_ELEMENTS_SCHEMA`](api/core/CUSTOM_ELEMENTS_SCHEMA) to the app module.

If this does not resolve the error, check the imported libraries for any recent changes to the exports and properties you are using, and restart your server.
