# Content Contributor's Guide

Angular, as an open source project, depends on its community. This dependence is particularly important to the documentation. The more the community contributes to the documentation, the better the documentation becomes, which helps both new and experienced Angular developers.

The topics in this section cover ways in which you can contribute to the Angular documentation set.

## Before you begin

Before you get started with your contributions, we recommend that you review [Contributing to Angular](https://github.com/angular/angular/blob/master/CONTRIBUTING.md). That topic explains many of the tasks and guidelines you need to know before you make your first pull request.

## Contributing to Angular

<div class="card-container">
  <a href="guide/reviewing-content" class="docs-card" title="Reviewing content">
    <section>Review content</section>
    <p>Keep Angular content up-to-date by reviewing topics for accuracy.</p>
    <p class="card-footer">Help keep content up to date</p>
  </a>
  <a href="guide/updating-search-keywords" class="docs-card" title="Updating search keywords">
    <section>Update search keywords</section>
    <p>Help Angular developers by improving the search keywords for existing topics.</p>
    <p class="card-footer">Improve documentation search</p>
  </a>
  <a href="guide/updating-content-github-ui" class="docs-card" title="Updating content through GitHub">
    <section>Update content through GitHub</section>
    <p>Learn how to make documentation changes through the GitHub UI.</p>
    <p class="card-footer">Contribute to Angular in your browser</p>
  </a>
  <a href="guide/docs-style-guide" class="docs-card" title="Documentation Style Guide">
    <section>Documentation style guide</section>
    <p>Review the syntax and styles used within the Angular documentation set.</p>
    <p class="card-footer">Get to know the writing style</p>
  </a>
</div>
