# Example applications

The following is a list of the example applications in the [Angular documentation](docs).

## Fundamentals

These examples demonstrate minimal, fundamental concepts.

### Getting started application

<live-example name="getting-started"></live-example>

Introductory application demonstrating Angular features.
For more information, see [Getting started](start).


### Launching your app

<live-example name="bootstrapping"></live-example>

Demonstrates the Angular bootstrapping process.
For more information, see [Launching your app with a root module](guide/bootstrapping).

### Structure of Angular applications

<live-example name="architecture"></live-example>

Demonstrates the fundamental architecture of Angular applications.
For more information, see [Introduction to Angular concepts](guide/architecture).

### Setting the document title

<live-example name="set-document-title"></live-example>

Demonstrates customizing the document title in the browser.
For more information, see [Set the document title](guide/set-document-title).


## Tour of Heroes tutorial application

The Tour of Heroes is a comprehensive tutorial that guides you through the process of building an application with many of Angular's most popular features.

### Tour of Heroes: completed application

<live-example name="toh-pt6"></live-example>

Completed Tour of Heroes example application.
For more information, see [Tour of Heroes app and tutorial](tutorial).

### Tour of Heroes: Creating an application

<live-example name="toh-pt0"></live-example>

Initial Tour of Heroes example application for beginning the tutorial.
For more information, see [Create a new project](tutorial/toh-pt0).

### Tour of Heroes: The hero editor

<live-example name="toh-pt1"></live-example>

First step of the Tour of Heroes example application.
For more information, see [The hero editor](tutorial/toh-pt1).

### Tour of Heroes: Display a selection list

<live-example name="toh-pt2"></live-example>

Second step of the Tour of Heroes example application.
For more information, see [Display a selection list](tutorial/toh-pt2).

### Tour of Heroes: Create a feature component

<live-example name="toh-pt3"></live-example>

Third step of the Tour of Heroes example application.
For more information, see [Create a feature component](tutorial/toh-pt3).

### Tour of Heroes: Add services

<live-example name="toh-pt4"></live-example>

Fourth step of the Tour of Heroes example application.
For more information, see [Add services](tutorial/toh-pt4).

### Tour of Heroes: Add in-app navigation with routing

<live-example name="toh-pt5"></live-example>

Fifth step of the Tour of Heroes example application.
For more information, see [Add in-app navigation with routing](tutorial/toh-pt5).

### Tour of Heroes: Get data from a server

<live-example name="toh-pt6"></live-example>

Sixth and final step of the Tour of Heroes example application.
For more information, see [Get data from a server](tutorial/toh-pt6).






## Working with templates

These examples demonstrate features of Angular templates.

### Accessibility

<live-example name="accessibility"></live-example>

Demonstrates building Angular applications in a more accessible way.
For more information, see [Accessibility](guide/accessibility).

### Animations

<live-example name="animations"></live-example>

Demonstrates Angular's animation features.
For more information, see [Introduction to Angular animations](guide/animations).

### Attribute, class, and style bindings

<live-example name="attribute-binding"></live-example>

Demonstrates Angular attribute, class, and style bindings.
For more information, see [Attribute, class, and style bindings](guide/attribute-binding).

### Attribute directives

<live-example name="attribute-directives"></live-example>

Demonstrates Angular attribute directives.
For more information, see [Attribute directives](guide/attribute-directives).

### Binding syntax

<live-example name="binding-syntax"></live-example>

Demonstrates Angular's binding syntax.
For more information, see [Binding syntax: an overview](guide/binding-syntax).

### Built-in directives

<live-example name="built-in-directives"></live-example>

Demonstrates Angular built-in directives.
For more information, see [Built-in directives](guide/built-in-directives).

### Built-in template functions

<live-example name="built-in-template-functions"></live-example>

Demonstrates Angular built-in template functions.
For more information, see the [`$any()` type cast function section](guide/template-expression-operators#the-any-type-cast-function) of [Template expression operators](guide/template-expression-operators).

### Interpolation

<live-example name="interpolation"></live-example>

Demonstrates Angular interpolation.
For more information, see [Interpolation and template expressions](guide/interpolation).

### Template expression operators

<live-example name="template-expression-operators"></live-example>

Demonstrates expression operators in Angular templates.
For more information, see [Template expression operators](guide/template-expression-operators).

### Template reference variables

<live-example name="template-reference-variables"></live-example>

Demonstrates Angular's template reference variables.
For more information, see [Template reference variables](guide/template-reference-variables).

### `<ngcontainer>`

<live-example name="ngcontainer"></live-example>

Demonstrates `<ngcontainer>`.
For more information, see the [ng-container section](guide/built-in-directives#ngcontainer) of [Built-in directives](guide/structural-directives) .

### Pipes

<live-example name="pipes"></live-example>

Demonstrates Angular pipes.
For more information, see [Transforming Data Using Pipes](guide/pipes).

### Property binding

<live-example name="property-binding"></live-example>

Demonstrates property binding in Angular.
For more information, see [Property binding](guide/property-binding).

### Structural directives

<live-example name="structural-directives"></live-example>

Demonstrates Angular structural directives.
For more information, see [Structural directives](guide/structural-directives).


### Two-way binding

<live-example name="two-way-binding"></live-example>

Demonstrates two-way data binding in Angular applications.
For more information, see [Two-way binding](guide/two-way-binding).

### Template syntax

<live-example name="template-syntax"></live-example>

Comprehensive demonstration of Angular's template syntax.
For more information, see [Template reference variables](guide/template-syntax).

### User input

<live-example name="user-input"></live-example>

Demonstrates responding to user actions.
For more information, see [User input](guide/user-input).







## Working with components

These examples demonstrate features of Angular components.

### Component interaction

<live-example name="component-interaction"></live-example>

Demonstrates how Angular shares data between components.
For more information, see [Component interaction](guide/component-interaction).

### Component styles

<live-example name="component-styles"></live-example>

Demonstrates styling in Angular apps.
For more information, see [Component styles](guide/component-styles).

### Dynamic component loader

<live-example name="dynamic-component-loader"></live-example>

Demonstrates how to dynamically load components.
For more information, see [Dynamic component loader](guide/dynamic-component-loader).

### Elements

<live-example name="elements"></live-example>

Demonstrates using Angular custom elements.
For more information, see [Angular elements overview](guide/elements).

### Event binding

<live-example name="event-binding"></live-example>

Demonstrates binding to events in Angular.
For more information, see [Event binding](guide/event-binding).

### `@Input()` and `@Output()`

<live-example name="inputs-outputs"></live-example>

Demonstrates `@Input()` and `@Output()` in components and directives.
For more information, see [`@Input()` and `@Output()` properties](guide/inputs-outputs).


### Lifecycle hooks

<live-example name="lifecycle-hooks"></live-example>

Demonstrates Angular lifecycle hooks such as `ngOnInit()` and `ngOnChanges()`.
For more information, see [Hooking into the component lifecycle](guide/lifecycle-hooks).









## Dependency injection

### Dependency injection fundamentals

<live-example name="dependency-injection"></live-example>

Demonstrates fundamentals of Angular dependency injection.
For more information, see [Dependency injection](guide/dependency-injection).

### Dependency injection features

<live-example name="dependency-injection-in-action"></live-example>

Demonstrates many of the features of Angular dependency injection.
For more information, see [Dependency injection in action](guide/dependency-injection).

### Providing dependencies in NgModules

<live-example name="providers"></live-example>

Demonstrates providing services in NgModules.
For more information, see [Providing dependencies in modules](guide/providers).


### Hierarchical dependency injection

<live-example name="hierarchical-dependency-injection"></live-example>

Demonstrates Angular injector trees and resolution modifiers.
For more information, see [Hierarchical injectors](guide/hierarchical-dependency-injection).

### Dependency injection with `providers` and `viewProviders`

<live-example name="providers-viewproviders"></live-example>

Demonstrates how `providers` and `viewproviders` affect dependency injection.
For more information, see the [Providing services in `@Component()`](guide/hierarchical-dependency-injection#providing-services-in-component) section of [Hierarchical injectors](guide/hierarchical-dependency-injection).


### Resolution modifiers and dependency injection

<live-example name="resolution-modifiers"></live-example>

Demonstrates Angular's resolution modifiers, such as `@Self()`.
For more information, see the [Modifying service visibility](guide/hierarchical-dependency-injection#modifying-service-visibility) section of [Hierarchical injectors](guide/hierarchical-dependency-injection).



## Forms

### Forms overview

<live-example name="forms-overview"></live-example>

Demonstrates foundational concepts of Angular forms.
For more information, see [Introduction to forms in Angular](guide/forms-overview).

### Reactive forms

<live-example name="reactive-forms"></live-example>

Demonstrates Angular's reactive forms.
For more information, see [Reactive forms](guide/reactive-forms).

### Template-driven forms

<live-example name="forms"></live-example>

Demonstrates Angular template-driven forms.
For more information, see [Building a template-driven form](guide/forms).

### Form validation

<live-example name="form-validation"></live-example>

Demonstrates validating forms in Angular.
For more information, see [Validating form input](guide/form-validation).

### Dynamic forms

<live-example name="dynamic-form"></live-example>

Demonstrates creating dynamic forms.
For more information, see [Building dynamic forms](guide/dynamic-form).






## NgModules

### NgModules

<live-example name="ngmodules"></live-example>

Demonstrates fundamentals of NgModules.
For more information, see [NgModules](guide/ngmodules).

### Feature modules

<live-example name="feature-modules"></live-example>

Demonstrates using feature modules in Angular.
For more information, see [Feature modules](guide/feature-modules).

### Lazy loading NgModules

<live-example name="lazy-loading-ngmodules"></live-example>

Demonstrates lazy loading NgModules.
For more information, see [Lazy-loading feature modules](guide/lazy-loading-ngmodules).


## Routing

### Router

<live-example name="router"></live-example>

Demonstrates Angular's routing features.
For more information, see [Router](guide/router).

### Router tutorial

<live-example name="router-tutorial"></live-example>

Demonstrates Angular's fundamental routing techniques.
For more information, see [Using Angular routes in a single-page application](guide/router-tutorial).



### Style guide for Documentation contributions

<live-example name="docs-style-guide"></live-example>

Demonstrates Angular documentation style guidelines.
For more information, see [Angular documentation style guide](guide/docs-style-guide).


## Server communication

### `HttpClient`

<live-example name="http"></live-example>

Demonstrates server interaction using HTTP.
For more information, see [Communicating with backend services using HTTP](guide/http).


## Workflow

### Security

<live-example name="security"></live-example>

Demonstrates security concepts in Angular applications.
For more information, see [Security](guide/security).


### Testing

For the sample app that the testing guides describe, see the <live-example noDownload name="testing">sample app</live-example>.

For the tests featured in the testing guides, see <live-example name="testing" stackblitz="specs" noDownload>tests</live-example>.

Demonstrates techniques for testing Angular.
For more information, see [Testing](guide/testing).




## Hybrid Angular applications

### AngularJS to Angular concepts: Quick reference

<live-example name="ajs-quick-reference"></live-example>

Demonstrates Angular for those with an AngularJS background.
For more information, see [AngularJS to Angular concepts: Quick reference](guide/ajs-quick-reference).

