# Frequently-used modules

An Angular app needs at least one module that serves as the root module.
As you add features to your app, you can add them in modules.
The following are frequently used Angular modules with examples
of some of the things they contain:


<table>

 <tr>
   <th style="vertical-align: top">
     NgModule
   </th>

   <th style="vertical-align: top">
     Import it from
   </th>

   <th style="vertical-align: top">
     Why you use it
   </th>
 </tr>

 <tr>
   <td><code>BrowserModule</code></td>
   <td><code>@angular/platform-browser</code></td>
   <td>When you want to run your app in a browser</td>
 </tr>

 <tr>
   <td><code>CommonModule</code></td>
   <td><code>@angular/common</code></td>
   <td>When you want to use <code>NgIf</code>, <code>NgFor</code></td>
 </tr>

 <tr>
   <td><code>FormsModule</code></td>
   <td><code>@angular/forms</code></td>
   <td>When you want to build template driven forms (includes <code>NgModel</code>)</td>
 </tr>

 <tr>
   <td><code>ReactiveFormsModule</code></td>
   <td><code>@angular/forms</code></td>
   <td>When you want to build reactive forms</td>
 </tr>

 <tr>
   <td><code>RouterModule</code></td>
   <td><code>@angular/router</code></td>
   <td>When you want to use <code>RouterLink</code>, <code>.forRoot()</code>, and <code>.forChild()</code></td>
 </tr>

 <tr>
   <td><code>HttpClientModule</code></td>
   <td><code>@angular/common/http</code></td>
   <td>When you want to talk to a server</td>
 </tr>

</table>

## Importing modules

When you use these Angular modules, import them in `AppModule`,
or your feature module as appropriate, and list them in the `@NgModule`
`imports` array. For example, in the basic app generated by the [Angular CLI](cli),
`BrowserModule` is the first import at the top of the `AppModule`,
`app.module.ts`.


```typescript
/* import modules so that AppModule can access them */
import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppComponent } from './app.component';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [ /* add modules here so Angular knows to use them */
    BrowserModule,
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
```

The imports at the top of the array are JavaScript import statements
while the `imports` array within `@NgModule` is Angular specific.
For more information on the difference, see [JavaScript Modules vs. NgModules](guide/ngmodule-vs-jsmodule).


## `BrowserModule` and `CommonModule`

`BrowserModule` imports `CommonModule`, which contributes many common
directives such as `ngIf` and `ngFor`. Additionally, `BrowserModule`
re-exports `CommonModule` making all of its directives available
to any module that imports `BrowserModule`.

For apps that run in the browser, import `BrowserModule` in the
root `AppModule` because it provides services that are essential
to launch and run a browser app. `BrowserModule`’s providers
are for the whole app so it should only be in the root module,
not in feature modules. Feature modules only need the common
directives in `CommonModule`; they don’t need to re-install app-wide providers.

If you do import `BrowserModule` into a lazy loaded feature module,
Angular returns an error telling you to use `CommonModule` instead.

<div class="lightbox">
  <img src="generated/images/guide/frequent-ngmodules/browser-module-error.gif" width=750 alt="BrowserModule error">
</div>


## More on NgModules

You may also be interested in the following:
* [Bootstrapping](guide/bootstrapping).
* [NgModules](guide/ngmodules).
* [JavaScript Modules vs. NgModules](guide/ngmodule-vs-jsmodule).
