# Schematics for Bazel

## WARNING

Schematics in `@angular/bazel` is still highly experimental as of January 2019,
please use with caution. For feedbacks and comments, please open an issue on
GitHub and ping [@mgechev](https://github.com/mgechev) or
[@kyliau](https://github.com/kyliau).

## Requirements

To create a new Angular project that builds with Bazel + CLI, the following
packages have to be installed.

|     Package    | Minimum Version
|----------------|-----------------
| @angular/cli   | v8.0.x
| @angular/bazel | v8.0.x

The `@angular/bazel` package contains schematics to generate necessary Bazel
build files.

If the packages are not on your system yet, install them with the following
commands:

```
yarn global add @angular/cli@next @angular/bazel@next
```

It is very *important* to meet the minimum version requirement of `@angular/cli`
because Bazel schematics rely on some of the new APIs that are missing in older
versions of the CLI. Invoking `@angular/bazel` schematics with an older version
of CLI would very likely result in unexpected errors.

<details>
<summary>
More details
</summary>
Bazel schematics rely on the new
<a href="https://github.com/angular/angular-cli/commit/a0ac4b0e3dd60c75e1edafd6bb8cced47d10a8d3">
<code>ScopedTree</code></a> in <code>@angular-devkit/schematics</code>.
There is currently no way for a schematic to mandate a minimum
"schematic runtime" version. The version of <code>@angular-devkit/schematics</code>
that is installed with the CLI is used to run the schematic even though a different
version is used in the schematic itself.
</details>

## Create a Bazel-managed Angular project

Create a new project using `@angular/bazel` schematics for `ng new`.

```
$ ng new demo --collection=@angular/bazel --defaults
```

In addition to the regular files generated by CLI, the following files that are
specific to a Bazel workspace are also created.

```
...
CREATE demo/BUILD.bazel (190 bytes)
CREATE demo/WORKSPACE (2951 bytes)
CREATE demo/.bazelignore (18 bytes)
CREATE demo/.bazelrc (828 bytes)
CREATE demo/e2e/BUILD.bazel (1230 bytes)
CREATE demo/e2e/protractor.on-prepare.js (1101 bytes)
CREATE demo/src/BUILD.bazel (2626 bytes)
CREATE demo/src/initialize_testbed.ts (432 bytes)
CREATE demo/src/main.dev.ts (185 bytes)
CREATE demo/src/main.prod.ts (249 bytes)
```

Note that in a Bazel-managed project, there is a Bazel WORKSPACE file and a few BUILD.bazel files.
There are also some files specific to a Bazel-managed project, namely `main.dev.ts` and `main.prod.ts`.
This is because all Angular projects built with Bazel must be AOT only.
In a Bazel project, `main.ts` generated by CLI is not used.

By default, `ng new` for Bazel does not perform `yarn install`.
This is because the `node_modules` are managed by Bazel and it is Bazel's
responsibility to perform the install.

Next, let's try to build the project using Bazel.
All existing `ng` commands would work as before.

```
cd demo
# The following yarn step is needed so that `ng build` works correctly.
# Alternatively, you can skip this step if you choose to not use `ng` commands.
# In which case, you'd execute `yarn bazel build //src:bundle`. This is
# equivalent to running `ng build`.
yarn
ng build
ng serve
```

If you encounter a warning about version mismatch, update `ANGULAR_VERSION` in
the WORKSPACE file to match the version of `@angular/bazel` installed from NPM.

Bring up the dev server using `ibazel run` command.

```
yarn ibazel run //src:devserver
```

Make some changes to the code, and verify that the dev server automatically refreshes.

## Development notes

To test any local changes, run

```shell
bazel build //packages/bazel:npm_package
```

then `cd` to the npm package in the `dist` folder and run `yarn link`.
Next run `yarn link` again in the directory where the `ng` command is invoked.
Make sure the `ng` command is local, and not the global installation.

## Generate .d.ts file from JSON schema

The script to generate `.d.ts` file is located in the
[Angular CLI](https://github.com/angular/angular-cli) repo. Make sure
the CLI repository is checked out on your local machine.

Then, in the CLI repository, run the following command

```shell
bazel run //tools:quicktype_runner -- \
  ~/Documents/GitHub/angular/packages/bazel/src/schematics/ng-new/schema.json \
  ~/Documents/GitHub/angular/packages/bazel/src/schematics/ng-new/schema.d.ts
```

## TODOs

1. Make the `ts_json_schema` rule re-usable and portable.
2. Add comments in BUILD files. See discussion [here](https://github.com/angular/angular/pull/26971#discussion_r231325683).
