/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */

import {nocollapseHack} from '../../src/transformers/nocollapse_hack';

describe('@nocollapse hack', () => {
  it('should add @nocollapse to a basic class', () => {
    const decl = `Foo.ngInjectorDef = define(...);`;
    expect(nocollapseHack(decl)).toEqual('/** @nocollapse */ ' + decl);
  });

  it('should add nocollapse to an if (false) declaration of the kind generated by tsickle', () => {
    const decl = `
      if (false) {
        /** @type {?} */
        Foo.ngInjectorDef;
      }
    `;
    expect(nocollapseHack(decl)).toContain('/** @nocollapse @type {?} */');
  });
});