/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */

// clang-format off
export {
  ɵɵdefineBase,
  ɵɵdefineComponent,
  ɵɵdefineDirective,
  ɵɵdefinePipe,
  ɵɵdefineNgModule,
  detectChanges as ɵdetectChanges,
  renderComponent as ɵrenderComponent,
  AttributeMarker as ɵAttributeMarker,
  ComponentType as ɵComponentType,
  ComponentFactory as ɵRender3ComponentFactory,
  ComponentRef as ɵRender3ComponentRef,
  DirectiveType as ɵDirectiveType,
  RenderFlags as ɵRenderFlags,
  ɵɵdirectiveInject,
  ɵɵinjectAttribute,
  ɵɵgetFactoryOf,
  ɵɵgetInheritedFactory,
  ɵɵsetComponentScope,
  ɵɵsetNgModuleScope,
  ɵɵtemplateRefExtractor,
  ɵɵProvidersFeature,
  ɵɵInheritDefinitionFeature,
  ɵɵNgOnChangesFeature,
  LifecycleHooksFeature as ɵLifecycleHooksFeature,
  NgModuleType as ɵNgModuleType,
  NgModuleRef as ɵRender3NgModuleRef,
  CssSelectorList as ɵCssSelectorList,
  markDirty as ɵmarkDirty,
  NgModuleFactory as ɵNgModuleFactory,
  NO_CHANGE as ɵNO_CHANGE,
  ɵɵcontainer,
  ɵɵnextContext,
  ɵɵelementStart,
  ɵɵnamespaceHTML,
  ɵɵnamespaceMathML,
  ɵɵnamespaceSVG,
  ɵɵelement,
  ɵɵlistener,
  ɵɵtext,
  ɵɵembeddedViewStart,
  ɵɵprojection,
  ɵɵbind,
  ɵɵinterpolation1,
  ɵɵinterpolation2,
  ɵɵinterpolation3,
  ɵɵinterpolation4,
  ɵɵinterpolation5,
  ɵɵinterpolation6,
  ɵɵinterpolation7,
  ɵɵinterpolation8,
  ɵɵinterpolationV,
  ɵɵpipeBind1,
  ɵɵpipeBind2,
  ɵɵpipeBind3,
  ɵɵpipeBind4,
  ɵɵpipeBindV,
  ɵɵpureFunction0,
  ɵɵpureFunction1,
  ɵɵpureFunction2,
  ɵɵpureFunction3,
  ɵɵpureFunction4,
  ɵɵpureFunction5,
  ɵɵpureFunction6,
  ɵɵpureFunction7,
  ɵɵpureFunction8,
  ɵɵpureFunctionV,
  ɵɵgetCurrentView,
  getDirectives as ɵgetDirectives,
  getHostElement as ɵgetHostElement,
  ɵɵrestoreView,
  ɵɵcontainerRefreshStart,
  ɵɵcontainerRefreshEnd,
  ɵɵqueryRefresh,
  ɵɵviewQuery,
  ɵɵstaticViewQuery,
  ɵɵstaticContentQuery,
  ɵɵloadViewQuery,
  ɵɵcontentQuery,
  ɵɵloadContentQuery,
  ɵɵelementEnd,
  ɵɵelementProperty,
  ɵɵproperty,
  ɵɵpropertyInterpolate,
  ɵɵpropertyInterpolate1,
  ɵɵpropertyInterpolate2,
  ɵɵpropertyInterpolate3,
  ɵɵpropertyInterpolate4,
  ɵɵpropertyInterpolate5,
  ɵɵpropertyInterpolate6,
  ɵɵpropertyInterpolate7,
  ɵɵpropertyInterpolate8,
  ɵɵpropertyInterpolateV,
  ɵɵcomponentHostSyntheticProperty,
  ɵɵcomponentHostSyntheticListener,
  ɵɵprojectionDef,
  ɵɵreference,
  ɵɵenableBindings,
  ɵɵdisableBindings,
  ɵɵallocHostVars,
  ɵɵelementAttribute,
  ɵɵelementContainerStart,
  ɵɵelementContainerEnd,
  ɵɵelementStyling,
  ɵɵelementStylingMap,
  ɵɵelementStyleProp,
  ɵɵelementStylingApply,
  ɵɵelementClassProp,

  ɵɵelementHostAttrs,
  ɵɵelementHostStyling,
  ɵɵelementHostStylingMap,
  ɵɵelementHostStyleProp,
  ɵɵelementHostClassProp,
  ɵɵelementHostStylingApply,

  ɵɵselect,
  ɵɵtextBinding,
  ɵɵtemplate,
  ɵɵembeddedViewEnd,
  store as ɵstore,
  ɵɵload,
  ɵɵpipe,
  ɵɵBaseDef,
  ComponentDef as ɵComponentDef,
  ɵɵComponentDefWithMeta,
  DirectiveDef as ɵDirectiveDef,
  ɵɵDirectiveDefWithMeta,
  PipeDef as ɵPipeDef,
  ɵɵPipeDefWithMeta,
  whenRendered as ɵwhenRendered,
  ɵɵi18n,
  ɵɵi18nAttributes,
  ɵɵi18nExp,
  ɵɵi18nStart,
  ɵɵi18nEnd,
  ɵɵi18nApply,
  ɵɵi18nPostprocess,
  i18nConfigureLocalize as ɵi18nConfigureLocalize,
  ɵɵi18nLocalize,
  setClassMetadata as ɵsetClassMetadata,
  ɵɵresolveWindow,
  ɵɵresolveDocument,
  ɵɵresolveBody,
} from './render3/index';


export {
  compileComponent as ɵcompileComponent,
  compileDirective as ɵcompileDirective,
} from './render3/jit/directive';
export {
  compileNgModule as ɵcompileNgModule,
  compileNgModuleDefs as ɵcompileNgModuleDefs,
  patchComponentDefWithScope as ɵpatchComponentDefWithScope,
  resetCompiledComponents as ɵresetCompiledComponents,
  flushModuleScopingQueueAsMuchAsPossible as ɵflushModuleScopingQueueAsMuchAsPossible,
  transitiveScopesFor as ɵtransitiveScopesFor,
} from './render3/jit/module';
export {
  compilePipe as ɵcompilePipe,
} from './render3/jit/pipe';

export {
  NgModuleDef as ɵNgModuleDef,
  ɵɵNgModuleDefWithMeta,
  NgModuleTransitiveScopes as ɵNgModuleTransitiveScopes,
} from './metadata/ng_module';

export {
  ɵɵsanitizeHtml,
  ɵɵsanitizeStyle,
  ɵɵdefaultStyleSanitizer,
  ɵɵsanitizeScript,
  ɵɵsanitizeUrl,
  ɵɵsanitizeResourceUrl,
  ɵɵsanitizeUrlOrResourceUrl,
} from './sanitization/sanitization';

export {
  bypassSanitizationTrustHtml as ɵbypassSanitizationTrustHtml,
  bypassSanitizationTrustStyle as ɵbypassSanitizationTrustStyle,
  bypassSanitizationTrustScript as ɵbypassSanitizationTrustScript,
  bypassSanitizationTrustUrl as ɵbypassSanitizationTrustUrl,
  bypassSanitizationTrustResourceUrl as ɵbypassSanitizationTrustResourceUrl,
} from './sanitization/bypass';

export {
  getLContext as ɵgetLContext
} from './render3/context_discovery';

export {
  NG_ELEMENT_ID as ɵNG_ELEMENT_ID,
  NG_COMPONENT_DEF as ɵNG_COMPONENT_DEF,
  NG_DIRECTIVE_DEF as ɵNG_DIRECTIVE_DEF,
  NG_PIPE_DEF as ɵNG_PIPE_DEF,
  NG_MODULE_DEF as ɵNG_MODULE_DEF,
  NG_BASE_DEF as ɵNG_BASE_DEF
} from './render3/fields';

export {
  NG_INJECTABLE_DEF as ɵNG_INJECTABLE_DEF,
  NG_INJECTOR_DEF as ɵNG_INJECTOR_DEF,
} from './di/interface/defs';

export {
  Player as ɵPlayer,
  PlayerFactory as ɵPlayerFactory,
  PlayState as ɵPlayState,
  PlayerHandler as ɵPlayerHandler,
} from './render3/interfaces/player';

export {
  LContext as ɵLContext,
} from './render3/interfaces/context';

export {
  bindPlayerFactory as ɵbindPlayerFactory,
} from './render3/styling/player_factory';

export {
  addPlayer as ɵaddPlayer,
  getPlayers as ɵgetPlayers,
} from './render3/players';

// we reexport these symbols just so that they are retained during the dead code elimination
// performed by rollup while it's creating fesm files.
//
// no code actually imports these symbols from the @angular/core entry point
export {
  compileNgModuleFactory__POST_R3__ as ɵcompileNgModuleFactory__POST_R3__,
  isBoundToModule__POST_R3__ as ɵisBoundToModule__POST_R3__
} from './application_ref';
export {
  SWITCH_COMPILE_COMPONENT__POST_R3__ as ɵSWITCH_COMPILE_COMPONENT__POST_R3__,
  SWITCH_COMPILE_DIRECTIVE__POST_R3__ as ɵSWITCH_COMPILE_DIRECTIVE__POST_R3__,
  SWITCH_COMPILE_PIPE__POST_R3__ as ɵSWITCH_COMPILE_PIPE__POST_R3__,
} from './metadata/directives';
export {
  SWITCH_COMPILE_NGMODULE__POST_R3__ as ɵSWITCH_COMPILE_NGMODULE__POST_R3__,
} from './metadata/ng_module';
export {
  getDebugNode__POST_R3__ as ɵgetDebugNode__POST_R3__,
} from './debug/debug_node';
export {
  SWITCH_COMPILE_INJECTABLE__POST_R3__ as ɵSWITCH_COMPILE_INJECTABLE__POST_R3__,
} from './di/injectable';
export {
  SWITCH_IVY_ENABLED__POST_R3__ as ɵSWITCH_IVY_ENABLED__POST_R3__,
} from './ivy_switch';
export {
  SWITCH_CHANGE_DETECTOR_REF_FACTORY__POST_R3__ as ɵSWITCH_CHANGE_DETECTOR_REF_FACTORY__POST_R3__,
} from './change_detection/change_detector_ref';
export {
  Compiler_compileModuleSync__POST_R3__ as ɵCompiler_compileModuleSync__POST_R3__,
  Compiler_compileModuleAsync__POST_R3__ as ɵCompiler_compileModuleAsync__POST_R3__,
  Compiler_compileModuleAndAllComponentsSync__POST_R3__ as ɵCompiler_compileModuleAndAllComponentsSync__POST_R3__,
  Compiler_compileModuleAndAllComponentsAsync__POST_R3__ as ɵCompiler_compileModuleAndAllComponentsAsync__POST_R3__,
} from './linker/compiler';
export {
  SWITCH_ELEMENT_REF_FACTORY__POST_R3__ as ɵSWITCH_ELEMENT_REF_FACTORY__POST_R3__,
} from './linker/element_ref';
export {
  SWITCH_TEMPLATE_REF_FACTORY__POST_R3__ as ɵSWITCH_TEMPLATE_REF_FACTORY__POST_R3__,
} from './linker/template_ref';
export {
  SWITCH_VIEW_CONTAINER_REF_FACTORY__POST_R3__ as ɵSWITCH_VIEW_CONTAINER_REF_FACTORY__POST_R3__,
} from './linker/view_container_ref';
export {
  SWITCH_RENDERER2_FACTORY__POST_R3__ as ɵSWITCH_RENDERER2_FACTORY__POST_R3__,
} from './render/api';

export {
  getModuleFactory__POST_R3__ as ɵgetModuleFactory__POST_R3__,
  registerNgModuleType as ɵregisterNgModuleType,
} from './linker/ng_module_factory_loader';

export {
  publishGlobalUtil as ɵpublishGlobalUtil,
  publishDefaultGlobalUtils as ɵpublishDefaultGlobalUtils
} from './render3/util/global_utils';

export {createInjector as ɵcreateInjector} from './di/r3_injector';

// clang-format on
