/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */

// TODO(jteplitz602): Load WorkerGlobalScope from lib.webworker.d.ts file #3492
declare var WorkerGlobalScope: any /** TODO #9100 */;
// CommonJS / Node have global context exposed as "global" variable.
// We don't want to include the whole node.d.ts this this compilation unit so we'll just fake
// the global "global" var for now.
declare var global: any /** TODO #9100 */;
// Not yet available in TypeScript: https://github.com/Microsoft/TypeScript/pull/29332
declare var globalThis: any /** TODO #9100 */;

function getGlobal(): any {
  const __globalThis = typeof globalThis !== 'undefined' && globalThis;
  const __window = typeof window !== 'undefined' && window;
  const __self = typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
      self instanceof WorkerGlobalScope && self;
  const __global = typeof global !== 'undefined' && global;

  // Always use __globalThis if available, which is the spec-defined global variable across all
  // environments, then fallback to __global first, because in Node tests both __global and
  // __window may be defined and _global should be __global in that case.
  return __globalThis || __global || __window || __self;
}

const _global = getGlobal();

/**
 * Attention: whenever providing a new value, be sure to add an
 * entry into the corresponding `....externs.js` file,
 * so that closure won't use that global for its purposes.
 */
export {_global as global};
