Implements a service worker for Angular apps. 
Adding a service worker to an Angular app is one of the steps for turning it into a Progressive Web App (also known as a PWA).

At its simplest, a service worker is a script that runs in the web browser and manages caching for an application. 
Service workers function as a network proxy. They intercept all outgoing HTTP requests made by the application and can choose how to respond to them.

To set up the Angular service worker in your project, use the CLI `add` command.
```
ng add @angular/pwa
```

The command configures your app to use service workers by adding the service-worker package
and generating the necessary support files.

For more usage information, see the [Service Workers](guide/service-worker-intro) guide.

