# Jboot 简介

[[toc]]

## 简介

Jboot 是一个基于 JFinal、JFinal-Undertow、Dubbo、Seata、Sentinel、ShardingSphere、Nacos 等开发的微服务框架，
帮助开发者降低微服务开发门槛。同时完美支持在 idea、eclipse 下多 maven 模块，对 java 代码、html、css、js 等资源文件进行热加载。爽爽开发，快乐生活。



## 特点

目前已经开源超过了 3 年的时间，迭代了 100+ 个版本，已经被超过 1000+ 公司在使用。

Jboot 主要有以下特征：

- 1、基于 JFinal 的 MVC + ORM 快速开发。
- 2、基于 ShardingSphere + Seata 分布式事务 和 分库分表。
- 3、基于 Dubbo 或 Motan 的 RPC 实现
- 4、基于 Sentinel 的分布式限流和降级
- 5、基于 Apollo 和 Nacos 的分布式配置中心
- 6、基于 EhCache 和 Redis 的分布式二级缓存

## 微信群

![](./static/images/jboot-wechat-group.png)

## QQ群

群1: 601440615（已满）
群2: 719614554

## 文档目录

- [安装](install.md)
- [2分钟快速开始](quickstart.md)
- [热加载](hotload.md)
- [Undertow](undertow.md)
- [配置](config.md)
- [JFinalConfig](jfinalConfig.md)
- [WebSocket](websocket.md)
- [MVC](mvc.md)
- [AOP](aop.md)
- [数据库操作](db.md)
- [缓存](cache.md)
- [RPC远程调用](rpc.md)
- [MQ消息队列](mq.md)
- [Gateway 网关](gateway.md)
- [任务调度](schedule.md)
- [限流](limit.md)
- [监控](metrics.md)
- [序列化](serialize.md)
- [事件机制](event.md)
- [SPI扩展机制](spi.md)
- [代码生成器](codegen.md)
- [项目构建](build.md)
- [项目部署](deploy.md)
- [Jboot与Docker](docker.md)
- [1.x 升级到 2.x 教程](upgrade.md)
- [交流社区、QQ群和微信群](communication.md)
- 第三方组件的支持
  - [sentinel 限流降级](sentinel.md) 
  - [redis](redis.md)
  - [shiro](shiro.md)
  - [jwt](jwt.md)
  - [swagger](swagger.md)
