/**
 * Copyright (c) 2015-2021, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.jboot.test.rpc.motan;


import io.jboot.app.JbootApplication;
import io.jboot.app.JbootSimpleApplication;

public class MotanServer {

    public static void main(String[] args) throws InterruptedException {


        JbootApplication.setBootArg("jboot.rpc.type", "motan");

        // 开启 @RPCBean 自动暴露功能，默认情况下是开启的，无需配置，
        // 但是此测试代码的 jboot.properties 文件关闭了，这里需要开启下
        JbootApplication.setBootArg("jboot.rpc.autoExportEnable", true);

        // motan 与 dubbo 不一样，motan 需要配置 export，
        // export 配置内容为 协议ID:端口号，默认的协议 id 为 default
        JbootApplication.setBootArg("jboot.rpc.motan.defaultExport", "default:28080");



        JbootSimpleApplication.run(args);

        System.out.println("MotanServer started...");

    }
}
