/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.farsunset.cim.sdk.android.CIMCacheManager;
import com.farsunset.cim.sdk.android.CIMPushService;
import com.farsunset.cim.sdk.android.logger.CIMLogger;
import com.farsunset.cim.sdk.android.model.SentBody;
import java.io.Serializable;
import java.util.UUID;

public class CIMPushManager {
    protected static final String ACTION_CREATE_CIM_CONNECTION = "ACTION_CREATE_CIM_CONNECTION";
    protected static final String ACTION_DESTROY_CIM_SERVICE = "ACTION_DESTROY_CIM_SERVICE";
    protected static final String ACTION_ACTIVATE_PUSH_SERVICE = "ACTION_ACTIVATE_PUSH_SERVICE";
    protected static final String ACTION_SEND_REQUEST_BODY = "ACTION_SEND_REQUEST_BODY";
    protected static final String ACTION_CLOSE_CIM_CONNECTION = "ACTION_CLOSE_CIM_CONNECTION";
    protected static final String ACTION_SET_LOGGER_EATABLE = "ACTION_SET_LOGGER_EATABLE";
    protected static final String ACTION_SHOW_PERSIST_NOTIFICATION = "ACTION_SHOW_PERSIST_NOTIFICATION";
    protected static final String ACTION_HIDE_PERSIST_NOTIFICATION = "ACTION_HIDE_PERSIST_NOTIFICATION";
    protected static final String ACTION_CIM_CONNECTION_PONG = "ACTION_CIM_CONNECTION_PONG";

    public static void connect(Context context, String host, int port) {
        if (TextUtils.isEmpty((CharSequence)host) || port == 0) {
            CIMLogger.getLogger().invalidHostPort(host, port);
            return;
        }
        CIMCacheManager.putString(context, "KEY_CIM_SERVER_HOST", host);
        CIMCacheManager.putInt(context, "KEY_CIM_SERVER_PORT", port);
        CIMCacheManager.putBoolean(context, "KEY_CIM_DESTROYED", false);
        CIMCacheManager.putBoolean(context, "KEY_MANUAL_STOP", false);
        CIMCacheManager.remove(context, "KEY_UID");
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.setAction(ACTION_CREATE_CIM_CONNECTION);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void setLoggerEnable(Context context, boolean enable) {
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.putExtra("KEY_LOGGER_ENABLE", enable);
        serviceIntent.setAction(ACTION_SET_LOGGER_EATABLE);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void startForeground(Context context, int icon, String channel, String message) {
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.putExtra("KEY_NOTIFICATION_MESSAGE", message);
        serviceIntent.putExtra("KEY_NOTIFICATION_CHANNEL", channel);
        serviceIntent.putExtra("KEY_NOTIFICATION_ICON", icon);
        serviceIntent.setAction(ACTION_SHOW_PERSIST_NOTIFICATION);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void cancelForeground(Context context) {
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.setAction(ACTION_HIDE_PERSIST_NOTIFICATION);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void bind(Context context, long uid) {
        CIMPushManager.bind(context, String.valueOf(uid));
    }

    public static void bind(Context context, String uid) {
        if (CIMPushManager.isDestroyed(context)) {
            return;
        }
        CIMPushManager.sendBindRequest(context, uid);
    }

    public static void setTag(Context context, String tag) {
        SentBody sent = new SentBody();
        sent.setKey("client_set_tag");
        sent.put("tag", tag);
        CIMPushManager.sendRequest(context, sent);
    }

    public static void removeTag(Context context) {
        SentBody sent = new SentBody();
        sent.setKey("client_remove_tag");
        CIMPushManager.sendRequest(context, sent);
    }

    public static void pong(Context context) {
        if (CIMPushManager.isDestroyed(context) || CIMPushManager.isStopped(context)) {
            return;
        }
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.setAction(ACTION_CIM_CONNECTION_PONG);
        CIMPushManager.startService(context, serviceIntent);
    }

    private static void sendBindRequest(Context context, String uid) {
        CIMCacheManager.putBoolean(context, "KEY_MANUAL_STOP", false);
        CIMCacheManager.putString(context, "KEY_UID", uid);
        SentBody sent = new SentBody();
        sent.setKey("client_bind");
        sent.put("uid", String.valueOf(uid));
        sent.put("channel", "android");
        sent.put("deviceId", CIMPushManager.getDeviceId(context));
        sent.put("deviceName", Build.MODEL);
        sent.put("appVersion", CIMPushManager.getVersionName(context));
        sent.put("osVersion", Build.VERSION.RELEASE);
        sent.put("packageName", context.getPackageName());
        sent.setTimestamp(System.currentTimeMillis());
        CIMPushManager.sendRequest(context, sent);
    }

    protected static boolean autoBindAccount(Context context) {
        String uid = CIMCacheManager.getString(context, "KEY_UID");
        if (uid == null || CIMPushManager.isDestroyed(context)) {
            return false;
        }
        CIMPushManager.sendBindRequest(context, uid);
        return true;
    }

    public static void sendRequest(Context context, SentBody body) {
        if (CIMPushManager.isDestroyed(context) || CIMPushManager.isStopped(context)) {
            return;
        }
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.putExtra("KEY_SEND_BODY", (Serializable)body);
        serviceIntent.setAction(ACTION_SEND_REQUEST_BODY);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void stop(Context context) {
        if (CIMPushManager.isDestroyed(context)) {
            return;
        }
        CIMCacheManager.putBoolean(context, "KEY_MANUAL_STOP", true);
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.setAction(ACTION_CLOSE_CIM_CONNECTION);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void destroy(Context context) {
        CIMCacheManager.putBoolean(context, "KEY_CIM_DESTROYED", true);
        CIMCacheManager.remove(context, "KEY_UID");
        Intent serviceIntent = new Intent(context, CIMPushService.class);
        serviceIntent.setAction(ACTION_DESTROY_CIM_SERVICE);
        CIMPushManager.startService(context, serviceIntent);
    }

    public static void resume(Context context) {
        if (CIMPushManager.isDestroyed(context)) {
            return;
        }
        CIMPushManager.autoBindAccount(context);
    }

    public static boolean isDestroyed(Context context) {
        return CIMCacheManager.getBoolean(context, "KEY_CIM_DESTROYED");
    }

    public static boolean isStopped(Context context) {
        return CIMCacheManager.getBoolean(context, "KEY_MANUAL_STOP");
    }

    public static boolean isConnected(Context context) {
        return CIMCacheManager.getBoolean(context, "KEY_CIM_CONNECTION_STATE");
    }

    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = CIMPushManager.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        return ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
    }

    public static void startService(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
    }

    private static String getVersionName(Context context) {
        try {
            PackageInfo mPackageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return mPackageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static String getDeviceId(Context context) {
        String currDeviceId = CIMCacheManager.getString(context, "KEY_DEVICE_ID");
        if (!TextUtils.isEmpty((CharSequence)currDeviceId)) {
            return currDeviceId;
        }
        String deviceId = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        CIMCacheManager.putString(context, "KEY_DEVICE_ID", deviceId);
        return deviceId;
    }
}

