/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.server.coder;

import com.farsunset.cim.sdk.server.constant.ChannelAttr;
import com.farsunset.cim.sdk.server.model.Pong;
import com.farsunset.cim.sdk.server.model.SentBody;
import com.farsunset.cim.sdk.server.model.proto.SentBodyProto;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class AppMessageDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> queue) throws Exception {
        context.channel().attr(ChannelAttr.PING_COUNT).set(null);
        if (buffer.readableBytes() < 3) {
            return;
        }
        buffer.markReaderIndex();
        byte type = buffer.readByte();
        byte lv = buffer.readByte();
        byte hv = buffer.readByte();
        int length = this.getContentLength(lv, hv);
        if (buffer.readableBytes() < length) {
            buffer.resetReaderIndex();
            return;
        }
        byte[] dataBytes = new byte[length];
        buffer.readBytes(dataBytes);
        Object message = this.mappingMessageObject(dataBytes, type);
        queue.add(message);
    }

    public Object mappingMessageObject(byte[] data, byte type) throws Exception {
        if (0 == type) {
            return Pong.getInstance();
        }
        SentBodyProto.Model bodyProto = SentBodyProto.Model.parseFrom(data);
        SentBody body = new SentBody();
        body.setKey(bodyProto.getKey());
        body.setTimestamp(bodyProto.getTimestamp());
        body.putAll(bodyProto.getDataMap());
        return body;
    }

    private int getContentLength(byte lv, byte hv) {
        int l = lv & 0xFF;
        int h = hv & 0xFF;
        return l | h << 8;
    }
}

