/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.server.group;

import com.farsunset.cim.sdk.server.constant.ChannelAttr;
import com.farsunset.cim.sdk.server.model.Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class SessionGroup
extends ConcurrentHashMap<String, Collection<Channel>> {
    private static final Collection<Channel> EMPTY_LIST = new LinkedList<Channel>();
    private final transient ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            future.removeListener((GenericFutureListener)this);
            SessionGroup.this.remove(future.channel());
        }
    };

    protected String getKey(Channel channel) {
        return (String)channel.attr(ChannelAttr.UID).get();
    }

    public void remove(Channel channel) {
        String uid = this.getKey(channel);
        Collection<Channel> collections = this.getOrDefault(uid, EMPTY_LIST);
        collections.remove(channel);
        if (collections.isEmpty()) {
            this.remove(uid);
        }
    }

    public void add(Channel channel) {
        String uid = this.getKey(channel);
        if (uid == null || !channel.isActive()) {
            return;
        }
        channel.closeFuture().addListener((GenericFutureListener)this.remover);
        Collection collections = this.putIfAbsent(uid, new ConcurrentLinkedQueue<Channel>(Collections.singleton(channel)));
        if (collections != null) {
            collections.add(channel);
        }
        if (!channel.isActive()) {
            this.remove(channel);
        }
    }

    public void write(String key, Message message) {
        this.find(key).forEach((? super T channel) -> channel.writeAndFlush((Object)message));
    }

    public Collection<Channel> find(String key) {
        return this.getOrDefault(key, EMPTY_LIST);
    }

    public Collection<Channel> find(String key, String ... channel) {
        List<String> channels = Arrays.asList(channel);
        return this.find(key).stream().filter(item -> channels.contains(item.attr(ChannelAttr.CHANNEL).get())).collect(Collectors.toList());
    }
}

