/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.farsunset.cim.sdk.android.CIMCacheManager;
import com.farsunset.cim.sdk.android.CIMPushManager;
import com.farsunset.cim.sdk.android.coder.ClientMessageDecoder;
import com.farsunset.cim.sdk.android.coder.ClientMessageEncoder;
import com.farsunset.cim.sdk.android.logger.CIMLogger;
import com.farsunset.cim.sdk.android.model.BinaryBody;
import com.farsunset.cim.sdk.android.model.Message;
import com.farsunset.cim.sdk.android.model.Ping;
import com.farsunset.cim.sdk.android.model.Pong;
import com.farsunset.cim.sdk.android.model.ReplyBody;
import com.farsunset.cim.sdk.android.model.SentBody;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class CIMConnectorManager {
    private static CIMConnectorManager manager;
    private static final int READ_BUFFER_SIZE = 2048;
    private static final int WRITE_BUFFER_SIZE = 1024;
    private static final int CONNECT_TIME_OUT = 10000;
    private static final int CONNECT_ALIVE_TIME_OUT = 120000;
    private static final CIMLogger LOGGER;
    private SocketChannel socketChannel;
    private final Context context;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(3);
    private final ExecutorService workerExecutor = Executors.newFixedThreadPool(1, r -> new Thread(r, "worker-"));
    private final ExecutorService bossExecutor = Executors.newFixedThreadPool(1, r -> new Thread(r, "boss-"));
    private final ClientMessageEncoder messageEncoder = new ClientMessageEncoder();
    private final ClientMessageDecoder messageDecoder = new ClientMessageDecoder();
    private final Handler idleHandler = new Handler(){

        public void handleMessage(android.os.Message m) {
            CIMConnectorManager.this.workerExecutor.execute(() -> CIMConnectorManager.this.onSessionIdle());
        }
    };

    private CIMConnectorManager(Context context) {
        this.context = context;
    }

    public static synchronized CIMConnectorManager getManager(Context context) {
        if (manager == null) {
            manager = new CIMConnectorManager(context);
        }
        return manager;
    }

    public void connect(String host, int port) {
        if (!CIMPushManager.isNetworkConnected(this.context)) {
            Intent intent = new Intent();
            intent.setPackage(this.context.getPackageName());
            intent.setAction("com.farsunset.cim.CONNECT_FAILED");
            this.context.sendBroadcast(intent);
            return;
        }
        if (this.isConnected()) {
            return;
        }
        this.bossExecutor.execute(() -> {
            if (this.isConnected()) {
                return;
            }
            LOGGER.startConnect(host, port);
            CIMCacheManager.putBoolean(this.context, "KEY_CIM_CONNECTION_STATE", false);
            try {
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(true);
                this.socketChannel.socket().setTcpNoDelay(true);
                this.socketChannel.socket().setKeepAlive(true);
                this.socketChannel.socket().setReceiveBufferSize(2048);
                this.socketChannel.socket().setSendBufferSize(1024);
                this.socketChannel.socket().connect(new InetSocketAddress(host, port), 10000);
                this.handleConnectedEvent();
                while (this.socketChannel.read(this.headerBuffer) > 0) {
                    this.handleSocketReadEvent();
                }
                this.close();
            }
            catch (ConnectException | SocketTimeoutException ignore) {
                this.handleConnectAbortedEvent();
            }
            catch (IOException ignore) {
                this.handleDisconnectedEvent();
            }
        });
    }

    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.onSessionClosed();
        }
    }

    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    public void sendHeartbeat() {
        this.send(Pong.getInstance());
    }

    public void send(BinaryBody body) {
        if (!this.isConnected()) {
            return;
        }
        this.workerExecutor.execute(() -> {
            int result = 0;
            try {
                ByteBuffer buffer = this.messageEncoder.encode(body);
                while (buffer.hasRemaining()) {
                    result += this.socketChannel.write(buffer);
                }
            }
            catch (Exception e) {
                result = -1;
            }
            finally {
                if (result <= 0) {
                    this.close();
                } else {
                    this.onMessageSent(body);
                }
            }
        });
    }

    private void onSessionCreated() {
        LOGGER.sessionCreated(this.socketChannel);
        Intent intent = new Intent();
        intent.setPackage(this.context.getPackageName());
        intent.setAction("com.farsunset.cim.CONNECT_FINISHED");
        this.context.sendBroadcast(intent);
    }

    private void onSessionClosed() {
        this.idleHandler.removeMessages(0);
        LOGGER.sessionClosed(this.socketChannel);
        Intent intent = new Intent();
        intent.setPackage(this.context.getPackageName());
        intent.setAction("com.farsunset.cim.CONNECTION_CLOSED");
        this.context.sendBroadcast(intent);
    }

    private void onSessionIdle() {
        LOGGER.sessionIdle(this.socketChannel);
        this.close();
    }

    private void onMessageReceived(Object obj) {
        Intent intent;
        if (obj instanceof Message) {
            intent = new Intent();
            intent.setPackage(this.context.getPackageName());
            intent.setAction("com.farsunset.cim.MESSAGE_RECEIVED");
            intent.putExtra(Message.class.getName(), (Serializable)((Message)obj));
            this.context.sendBroadcast(intent);
        }
        if (obj instanceof ReplyBody) {
            intent = new Intent();
            intent.setPackage(this.context.getPackageName());
            intent.setAction("com.farsunset.cim.REPLY_RECEIVED");
            intent.putExtra(ReplyBody.class.getName(), (Serializable)((ReplyBody)obj));
            this.context.sendBroadcast(intent);
        }
    }

    private void onMessageSent(Object message) {
        LOGGER.messageSent(this.socketChannel, message);
        if (message instanceof SentBody) {
            Intent intent = new Intent();
            intent.setPackage(this.context.getPackageName());
            intent.setAction("com.farsunset.cim.SEND_FINISHED");
            intent.putExtra(SentBody.class.getName(), (Serializable)((SentBody)message));
            this.context.sendBroadcast(intent);
        }
    }

    private void handleDisconnectedEvent() {
        this.close();
    }

    private void handleConnectAbortedEvent() {
        long interval = 30000L - (long)(5000 - new Random().nextInt(15000));
        LOGGER.connectFailure(interval);
        Intent intent = new Intent();
        intent.setPackage(this.context.getPackageName());
        intent.setAction("com.farsunset.cim.CONNECT_FAILED");
        intent.putExtra("interval", interval);
        this.context.sendBroadcast(intent);
    }

    private void handleConnectedEvent() {
        this.closeCountDown();
        this.onSessionCreated();
    }

    private void handleSocketReadEvent() throws IOException {
        this.closeCountDown();
        Object message = this.messageDecoder.doDecode(this.headerBuffer, this.socketChannel);
        LOGGER.messageReceived(this.socketChannel, message);
        if (message instanceof Ping) {
            this.send(Pong.getInstance());
            return;
        }
        this.onMessageReceived(message);
    }

    private void closeCountDown() {
        this.idleHandler.removeMessages(0);
        this.idleHandler.sendEmptyMessageDelayed(0, 120000L);
    }

    static {
        LOGGER = CIMLogger.getLogger();
    }
}

