/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android;

import android.net.NetworkInfo;
import android.util.Log;
import com.farsunset.cim.sdk.android.CIMEventListener;
import com.farsunset.cim.sdk.android.model.Message;
import com.farsunset.cim.sdk.android.model.ReplyBody;
import com.farsunset.cim.sdk.android.model.SentBody;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CIMListenerManager {
    private static final ArrayList<CIMEventListener> cimListeners = new ArrayList();
    private static final ReceiveComparator comparator = new ReceiveComparator();

    private CIMListenerManager() {
    }

    public static void registerMessageListener(CIMEventListener listener) {
        if (!cimListeners.contains(listener)) {
            cimListeners.add(listener);
            Collections.sort(cimListeners, comparator);
        }
    }

    public static void removeMessageListener(CIMEventListener listener) {
        cimListeners.remove(listener);
    }

    public static void notifyOnNetworkChanged(NetworkInfo info) {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onNetworkChanged(info);
        }
    }

    public static void notifyOnConnectFinished(boolean hasAutoBind) {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onConnectFinished(hasAutoBind);
        }
    }

    public static void notifyOnMessageReceived(Message message) {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onMessageReceived(message);
        }
    }

    public static void notifyOnConnectionClosed() {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onConnectionClosed();
        }
    }

    public static void notifyOnConnectFailed() {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onConnectFailed();
        }
    }

    public static void notifyOnReplyReceived(ReplyBody body) {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onReplyReceived(body);
        }
    }

    public static void notifyOnSendFinished(SentBody body) {
        for (CIMEventListener cimListener : cimListeners) {
            cimListener.onSendFinished(body);
        }
    }

    public static void destroy() {
        cimListeners.clear();
    }

    public static void logListenersName() {
        for (CIMEventListener cimListener : cimListeners) {
            Log.i((String)CIMEventListener.class.getSimpleName(), (String)("#######" + cimListener.getClass().getName() + "#######"));
        }
    }

    private static class ReceiveComparator
    implements Comparator<CIMEventListener> {
        private ReceiveComparator() {
        }

        @Override
        public int compare(CIMEventListener arg1, CIMEventListener arg2) {
            int order1 = arg1.getEventDispatchOrder();
            int order2 = arg2.getEventDispatchOrder();
            return Integer.compare(order2, order1);
        }
    }
}

