/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.farsunset.cim.sdk.android.CIMCacheManager;
import com.farsunset.cim.sdk.android.CIMConnectorManager;
import com.farsunset.cim.sdk.android.CIMPushManager;
import com.farsunset.cim.sdk.android.logger.CIMLogger;
import com.farsunset.cim.sdk.android.model.Pong;
import com.farsunset.cim.sdk.android.model.SentBody;
import java.util.concurrent.atomic.AtomicBoolean;

public class CIMPushService
extends Service {
    static final String KEY_SEND_BODY = "KEY_SEND_BODY";
    static final String KEY_DELAYED_TIME = "KEY_DELAYED_TIME";
    static final String KEY_LOGGER_ENABLE = "KEY_LOGGER_ENABLE";
    static final String KEY_NOTIFICATION_MESSAGE = "KEY_NOTIFICATION_MESSAGE";
    static final String KEY_NOTIFICATION_CHANNEL = "KEY_NOTIFICATION_CHANNEL";
    static final String KEY_NOTIFICATION_ICON = "KEY_NOTIFICATION_ICON";
    private static final String TRANSIENT_NTC_CHANNEL_ID = "CIM_PUSH_TRANSIENT_NTC_ID";
    private static final String PERSIST_NTC_CHANNEL_ID = "CIM_PUSH_PERSIST_NTC_ID";
    private static final int NOTIFICATION_ID = Integer.MAX_VALUE;
    private static final int PERSIST_NOTIFICATION_ID = Integer.MIN_VALUE;
    private CIMConnectorManager connectorManager;
    private KeepAliveBroadcastReceiver keepAliveReceiver;
    private ConnectivityManager connectivityManager;
    private NotificationManager notificationManager;
    private final AtomicBoolean persistHolder = new AtomicBoolean(false);
    private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(Network network) {
            Intent intent = new Intent();
            intent.setPackage(CIMPushService.this.getPackageName());
            intent.setAction("com.farsunset.cim.NETWORK_CHANGED");
            CIMPushService.this.sendBroadcast(intent);
        }

        public void onUnavailable() {
            Intent intent = new Intent();
            intent.setPackage(CIMPushService.this.getPackageName());
            intent.setAction("com.farsunset.cim.NETWORK_CHANGED");
            CIMPushService.this.sendBroadcast(intent);
        }
    };
    private final Handler connectHandler = new Handler(){

        public void handleMessage(Message message) {
            CIMPushService.this.prepareConnect();
        }
    };
    private final Handler notificationHandler = new Handler(){

        public void handleMessage(Message message) {
            if (CIMPushService.this.persistHolder.get()) {
                return;
            }
            CIMPushService.this.stopForeground(true);
        }
    };

    public void onCreate() {
        this.connectorManager = CIMConnectorManager.getManager(this.getApplicationContext());
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            this.keepAliveReceiver = new KeepAliveBroadcastReceiver();
            this.registerReceiver(this.keepAliveReceiver, this.keepAliveReceiver.getIntentFilter());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.connectivityManager = (ConnectivityManager)this.getSystemService(ConnectivityManager.class);
            this.connectivityManager.registerDefaultNetworkCallback(this.networkCallback);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String action;
        String string = action = intent == null ? "ACTION_ACTIVATE_PUSH_SERVICE" : intent.getAction();
        if (!this.persistHolder.get()) {
            this.createNotification();
        }
        if ("ACTION_CREATE_CIM_CONNECTION".equals(action)) {
            this.prepareConnect(intent.getLongExtra(KEY_DELAYED_TIME, 0L));
        }
        if ("ACTION_SEND_REQUEST_BODY".equals(action)) {
            this.connectorManager.send((SentBody)intent.getSerializableExtra(KEY_SEND_BODY));
        }
        if ("ACTION_CLOSE_CIM_CONNECTION".equals(action)) {
            this.connectorManager.close();
        }
        if ("ACTION_ACTIVATE_PUSH_SERVICE".equals(action)) {
            this.handleKeepAlive();
        }
        if ("ACTION_DESTROY_CIM_SERVICE".equals(action)) {
            this.connectorManager.close();
            this.stopSelf();
        }
        if ("ACTION_CIM_CONNECTION_PONG".equals(action)) {
            this.connectorManager.send(Pong.getInstance());
        }
        if ("ACTION_SET_LOGGER_EATABLE".equals(action)) {
            boolean enable = intent.getBooleanExtra(KEY_LOGGER_ENABLE, true);
            CIMLogger.getLogger().debugMode(enable);
        }
        if ("ACTION_SHOW_PERSIST_NOTIFICATION".equals(action)) {
            this.createPersistNotification(intent.getStringExtra(KEY_NOTIFICATION_CHANNEL), intent.getStringExtra(KEY_NOTIFICATION_MESSAGE), intent.getIntExtra(KEY_NOTIFICATION_ICON, 0));
            this.persistHolder.set(true);
        }
        if ("ACTION_HIDE_PERSIST_NOTIFICATION".equals(action)) {
            this.stopForeground(true);
            this.persistHolder.set(false);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.notificationHandler.sendEmptyMessageDelayed(0, 200L);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void prepareConnect(long delayMillis) {
        if (delayMillis <= 0L) {
            this.prepareConnect();
            return;
        }
        this.connectHandler.sendEmptyMessageDelayed(0, delayMillis);
    }

    private void prepareConnect() {
        if (CIMPushManager.isDestroyed((Context)this) || CIMPushManager.isStopped((Context)this)) {
            return;
        }
        String host = CIMCacheManager.getString((Context)this, "KEY_CIM_SERVER_HOST");
        int port = CIMCacheManager.getInt((Context)this, "KEY_CIM_SERVER_PORT");
        if (host == null || host.trim().length() == 0 || port <= 0) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Invalid hostname or port. host:" + host + " port:" + port));
            return;
        }
        this.connectorManager.connect(host, port);
    }

    private void handleKeepAlive() {
        CIMLogger.getLogger().connectState(true, CIMPushManager.isStopped((Context)this), CIMPushManager.isDestroyed((Context)this));
        if (this.connectorManager.isConnected()) {
            this.connectorManager.sendHeartbeat();
            return;
        }
        this.prepareConnect();
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onDestroy() {
        super.onDestroy();
        this.release();
    }

    private void release() {
        this.connectHandler.removeMessages(0);
        this.stopForeground(true);
        this.persistHolder.set(false);
        if (Build.VERSION.SDK_INT >= 26) {
            this.unregisterReceiver(this.keepAliveReceiver);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.connectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
    }

    private void createNotification() {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (this.notificationManager.getNotificationChannel(TRANSIENT_NTC_CHANNEL_ID) == null) {
            NotificationChannel channel = new NotificationChannel(TRANSIENT_NTC_CHANNEL_ID, (CharSequence)((Object)((Object)this)).getClass().getSimpleName(), 2);
            channel.enableLights(false);
            channel.enableVibration(false);
            channel.setSound(null, null);
            this.notificationManager.createNotificationChannel(channel);
        }
        Notification notification = new Notification.Builder((Context)this, TRANSIENT_NTC_CHANNEL_ID).setContentTitle((CharSequence)CIMPushService.class.getSimpleName()).build();
        this.startForeground(Integer.MAX_VALUE, notification);
    }

    private void createPersistNotification(String channelName, String message, int icon) {
        if (Build.VERSION.SDK_INT >= 26 && this.notificationManager.getNotificationChannel(PERSIST_NTC_CHANNEL_ID) == null) {
            NotificationChannel channel = new NotificationChannel(PERSIST_NTC_CHANNEL_ID, (CharSequence)channelName, 3);
            channel.enableLights(false);
            channel.setShowBadge(false);
            channel.enableVibration(false);
            channel.setSound(null, null);
            this.notificationManager.createNotificationChannel(channel);
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setPackage(this.getPackageName());
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder((Context)this, PERSIST_NTC_CHANNEL_ID) : new Notification.Builder((Context)this);
        builder.setAutoCancel(false).setOngoing(false).setSmallIcon(icon).setWhen(System.currentTimeMillis()).setContentIntent(PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0)).setContentTitle((CharSequence)channelName).setContentText((CharSequence)message);
        this.startForeground(Integer.MIN_VALUE, builder.build());
    }

    private class KeepAliveBroadcastReceiver
    extends BroadcastReceiver {
        private KeepAliveBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            CIMPushService.this.handleKeepAlive();
        }

        public IntentFilter getIntentFilter() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
            intentFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            return intentFilter;
        }
    }
}

