/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android.coder;

import com.farsunset.cim.sdk.android.model.Message;
import com.farsunset.cim.sdk.android.model.Ping;
import com.farsunset.cim.sdk.android.model.ReplyBody;
import com.farsunset.cim.sdk.android.model.proto.MessageProto;
import com.farsunset.cim.sdk.android.model.proto.ReplyBodyProto;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ClientMessageDecoder {
    public Object doDecode(ByteBuffer headerBuffer, SocketChannel socketChannel) throws IOException {
        headerBuffer.position(0);
        byte type = headerBuffer.get();
        byte lv = headerBuffer.get();
        byte hv = headerBuffer.get();
        headerBuffer.clear();
        int dataLength = this.getContentLength(lv, hv);
        ByteBuffer bodyBuffer = ByteBuffer.allocate(dataLength);
        do {
            socketChannel.read(bodyBuffer);
        } while (bodyBuffer.position() != dataLength);
        if (1 == type) {
            return Ping.getInstance();
        }
        if (4 == type) {
            ReplyBodyProto.Model bodyProto = ReplyBodyProto.Model.parseFrom(bodyBuffer.array());
            ReplyBody body = new ReplyBody();
            body.setKey(bodyProto.getKey());
            body.setTimestamp(bodyProto.getTimestamp());
            body.putAll(bodyProto.getDataMap());
            body.setCode(bodyProto.getCode());
            body.setMessage(bodyProto.getMessage());
            return body;
        }
        MessageProto.Model bodyProto = MessageProto.Model.parseFrom(bodyBuffer.array());
        Message message = new Message();
        message.setId(bodyProto.getId());
        message.setAction(bodyProto.getAction());
        message.setContent(bodyProto.getContent());
        message.setSender(bodyProto.getSender());
        message.setReceiver(bodyProto.getReceiver());
        message.setTitle(bodyProto.getTitle());
        message.setExtra(bodyProto.getExtra());
        message.setTimestamp(bodyProto.getTimestamp());
        message.setFormat(bodyProto.getFormat());
        return message;
    }

    private int getContentLength(byte lv, byte hv) {
        int l = lv & 0xFF;
        int h = hv & 0xFF;
        return l | h << 8;
    }
}

