/*
 * Decompiled with CFR 0.152.
 */
package com.farsunset.cim.sdk.android.logger;

import android.util.Log;
import java.nio.channels.SocketChannel;

public class CIMLogger {
    private static final String TAG = "CIM";
    private boolean debug = true;

    public static CIMLogger getLogger() {
        return LoggerHolder.logger;
    }

    private CIMLogger() {
    }

    public void debugMode(boolean mode) {
        this.debug = mode;
    }

    public void messageReceived(SocketChannel session, Object message) {
        if (this.debug) {
            Log.i((String)TAG, (String)("[RECEIVED]" + this.getSessionInfo(session) + "\n" + message));
        }
    }

    public void messageSent(SocketChannel session, Object message) {
        if (this.debug) {
            Log.i((String)TAG, (String)("[  SENT  ]" + this.getSessionInfo(session) + "\n" + message));
        }
    }

    public void sessionCreated(SocketChannel session) {
        if (this.debug) {
            Log.i((String)TAG, (String)("[ OPENED ]" + this.getSessionInfo(session)));
        }
    }

    public void sessionIdle(SocketChannel session) {
        if (this.debug) {
            Log.d((String)TAG, (String)("[  IDLE  ]" + this.getSessionInfo(session)));
        }
    }

    public void sessionClosed(SocketChannel session) {
        if (this.debug) {
            Log.w((String)TAG, (String)("[ CLOSED ] ID = " + session.hashCode()));
        }
    }

    public void connectFailure(long interval) {
        if (this.debug) {
            Log.d((String)TAG, (String)("CONNECT FAILURE, TRY RECONNECT AFTER " + interval + "ms"));
        }
    }

    public void startConnect(String host, int port) {
        if (this.debug) {
            Log.i((String)TAG, (String)("START CONNECT REMOTE HOST:" + host + " PORT:" + port));
        }
    }

    public void invalidHostPort(String host, int port) {
        if (this.debug) {
            Log.d((String)TAG, (String)("INVALID SOCKET ADDRESS -> HOST:" + host + " PORT:" + port));
        }
    }

    public void connectState(boolean isConnected, boolean isManualStop, boolean isDestroyed) {
        if (this.debug) {
            Log.d((String)TAG, (String)("CONNECTED:" + isConnected + " STOPPED:" + isManualStop + " DESTROYED:" + isDestroyed));
        }
    }

    private String getSessionInfo(SocketChannel session) {
        StringBuilder builder = new StringBuilder();
        if (session == null) {
            return "";
        }
        builder.append(" [");
        builder.append("id:").append(session.hashCode());
        try {
            if (session.socket().getLocalAddress() != null) {
                builder.append(" L:").append(session.socket().getLocalAddress()).append(":").append(session.socket().getLocalPort());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (session.socket().getRemoteSocketAddress() != null) {
                builder.append(" R:").append(session.socket().getRemoteSocketAddress().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.append("]");
        return builder.toString();
    }

    private static class LoggerHolder {
        private static final CIMLogger logger = new CIMLogger();

        private LoggerHolder() {
        }
    }
}

