/**
 * 微氏手机网站编辑器
 * 更多产品或新版请访问官方网站 https://www.weisns.net/
 * 意见或建议联系QQ：613961369
 */
$(function() {
    // 配置编辑器以及初始化编辑器内容
    var initContent = '微氏手机网站编辑器<br> 更多产品或新版请访问官方网站：<a href="" style="color:green">www.weisns.net</a><br>意见或建议联系QQ：613961369<br><span style="font-size:20px;font-weight:600;color:red">免费 高效</span>';
    var ue = UE.getEditor('editor', {
        initialFrameWidth: 500,
        initialFrameHeight: 738,
        zIndex: 0,
        toolbars: [
            [
                'fullscreen', 'source', '|',
                'undo', 'redo', '|',
                "lineheight", "rowspacingtop", "rowspacingbottom", "|",
                "formatmatch", "removeformat", "|",
                "indent", "justifyjustify", "justifyleft", "justifycenter", "justifyright", "|",
                "subscript", "superscript", "|", "link", "blockquote", "spechars", "|",
                "forecolor", "strikethrough", "fontborder", "underline", "italic", "bold", "fontfamily", "fontsize", "|","simpleupload",
                 "pasteplain", "drafts", "cleardrafts"
            ]
        ],
        autoHeightEnabled: false,
        autoFloatEnabled: true,
        topOffset: 1,
        toolbarTopOffset: 1,
        initialContent: initContent,
        focus: false,
        autoClearinitialContent: false,
        saveInterval: 2000
    });
    //点选内容 
    $(".itembox").live("mousedown", function() {
        var x = ue.selection.getStart();
        var html = $(this).html();
        if (ue.getContent() == "") {
            ue.setContent(html + "<p><br/></p>");
        } else {
            if (ue.isFocus()) {
                ue.execCommand('insertHtml', "<p><br/></p>" + html + "<p><br/></p>");
            } else {
                ue.setContent("<p><br/></p>" + html + "<p><br/></p>", true);
            }
        }
    });
    // 右侧菜单鼠标悬浮提示  
    $(".tip-hotspot").ggtooltip({
        "bordercolor": "#fff"
    });
    //右侧菜单hover事件
    $(".rightMenu a").hover(function() {
        var cName = $(this).attr("rev");
        if (cName == "mobile") {
            $(this).children().eq(0).removeClass("fa-" + cName).removeClass("fa-2x").css("width", "35px");
        } else {
            $(this).children().eq(0).removeClass("fa-" + cName).removeClass("fa-1-5x").css("width", "35px");
        }
    }, function() {
        $(this).removeAttr("style");
        var cName = $(this).attr("rev");
        if (cName == "mobile") {
            $(this).children().eq(0).addClass("fa-" + cName).addClass("fa-2x").css("width", "");
        } else {
            $(this).children().eq(0).addClass("fa-" + cName).addClass("fa-1-5x").css("width", "");
        }
    });
    //复制按钮
    if (ZeroClipboard) {
        ZeroClipboard.config({
            swfPath: "../../ueditor/third-party/zeroclipboard/ZeroClipboard.swf"
        });
        var clip = new ZeroClipboard($('.copy-editor-html'));
        clip.on('ready', function() {
            this.on('copy', function(event) {
                var html = ue.getContent();
                var b = $(document.getElementById("ueditor_0").contentWindow.document.body);
                b = b.html();
                ue.setContent(html);
                ZeroClipboard.setData('text/html', b.replace("current", ""));
                ZeroClipboard.setData('text/plain', b.replace("current", ""));
            });
            this.on('aftercopy', function(event) {
                if (ue.getContent().length == 0) {
                    disapperTooltip("remind", "未复制任何内容，请确保编辑器内有内容");
                } else {
                    disapperTooltip("remind", "正文内容已经复制到剪切板，请粘贴(CTRL+V)使用！");
                }
            });
        });
        clip.on("error", function(event) {
            //disapperTooltip("remind", "复制按钮失效，建议使用360浏览器极速模式，可以防止此错误！");
            ZeroClipboard.destroy();
        });
    }
    // 清空
    $(".clear-editor").click(function() {
        if (ue.getContent().length > 0) {
            ue.setContent('');
            disapperTooltip("remind", "内容已清空。");
        }
    });
    $(document).bind('click', function() {
        $(".dropdown-menu").removeClass("open");
    });
    $(".templateBox span").click(function(event) {
        $(".templateBox .dropdown span").removeClass("current");
        $(this).addClass("current");
        var tab = $(this).data("id"); //模版id
        if (!tab) { return; }
        $.ajax({
            url: "http://edit.weisns.net/index.php?m=Admin&c=editor&a=w_ajax_category_list&type_id=" + tab + "",  //规定发送请求的 URL。默认是当前页面。
            contentType: "application/json",
            type: "GET", //规定请求的类型（GET 或 POST）。
            dataType:"JSONP",  //预期的服务器响应的数据类型。
            json:"callback",  //在一个 jsonp 中重写回调函数的字符串。
            beforeSend: function () {
                $(".tab_con > .content").removeAttr("style").html('<div class="loading"><i class="fa fa-fw fa-spinner fa-pulse"></i><span>数据加载中</span></div>');
            },
            success: function(data) {  //请求成功后返回
                var getHtml = '';
                $.each(data.data, function(index, val) {
                    getHtml += '<li class="elasticScale" id="" title=""><div class="itembox">' + val.content + '</div></li>';
                });
                $(".tab_con > .content").html(getHtml);
                $(".selectBox").scrollTop(0);
            },
            error: function() {  //请求失败后返回
                console.log('s');
                var errHTML = '<div class="error"><i class="fa fa-fw fa-exclamation-triangle text-danger"></i><span>数据获取失败</span></div>';
                $(".tab_con > .content").removeAttr("style").html(errHTML);
            }, complete: function () {
                $(".selectBox").scrollTop(0);
                $(".selectBox > .loading").hide();
            }
        });
    });
    // 保存
    $("#J_push").click(function(e){
        $('#JContent').val(ue.getContent());
        var titValue = $.trim($('#JTitle').val()), conValue = $('#JContent').val();
        if (!titValue) { alert('请填写标题'); return false; }
        if (!conValue) { alert('请填写内容'); return false; }
        alert(titValue);
        alert(conValue);
        
        // 提交方式->表单提交
        /*$('#saveForm').submit(function(event) {
            
        });*/


        // 提交方式->ajax提交
        /*var postData = $('#saveForm').serialize();
        $.ajax({
            url: '/path/to/file',
            type: 'default GET (Other values: POST)',
            dataType: 'default: Intelligent Guess (Other values: xml, json, script, or html)',
            data: postData,
        })
        .done(function() {
            console.log("success");
        })
        .fail(function() {
            console.log("error");
        })
        .always(function() {
            console.log("complete");
        });*/


    });
})