---
order: 99
title:
  en-US: Fixed header and scroll bar with the page
  zh-CN: 随页面滚动的固定表头和滚动条
---

## zh-CN

对于长表格，需要滚动才能查看表头和滚动条，那么现在可以设置跟随页面固定表头和滚动条。

## en-US

For long table，need to scroll to view the header and scroll bar，then you can now set the fixed header and scroll bar to follow the page.

```jsx
import { Table } from 'antd';

const columns = [
  {
    title: 'Full Name',
    width: 100,
    dataIndex: 'name',
    key: 'name',
    fixed: 'left',
  },
  {
    title: 'Age',
    width: 100,
    dataIndex: 'age',
    key: 'age',
    fixed: 'left',
  },
  {
    title: 'Column 1',
    dataIndex: 'address',
    key: '1',
    width: 150,
  },
  {
    title: 'Column 2',
    dataIndex: 'address',
    key: '2',
    width: 150,
  },
  {
    title: 'Column 3',
    dataIndex: 'address',
    key: '3',
    width: 150,
  },
  {
    title: 'Column 4',
    dataIndex: 'address',
    key: '4',
    width: 150,
  },
  {
    title: 'Column 5',
    dataIndex: 'address',
    key: '5',
    width: 150,
  },
  {
    title: 'Column 6',
    dataIndex: 'address',
    key: '6',
    width: 150,
  },
  {
    title: 'Column 7',
    dataIndex: 'address',
    key: '7',
    width: 150,
  },
  { title: 'Column 8', dataIndex: 'address', key: '8' },
  {
    title: 'Action',
    key: 'operation',
    fixed: 'right',
    width: 100,
    render: () => <a>action</a>,
  },
];

const data = [];
for (let i = 0; i < 100; i++) {
  data.push({
    key: i,
    name: `Edrward ${i}`,
    age: 32,
    address: `London Park no. ${i}`,
  });
}

ReactDOM.render(
  <Table
    columns={columns}
    dataSource={data}
    scroll={{ x: 1500 }}
    summary={pageData => (
      <Table.Summary fixed>
        <Table.Summary.Row>
          <Table.Summary.Cell index={0} colSpan={2}>
            Fix Left
          </Table.Summary.Cell>
          <Table.Summary.Cell index={2} colSpan={8}>
            Scroll Context
          </Table.Summary.Cell>
          <Table.Summary.Cell index={10}>Fix Right</Table.Summary.Cell>
        </Table.Summary.Row>
      </Table.Summary>
    )}
    sticky
  />,
  mountNode,
);
```
