/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/generic"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type AuthTokenHandler func(string, *v3.AuthToken) (*v3.AuthToken, error)

type AuthTokenController interface {
	generic.ControllerMeta
	AuthTokenClient

	OnChange(ctx context.Context, name string, sync AuthTokenHandler)
	OnRemove(ctx context.Context, name string, sync AuthTokenHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() AuthTokenCache
}

type AuthTokenClient interface {
	Create(*v3.AuthToken) (*v3.AuthToken, error)
	Update(*v3.AuthToken) (*v3.AuthToken, error)

	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v3.AuthToken, error)
	List(opts metav1.ListOptions) (*v3.AuthTokenList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.AuthToken, err error)
}

type AuthTokenCache interface {
	Get(name string) (*v3.AuthToken, error)
	List(selector labels.Selector) ([]*v3.AuthToken, error)

	AddIndexer(indexName string, indexer AuthTokenIndexer)
	GetByIndex(indexName, key string) ([]*v3.AuthToken, error)
}

type AuthTokenIndexer func(obj *v3.AuthToken) ([]string, error)

type authTokenController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewAuthTokenController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) AuthTokenController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &authTokenController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromAuthTokenHandlerToHandler(sync AuthTokenHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.AuthToken
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.AuthToken))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *authTokenController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.AuthToken))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateAuthTokenDeepCopyOnChange(client AuthTokenClient, obj *v3.AuthToken, handler func(obj *v3.AuthToken) (*v3.AuthToken, error)) (*v3.AuthToken, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *authTokenController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *authTokenController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *authTokenController) OnChange(ctx context.Context, name string, sync AuthTokenHandler) {
	c.AddGenericHandler(ctx, name, FromAuthTokenHandlerToHandler(sync))
}

func (c *authTokenController) OnRemove(ctx context.Context, name string, sync AuthTokenHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromAuthTokenHandlerToHandler(sync)))
}

func (c *authTokenController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *authTokenController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *authTokenController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *authTokenController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *authTokenController) Cache() AuthTokenCache {
	return &authTokenCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *authTokenController) Create(obj *v3.AuthToken) (*v3.AuthToken, error) {
	result := &v3.AuthToken{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *authTokenController) Update(obj *v3.AuthToken) (*v3.AuthToken, error) {
	result := &v3.AuthToken{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *authTokenController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *authTokenController) Get(name string, options metav1.GetOptions) (*v3.AuthToken, error) {
	result := &v3.AuthToken{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *authTokenController) List(opts metav1.ListOptions) (*v3.AuthTokenList, error) {
	result := &v3.AuthTokenList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *authTokenController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *authTokenController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v3.AuthToken, error) {
	result := &v3.AuthToken{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type authTokenCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *authTokenCache) Get(name string) (*v3.AuthToken, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.AuthToken), nil
}

func (c *authTokenCache) List(selector labels.Selector) (ret []*v3.AuthToken, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.AuthToken))
	})

	return ret, err
}

func (c *authTokenCache) AddIndexer(indexName string, indexer AuthTokenIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.AuthToken))
		},
	}))
}

func (c *authTokenCache) GetByIndex(indexName, key string) (result []*v3.AuthToken, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.AuthToken, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.AuthToken))
	}
	return result, nil
}
