/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/apply"
	"github.com/rancher/wrangler/pkg/condition"
	"github.com/rancher/wrangler/pkg/generic"
	"github.com/rancher/wrangler/pkg/kv"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type FleetWorkspaceHandler func(string, *v3.FleetWorkspace) (*v3.FleetWorkspace, error)

type FleetWorkspaceController interface {
	generic.ControllerMeta
	FleetWorkspaceClient

	OnChange(ctx context.Context, name string, sync FleetWorkspaceHandler)
	OnRemove(ctx context.Context, name string, sync FleetWorkspaceHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() FleetWorkspaceCache
}

type FleetWorkspaceClient interface {
	Create(*v3.FleetWorkspace) (*v3.FleetWorkspace, error)
	Update(*v3.FleetWorkspace) (*v3.FleetWorkspace, error)
	UpdateStatus(*v3.FleetWorkspace) (*v3.FleetWorkspace, error)
	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v3.FleetWorkspace, error)
	List(opts metav1.ListOptions) (*v3.FleetWorkspaceList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.FleetWorkspace, err error)
}

type FleetWorkspaceCache interface {
	Get(name string) (*v3.FleetWorkspace, error)
	List(selector labels.Selector) ([]*v3.FleetWorkspace, error)

	AddIndexer(indexName string, indexer FleetWorkspaceIndexer)
	GetByIndex(indexName, key string) ([]*v3.FleetWorkspace, error)
}

type FleetWorkspaceIndexer func(obj *v3.FleetWorkspace) ([]string, error)

type fleetWorkspaceController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewFleetWorkspaceController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) FleetWorkspaceController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &fleetWorkspaceController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromFleetWorkspaceHandlerToHandler(sync FleetWorkspaceHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.FleetWorkspace
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.FleetWorkspace))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *fleetWorkspaceController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.FleetWorkspace))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateFleetWorkspaceDeepCopyOnChange(client FleetWorkspaceClient, obj *v3.FleetWorkspace, handler func(obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error)) (*v3.FleetWorkspace, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *fleetWorkspaceController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *fleetWorkspaceController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *fleetWorkspaceController) OnChange(ctx context.Context, name string, sync FleetWorkspaceHandler) {
	c.AddGenericHandler(ctx, name, FromFleetWorkspaceHandlerToHandler(sync))
}

func (c *fleetWorkspaceController) OnRemove(ctx context.Context, name string, sync FleetWorkspaceHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromFleetWorkspaceHandlerToHandler(sync)))
}

func (c *fleetWorkspaceController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *fleetWorkspaceController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *fleetWorkspaceController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *fleetWorkspaceController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *fleetWorkspaceController) Cache() FleetWorkspaceCache {
	return &fleetWorkspaceCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *fleetWorkspaceController) Create(obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	result := &v3.FleetWorkspace{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *fleetWorkspaceController) Update(obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	result := &v3.FleetWorkspace{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *fleetWorkspaceController) UpdateStatus(obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	result := &v3.FleetWorkspace{}
	return result, c.client.UpdateStatus(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *fleetWorkspaceController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *fleetWorkspaceController) Get(name string, options metav1.GetOptions) (*v3.FleetWorkspace, error) {
	result := &v3.FleetWorkspace{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *fleetWorkspaceController) List(opts metav1.ListOptions) (*v3.FleetWorkspaceList, error) {
	result := &v3.FleetWorkspaceList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *fleetWorkspaceController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *fleetWorkspaceController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v3.FleetWorkspace, error) {
	result := &v3.FleetWorkspace{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type fleetWorkspaceCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *fleetWorkspaceCache) Get(name string) (*v3.FleetWorkspace, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.FleetWorkspace), nil
}

func (c *fleetWorkspaceCache) List(selector labels.Selector) (ret []*v3.FleetWorkspace, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.FleetWorkspace))
	})

	return ret, err
}

func (c *fleetWorkspaceCache) AddIndexer(indexName string, indexer FleetWorkspaceIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.FleetWorkspace))
		},
	}))
}

func (c *fleetWorkspaceCache) GetByIndex(indexName, key string) (result []*v3.FleetWorkspace, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.FleetWorkspace, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.FleetWorkspace))
	}
	return result, nil
}

type FleetWorkspaceStatusHandler func(obj *v3.FleetWorkspace, status v3.FleetWorkspaceStatus) (v3.FleetWorkspaceStatus, error)

type FleetWorkspaceGeneratingHandler func(obj *v3.FleetWorkspace, status v3.FleetWorkspaceStatus) ([]runtime.Object, v3.FleetWorkspaceStatus, error)

func RegisterFleetWorkspaceStatusHandler(ctx context.Context, controller FleetWorkspaceController, condition condition.Cond, name string, handler FleetWorkspaceStatusHandler) {
	statusHandler := &fleetWorkspaceStatusHandler{
		client:    controller,
		condition: condition,
		handler:   handler,
	}
	controller.AddGenericHandler(ctx, name, FromFleetWorkspaceHandlerToHandler(statusHandler.sync))
}

func RegisterFleetWorkspaceGeneratingHandler(ctx context.Context, controller FleetWorkspaceController, apply apply.Apply,
	condition condition.Cond, name string, handler FleetWorkspaceGeneratingHandler, opts *generic.GeneratingHandlerOptions) {
	statusHandler := &fleetWorkspaceGeneratingHandler{
		FleetWorkspaceGeneratingHandler: handler,
		apply:                           apply,
		name:                            name,
		gvk:                             controller.GroupVersionKind(),
	}
	if opts != nil {
		statusHandler.opts = *opts
	}
	controller.OnChange(ctx, name, statusHandler.Remove)
	RegisterFleetWorkspaceStatusHandler(ctx, controller, condition, name, statusHandler.Handle)
}

type fleetWorkspaceStatusHandler struct {
	client    FleetWorkspaceClient
	condition condition.Cond
	handler   FleetWorkspaceStatusHandler
}

func (a *fleetWorkspaceStatusHandler) sync(key string, obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	if obj == nil {
		return obj, nil
	}

	origStatus := obj.Status.DeepCopy()
	obj = obj.DeepCopy()
	newStatus, err := a.handler(obj, obj.Status)
	if err != nil {
		// Revert to old status on error
		newStatus = *origStatus.DeepCopy()
	}

	if a.condition != "" {
		if errors.IsConflict(err) {
			a.condition.SetError(&newStatus, "", nil)
		} else {
			a.condition.SetError(&newStatus, "", err)
		}
	}
	if !equality.Semantic.DeepEqual(origStatus, &newStatus) {
		if a.condition != "" {
			// Since status has changed, update the lastUpdatedTime
			a.condition.LastUpdated(&newStatus, time.Now().UTC().Format(time.RFC3339))
		}

		var newErr error
		obj.Status = newStatus
		newObj, newErr := a.client.UpdateStatus(obj)
		if err == nil {
			err = newErr
		}
		if newErr == nil {
			obj = newObj
		}
	}
	return obj, err
}

type fleetWorkspaceGeneratingHandler struct {
	FleetWorkspaceGeneratingHandler
	apply apply.Apply
	opts  generic.GeneratingHandlerOptions
	gvk   schema.GroupVersionKind
	name  string
}

func (a *fleetWorkspaceGeneratingHandler) Remove(key string, obj *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	if obj != nil {
		return obj, nil
	}

	obj = &v3.FleetWorkspace{}
	obj.Namespace, obj.Name = kv.RSplit(key, "/")
	obj.SetGroupVersionKind(a.gvk)

	return nil, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects()
}

func (a *fleetWorkspaceGeneratingHandler) Handle(obj *v3.FleetWorkspace, status v3.FleetWorkspaceStatus) (v3.FleetWorkspaceStatus, error) {
	objs, newStatus, err := a.FleetWorkspaceGeneratingHandler(obj, status)
	if err != nil {
		return newStatus, err
	}

	return newStatus, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects(objs...)
}
