/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/generic"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type GlobalRoleHandler func(string, *v3.GlobalRole) (*v3.GlobalRole, error)

type GlobalRoleController interface {
	generic.ControllerMeta
	GlobalRoleClient

	OnChange(ctx context.Context, name string, sync GlobalRoleHandler)
	OnRemove(ctx context.Context, name string, sync GlobalRoleHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() GlobalRoleCache
}

type GlobalRoleClient interface {
	Create(*v3.GlobalRole) (*v3.GlobalRole, error)
	Update(*v3.GlobalRole) (*v3.GlobalRole, error)

	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v3.GlobalRole, error)
	List(opts metav1.ListOptions) (*v3.GlobalRoleList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.GlobalRole, err error)
}

type GlobalRoleCache interface {
	Get(name string) (*v3.GlobalRole, error)
	List(selector labels.Selector) ([]*v3.GlobalRole, error)

	AddIndexer(indexName string, indexer GlobalRoleIndexer)
	GetByIndex(indexName, key string) ([]*v3.GlobalRole, error)
}

type GlobalRoleIndexer func(obj *v3.GlobalRole) ([]string, error)

type globalRoleController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewGlobalRoleController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) GlobalRoleController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &globalRoleController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromGlobalRoleHandlerToHandler(sync GlobalRoleHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.GlobalRole
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.GlobalRole))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *globalRoleController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.GlobalRole))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateGlobalRoleDeepCopyOnChange(client GlobalRoleClient, obj *v3.GlobalRole, handler func(obj *v3.GlobalRole) (*v3.GlobalRole, error)) (*v3.GlobalRole, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *globalRoleController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *globalRoleController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *globalRoleController) OnChange(ctx context.Context, name string, sync GlobalRoleHandler) {
	c.AddGenericHandler(ctx, name, FromGlobalRoleHandlerToHandler(sync))
}

func (c *globalRoleController) OnRemove(ctx context.Context, name string, sync GlobalRoleHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromGlobalRoleHandlerToHandler(sync)))
}

func (c *globalRoleController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *globalRoleController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *globalRoleController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *globalRoleController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *globalRoleController) Cache() GlobalRoleCache {
	return &globalRoleCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *globalRoleController) Create(obj *v3.GlobalRole) (*v3.GlobalRole, error) {
	result := &v3.GlobalRole{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *globalRoleController) Update(obj *v3.GlobalRole) (*v3.GlobalRole, error) {
	result := &v3.GlobalRole{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *globalRoleController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *globalRoleController) Get(name string, options metav1.GetOptions) (*v3.GlobalRole, error) {
	result := &v3.GlobalRole{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *globalRoleController) List(opts metav1.ListOptions) (*v3.GlobalRoleList, error) {
	result := &v3.GlobalRoleList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *globalRoleController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *globalRoleController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v3.GlobalRole, error) {
	result := &v3.GlobalRole{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type globalRoleCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *globalRoleCache) Get(name string) (*v3.GlobalRole, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.GlobalRole), nil
}

func (c *globalRoleCache) List(selector labels.Selector) (ret []*v3.GlobalRole, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.GlobalRole))
	})

	return ret, err
}

func (c *globalRoleCache) AddIndexer(indexName string, indexer GlobalRoleIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.GlobalRole))
		},
	}))
}

func (c *globalRoleCache) GetByIndex(indexName, key string) (result []*v3.GlobalRole, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.GlobalRole, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.GlobalRole))
	}
	return result, nil
}
