/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/generic"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type GlobalRoleBindingHandler func(string, *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)

type GlobalRoleBindingController interface {
	generic.ControllerMeta
	GlobalRoleBindingClient

	OnChange(ctx context.Context, name string, sync GlobalRoleBindingHandler)
	OnRemove(ctx context.Context, name string, sync GlobalRoleBindingHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() GlobalRoleBindingCache
}

type GlobalRoleBindingClient interface {
	Create(*v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)
	Update(*v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)

	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v3.GlobalRoleBinding, error)
	List(opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.GlobalRoleBinding, err error)
}

type GlobalRoleBindingCache interface {
	Get(name string) (*v3.GlobalRoleBinding, error)
	List(selector labels.Selector) ([]*v3.GlobalRoleBinding, error)

	AddIndexer(indexName string, indexer GlobalRoleBindingIndexer)
	GetByIndex(indexName, key string) ([]*v3.GlobalRoleBinding, error)
}

type GlobalRoleBindingIndexer func(obj *v3.GlobalRoleBinding) ([]string, error)

type globalRoleBindingController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewGlobalRoleBindingController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) GlobalRoleBindingController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &globalRoleBindingController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromGlobalRoleBindingHandlerToHandler(sync GlobalRoleBindingHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.GlobalRoleBinding
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.GlobalRoleBinding))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *globalRoleBindingController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.GlobalRoleBinding))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateGlobalRoleBindingDeepCopyOnChange(client GlobalRoleBindingClient, obj *v3.GlobalRoleBinding, handler func(obj *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)) (*v3.GlobalRoleBinding, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *globalRoleBindingController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *globalRoleBindingController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *globalRoleBindingController) OnChange(ctx context.Context, name string, sync GlobalRoleBindingHandler) {
	c.AddGenericHandler(ctx, name, FromGlobalRoleBindingHandlerToHandler(sync))
}

func (c *globalRoleBindingController) OnRemove(ctx context.Context, name string, sync GlobalRoleBindingHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromGlobalRoleBindingHandlerToHandler(sync)))
}

func (c *globalRoleBindingController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *globalRoleBindingController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *globalRoleBindingController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *globalRoleBindingController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *globalRoleBindingController) Cache() GlobalRoleBindingCache {
	return &globalRoleBindingCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *globalRoleBindingController) Create(obj *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
	result := &v3.GlobalRoleBinding{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *globalRoleBindingController) Update(obj *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
	result := &v3.GlobalRoleBinding{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *globalRoleBindingController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *globalRoleBindingController) Get(name string, options metav1.GetOptions) (*v3.GlobalRoleBinding, error) {
	result := &v3.GlobalRoleBinding{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *globalRoleBindingController) List(opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error) {
	result := &v3.GlobalRoleBindingList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *globalRoleBindingController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *globalRoleBindingController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v3.GlobalRoleBinding, error) {
	result := &v3.GlobalRoleBinding{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type globalRoleBindingCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *globalRoleBindingCache) Get(name string) (*v3.GlobalRoleBinding, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.GlobalRoleBinding), nil
}

func (c *globalRoleBindingCache) List(selector labels.Selector) (ret []*v3.GlobalRoleBinding, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.GlobalRoleBinding))
	})

	return ret, err
}

func (c *globalRoleBindingCache) AddIndexer(indexName string, indexer GlobalRoleBindingIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.GlobalRoleBinding))
		},
	}))
}

func (c *globalRoleBindingCache) GetByIndex(indexName, key string) (result []*v3.GlobalRoleBinding, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.GlobalRoleBinding, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.GlobalRoleBinding))
	}
	return result, nil
}
