/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/generic"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type SamlTokenHandler func(string, *v3.SamlToken) (*v3.SamlToken, error)

type SamlTokenController interface {
	generic.ControllerMeta
	SamlTokenClient

	OnChange(ctx context.Context, name string, sync SamlTokenHandler)
	OnRemove(ctx context.Context, name string, sync SamlTokenHandler)
	Enqueue(name string)
	EnqueueAfter(name string, duration time.Duration)

	Cache() SamlTokenCache
}

type SamlTokenClient interface {
	Create(*v3.SamlToken) (*v3.SamlToken, error)
	Update(*v3.SamlToken) (*v3.SamlToken, error)

	Delete(name string, options *metav1.DeleteOptions) error
	Get(name string, options metav1.GetOptions) (*v3.SamlToken, error)
	List(opts metav1.ListOptions) (*v3.SamlTokenList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.SamlToken, err error)
}

type SamlTokenCache interface {
	Get(name string) (*v3.SamlToken, error)
	List(selector labels.Selector) ([]*v3.SamlToken, error)

	AddIndexer(indexName string, indexer SamlTokenIndexer)
	GetByIndex(indexName, key string) ([]*v3.SamlToken, error)
}

type SamlTokenIndexer func(obj *v3.SamlToken) ([]string, error)

type samlTokenController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewSamlTokenController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) SamlTokenController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &samlTokenController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromSamlTokenHandlerToHandler(sync SamlTokenHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.SamlToken
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.SamlToken))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *samlTokenController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.SamlToken))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateSamlTokenDeepCopyOnChange(client SamlTokenClient, obj *v3.SamlToken, handler func(obj *v3.SamlToken) (*v3.SamlToken, error)) (*v3.SamlToken, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *samlTokenController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *samlTokenController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *samlTokenController) OnChange(ctx context.Context, name string, sync SamlTokenHandler) {
	c.AddGenericHandler(ctx, name, FromSamlTokenHandlerToHandler(sync))
}

func (c *samlTokenController) OnRemove(ctx context.Context, name string, sync SamlTokenHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromSamlTokenHandlerToHandler(sync)))
}

func (c *samlTokenController) Enqueue(name string) {
	c.controller.Enqueue("", name)
}

func (c *samlTokenController) EnqueueAfter(name string, duration time.Duration) {
	c.controller.EnqueueAfter("", name, duration)
}

func (c *samlTokenController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *samlTokenController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *samlTokenController) Cache() SamlTokenCache {
	return &samlTokenCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *samlTokenController) Create(obj *v3.SamlToken) (*v3.SamlToken, error) {
	result := &v3.SamlToken{}
	return result, c.client.Create(context.TODO(), "", obj, result, metav1.CreateOptions{})
}

func (c *samlTokenController) Update(obj *v3.SamlToken) (*v3.SamlToken, error) {
	result := &v3.SamlToken{}
	return result, c.client.Update(context.TODO(), "", obj, result, metav1.UpdateOptions{})
}

func (c *samlTokenController) Delete(name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), "", name, *options)
}

func (c *samlTokenController) Get(name string, options metav1.GetOptions) (*v3.SamlToken, error) {
	result := &v3.SamlToken{}
	return result, c.client.Get(context.TODO(), "", name, result, options)
}

func (c *samlTokenController) List(opts metav1.ListOptions) (*v3.SamlTokenList, error) {
	result := &v3.SamlTokenList{}
	return result, c.client.List(context.TODO(), "", result, opts)
}

func (c *samlTokenController) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), "", opts)
}

func (c *samlTokenController) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (*v3.SamlToken, error) {
	result := &v3.SamlToken{}
	return result, c.client.Patch(context.TODO(), "", name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type samlTokenCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *samlTokenCache) Get(name string) (*v3.SamlToken, error) {
	obj, exists, err := c.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.SamlToken), nil
}

func (c *samlTokenCache) List(selector labels.Selector) (ret []*v3.SamlToken, err error) {

	err = cache.ListAll(c.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.SamlToken))
	})

	return ret, err
}

func (c *samlTokenCache) AddIndexer(indexName string, indexer SamlTokenIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.SamlToken))
		},
	}))
}

func (c *samlTokenCache) GetByIndex(indexName, key string) (result []*v3.SamlToken, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.SamlToken, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.SamlToken))
	}
	return result, nil
}
